%%% This code was written to be used in our publication              
%%% "Synaptotagmin 7 docks synaptic vesicles to support                 
%%% facilitation and Doc2α-triggered asynchronous release"          
%%% When reusing this code in a publication, in original or           
%%% modified form, please cite our work.                                                                                               
%%% Code authors:                               
%%% Manon M.M. Berns (manon.berns@sund.ku.dk)                   
%%% Alexander M. Walter (awalter@sund.ku.dk)         

%% This function calls varyparameters for different settings to perform the
%parameter space exploration. parameters are first varied one-by-one and
%after that in pairs.

%adjusted basename in line 43, to the folder path were the model
%simulations should be saved. Make sure that enough disk space is available
%here.

%% standard Settings of parameters
par(1) = 140 ;  % 1/(uM*s)
par(2) = 4000; % 1/s
par(3) = 27.978;
par(4) = 0.5;
par(5) = 28;  % 1/(M*s)
par(6) = 42; % 1/s
par(7) =10;
par(8) = 0.5;
par(9) = 28;  % 1/(M*s)
par(10) = 42; % 1/s
par(11) = 16;
par(12) = 0.5;
par(13) =200;
par(14) = 5;
par(15) = 5;
par(16) = 7;
par(17) = 7;
par(18) = 30; 
par(19) = 0.2; %tau
par(20) = 0.75; %Cares
par(21) = 3.5e-4;

%% Only vary Cares
Parvalues = {unique([par(20)./logspace(0,1,10),par(20).*logspace(0,1,10)])};
par_indx = 20;
KO_IO = 1;
 basename = 'folderpath';
 Varyparameters(Parvalues, par_indx, par, KO_IO, basename)
 disp('finished Cares')
 datetime('now')
[L, Async_wt, Async_syt7KO, Async_Doc2KO, docked_wt, docked_syt7KO, docked_doc2KO,Amplitutde_wt,Amplitutde_Syt7KO, Amplitutde_Doc2KO] = ExtractInfo(Parvalues, par_indx, par, KO_IO, basename);
save('20220803_VaryCares_extractedparameters.mat')

%% only vary Cadecay 
Parvalues = {unique([par(19)./logspace(0,1,10),par(19).*logspace(0,1,10)])};
par_indx = 19;
KO_IO = 1;
Varyparameters(Parvalues, par_indx, par, KO_IO, basename)
disp('finished Cadecay')
datetime('now')
[L, Async_wt, Async_syt7KO, Async_Doc2KO, docked_wt, docked_syt7KO, docked_doc2KO,Amplitutde_wt,Amplitutde_Syt7KO, Amplitutde_Doc2KO] = ExtractInfo(Parvalues, par_indx, par, KO_IO, basename);
save('20220803_VaryCadecay_extractedparameters.mat')

%% only vary Ca Amplitude
i = 18;
Parvalues = {unique([par(i)./logspace(0,1,10),par(i).*logspace(0,1,10)])};
par_indx = i;
KO_IO = 1;
Varyparameters(Parvalues, par_indx, par, KO_IO, basename)
disp('finished Ca Amplitude')
datetime('now')
[L, Async_wt, Async_syt7KO, Async_Doc2KO, docked_wt, docked_syt7KO, docked_doc2KO,Amplitutde_wt,Amplitutde_Syt7KO, Amplitutde_Doc2KO] = ExtractInfo(Parvalues, par_indx, par, KO_IO, basename);
save('20220803_VaryCaAmplitude_extractedparameters.mat')

%% only vary ktet
i = 16;
Parvalues = {unique([par(i)./logspace(0,1,10),par(i).*logspace(0,1,10)])};
par_indx = i;
KO_IO = 1;
Varyparameters(Parvalues, par_indx, par, KO_IO, basename)
disp('finished ketet')
datetime('now')
[L, Async_wt, Async_syt7KO, Async_Doc2KO, docked_wt, docked_syt7KO, docked_doc2KO,Amplitutde_wt,Amplitutde_Syt7KO, Amplitutde_Doc2KO] = ExtractInfo(Parvalues, par_indx, par, KO_IO, basename);
save('20220803_Varyktet_extractedparameters.mat')

%% only vary kprim
i = 14;
Parvalues = {unique([par(i)./logspace(0,1,10),par(i).*logspace(0,1,10)])};
par_indx = i;
KO_IO = 1;
Varyparameters(Parvalues, par_indx, par, KO_IO, basename)
disp('finished kprim')
datetime('now')
[L, Async_wt, Async_syt7KO, Async_Doc2KO, docked_wt, docked_syt7KO, docked_doc2KO,Amplitutde_wt,Amplitutde_Syt7KO, Amplitutde_Doc2KO] = ExtractInfo(Parvalues, par_indx, par, KO_IO, basename);
save('20220803_Varykprim_extractedparameters.mat')

%% only vary f2
i = 11;
Parvalues = {unique([par(i)./logspace(0,1,10),par(i).*logspace(0,1,10)])};
par_indx = i;
KO_IO = 1;
Varyparameters(Parvalues, par_indx, par, KO_IO, basename)
disp('finished f2')
datetime('now')
[L, Async_wt, Async_syt7KO, Async_Doc2KO, docked_wt, docked_syt7KO, docked_doc2KO,Amplitutde_wt,Amplitutde_Syt7KO, Amplitutde_Doc2KO] = ExtractInfo(Parvalues, par_indx, par, KO_IO, basename);
save('20220803_Varyf2_extractedparameters.mat')

%% only vary f7
i = 7;
Parvalues = {unique([par(i)./logspace(0,1,10),par(i).*logspace(0,1,10)])};
par_indx = i;
KO_IO = 1;
Varyparameters(Parvalues, par_indx, par, KO_IO, basename)
disp('finished f7')
datetime('now')
[L, Async_wt, Async_syt7KO, Async_Doc2KO, docked_wt, docked_syt7KO, docked_doc2KO,Amplitutde_wt,Amplitutde_Syt7KO, Amplitutde_Doc2KO] = ExtractInfo(Parvalues, par_indx, par, KO_IO, basename);
save('20220803_Varyf7_extractedparameters.mat')

%% only vary kon2
i = 9;
Parvalues = {unique([par(i)./logspace(0,1,10),par(i).*logspace(0,1,10)])};
par_indx = i;
KO_IO = 1;
Varyparameters(Parvalues, par_indx, par, KO_IO, basename)
disp('finished kon2')
datetime('now')
[L, Async_wt, Async_syt7KO, Async_Doc2KO, docked_wt, docked_syt7KO, docked_doc2KO,Amplitutde_wt,Amplitutde_Syt7KO, Amplitutde_Doc2KO] = ExtractInfo(Parvalues, par_indx, par, KO_IO, basename);
save('20220816_Varykon2_extractedparameters.mat')

%% only vary koff2
i = 10;
Parvalues = {unique([par(i)./logspace(0,1,10),par(i).*logspace(0,1,10)])};
par_indx = i;
KO_IO = 1;
Varyparameters(Parvalues, par_indx, par, KO_IO, basename)
disp('finished koff2')
datetime('now')
[L, Async_wt, Async_syt7KO, Async_Doc2KO, docked_wt, docked_syt7KO, docked_doc2KO,Amplitutde_wt,Amplitutde_Syt7KO, Amplitutde_Doc2KO] = ExtractInfo(Parvalues, par_indx, par, KO_IO, basename);
save('20220803_Varykoff2_extractedparameters.mat')

%% only vary kon7
i = 5;
Parvalues = {unique([par(i)./logspace(0,1,10),par(i).*logspace(0,1,10)])};
par_indx = i;
KO_IO = 1;
Varyparameters(Parvalues, par_indx, par, KO_IO, basename)
disp('finished kon7')
datetime('now')
[L, Async_wt, Async_syt7KO, Async_Doc2KO, docked_wt, docked_syt7KO, docked_doc2KO,Amplitutde_wt,Amplitutde_Syt7KO, Amplitutde_Doc2KO] = ExtractInfo(Parvalues, par_indx, par, KO_IO, basename);
save('20220816_Varykon7_extractedparameters.mat')

%% only vary koff7
i = 6;
Parvalues = {unique([par(i)./logspace(0,1,10),par(i).*logspace(0,1,10)])};
par_indx = i;
KO_IO = 1;
Varyparameters(Parvalues, par_indx, par, KO_IO, basename)
disp('finished koff7')
datetime('now')
[L, Async_wt, Async_syt7KO, Async_Doc2KO, docked_wt, docked_syt7KO, docked_doc2KO,Amplitutde_wt,Amplitutde_Syt7KO, Amplitutde_Doc2KO] = ExtractInfo(Parvalues, par_indx, par, KO_IO, basename);
save('20220803_Varykoff7_extractedparameters.mat')




%% covary Cares and Cadecay
Parvalues = {unique([par(19)./logspace(0,1,10),par(19).*logspace(0,1,10)]),unique([par(20)./logspace(0,1,10),par(20).*logspace(0,1,10)])};
par_indx=[19,20];
KO_IO = 0;
Varyparameters(Parvalues, par_indx, par, KO_IO, basename)
disp('finished Cares%Cadecay')
datetime('now')
[L, Async_wt, Async_syt7KO, Async_Doc2KO, docked_wt, docked_syt7KO, docked_doc2KO,Amplitutde_wt,Amplitutde_Syt7KO, Amplitutde_Doc2KO] = ExtractInfo(Parvalues, par_indx, par, KO_IO, basename);
save('20220803_VaryCaresanddecay_extractedparameters.mat')


%% Covary kprim and f7

Parvalues = {unique([par(14)./logspace(0,1,10),par(14).*logspace(0,1,10)]),unique([par(7)./logspace(0,1,10),par(7).*logspace(0,1,10)])};
par_indx=[14,7];
KO_IO = 0;
Varyparameters(Parvalues, par_indx, par, KO_IO, basename)
disp('finished kprim and f7')
datetime('now')
[L, Async_wt, Async_syt7KO, Async_Doc2KO, docked_wt, docked_syt7KO, docked_doc2KO,Amplitutde_wt,Amplitutde_Syt7KO, Amplitutde_Doc2KO] = ExtractInfo(Parvalues, par_indx, par, KO_IO, basename);
save('20220803_kprimandf7_extractedparameters.mat')

% Covary kon7 and Amplitude Ca
Parvalues = {unique([par(5)./logspace(0,2,10),par(5).*logspace(0,2,10)]),unique([par(18)./logspace(0,1,10),par(18).*logspace(0,1,10)])};
par_indx=[5,18];
KO_IO = 0;
Varyparameters(Parvalues, par_indx, par, KO_IO, basename)
disp('finished kon7 and Amplitude Ca')
datetime('now')
[L, Async_wt, Async_syt7KO, Async_Doc2KO, docked_wt, docked_syt7KO, docked_doc2KO,Amplitutde_wt,Amplitutde_Syt7KO, Amplitutde_Doc2KO] = ExtractInfo(Parvalues, par_indx, par, KO_IO, basename);
save('20220803_kon7andAmp_extractedparameters.mat')

%Covary Kon2 and resicual tau
Parvalues = {unique([par(9)./logspace(0,2,10),par(9).*logspace(0,2,10)]),unique([par(19)./logspace(0,1,10),par(19).*logspace(0,1,10)])};
par_indx=[9,19];
KO_IO = 0;
Varyparameters(Parvalues, par_indx, par, KO_IO, basename)
disp('finished kon2 and residual decay')
datetime('now')
[L, Async_wt, Async_syt7KO, Async_Doc2KO, docked_wt, docked_syt7KO, docked_doc2KO,Amplitutde_wt,Amplitutde_Syt7KO, Amplitutde_Doc2KO] = ExtractInfo(Parvalues, par_indx, par, KO_IO, basename);
save('20220803_kon2andresidualdecay_extractedparameters.mat')

% Covary f2 and kon2
Parvalues = {unique([par(11)./logspace(0,2,10),par(11).*logspace(0,2,10)]),unique([par(9)./logspace(0,2,10),par(9).*logspace(0,2,10)])};
par_indx=[11,9];
KO_IO = 0;
Varyparameters(Parvalues, par_indx, par, KO_IO, basename)
disp('finished kon2 and f2')
datetime('now')
[L, Async_wt, Async_syt7KO, Async_Doc2KO, docked_wt, docked_syt7KO, docked_doc2KO,Amplitutde_wt,Amplitutde_Syt7KO, Amplitutde_Doc2KO] = ExtractInfo(Parvalues, par_indx, par, KO_IO, basename);
save('20220803_kon2andf2_extractedparameters.mat')

% Covary ktet and residual amplitude
Parvalues = {unique([par(16)./logspace(0,1,10),par(16).*logspace(0,1,10)]),unique([par(20)./logspace(0,1,10),par(20).*logspace(0,1,10)])};
par_indx=[16,20];
KO_IO = 0;
Varyparameters(Parvalues, par_indx, par, KO_IO, basename)
disp('finished ktet and residualamplitude')
datetime('now')
[L, Async_wt, Async_syt7KO, Async_Doc2KO, docked_wt, docked_syt7KO, docked_doc2KO,Amplitutde_wt,Amplitutde_Syt7KO, Amplitutde_Doc2KO] = ExtractInfo(Parvalues, par_indx, par, KO_IO, basename);
save('20220803_ktetandresidualamplitude_extractedparameters.mat')

%%

% Covary residual calcium amplitude and f7
Parvalues = {unique([par(7)./logspace(0,1,10),par(7).*logspace(0,1,10)]),unique([par(20)./logspace(0,1,10),par(20).*logspace(0,1,10)])};
par_indx=[7,20];
KO_IO = 0;
Varyparameters(Parvalues, par_indx, par, KO_IO, basename)
disp('finished f7 and residualamplitude')
datetime('now')
[L, Async_wt, Async_syt7KO, Async_Doc2KO, docked_wt, docked_syt7KO, docked_doc2KO,Amplitutde_wt,Amplitutde_Syt7KO, Amplitutde_Doc2KO] = ExtractInfo(Parvalues, par_indx, par, KO_IO, basename);
save('20220803_f7andresidualamplitude_extractedparameters.mat')


%Covary residual calcium amplitude and f2
Parvalues = {unique([par(11)./logspace(0,1,10),par(11).*logspace(0,1,10)]),unique([par(20)./logspace(0,1,10),par(20).*logspace(0,1,10)])};
par_indx=[11,20];
KO_IO = 0;
Varyparameters(Parvalues, par_indx, par, KO_IO, basename)
disp('finished f2 and residualamplitude')
datetime('now')
[L, Async_wt, Async_syt7KO, Async_Doc2KO, docked_wt, docked_syt7KO, docked_doc2KO,Amplitutde_wt,Amplitutde_Syt7KO, Amplitutde_Doc2KO] = ExtractInfo(Parvalues, par_indx, par, KO_IO, basename);
save('20220803_f2andresidualamplitude_extractedparameters.mat')

%Covary residual calcium amplitude and kon2
Parvalues = {unique([par(9)./logspace(0,1,10),par(9).*logspace(0,1,10)]),unique([par(20)./logspace(0,1,10),par(20).*logspace(0,1,10)])};
par_indx=[9,20];
KO_IO = 0;
Varyparameters(Parvalues, par_indx, par, KO_IO, basename)
disp('finished kon2 and residualamplitude')
datetime('now')
[L, Async_wt, Async_syt7KO, Async_Doc2KO, docked_wt, docked_syt7KO, docked_doc2KO,Amplitutde_wt,Amplitutde_Syt7KO, Amplitutde_Doc2KO] = ExtractInfo(Parvalues, par_indx, par, KO_IO, basename);
save('20220803_kon2andresidualamplitude_extractedparameters.mat')

%Covary residual calcium amplitude and kon7
Parvalues = {unique([par(5)./logspace(0,1,10),par(5).*logspace(0,1,10)]),unique([par(20)./logspace(0,1,10),par(20).*logspace(0,1,10)])};
par_indx=[5,20];
KO_IO = 0;
Varyparameters(Parvalues, par_indx, par, KO_IO, basename)
disp('finished kon7 and residualamplitude')
datetime('now')
[L, Async_wt, Async_syt7KO, Async_Doc2KO, docked_wt, docked_syt7KO, docked_doc2KO,Amplitutde_wt,Amplitutde_Syt7KO, Amplitutde_Doc2KO] = ExtractInfo(Parvalues, par_indx, par, KO_IO, basename);
save('20220803_kon7andresidualamplitude_extractedparameters.mat')

%Covary Kon7 and f7
Parvalues = {unique([par(5)./logspace(0,1,10),par(5).*logspace(0,1,10)]),unique([par(7)./logspace(0,1,10),par(7).*logspace(0,1,10)])};
par_indx=[5,7];
KO_IO = 0;
Varyparameters(Parvalues, par_indx, par, KO_IO, basename)
disp('finished kon7 and f7')
datetime('now')
[L, Async_wt, Async_syt7KO, Async_Doc2KO, docked_wt, docked_syt7KO, docked_doc2KO,Amplitutde_wt,Amplitutde_Syt7KO, Amplitutde_Doc2KO] = ExtractInfo(Parvalues, par_indx, par, KO_IO, basename);
save('20220803_kon7andf7_extractedparameters.mat')

%Covary ktet and amplitude calcium
Parvalues = {unique([par(16)./logspace(0,1,10),par(16).*logspace(0,1,10)]),unique([par(18)./logspace(0,1,10),par(18).*logspace(0,1,10)])};
par_indx=[16,18];
KO_IO = 0;
Varyparameters(Parvalues, par_indx, par, KO_IO, basename)
disp('finished ktet and amplitude calcium')
datetime('now')
[L, Async_wt, Async_syt7KO, Async_Doc2KO, docked_wt, docked_syt7KO, docked_doc2KO,Amplitutde_wt,Amplitutde_Syt7KO, Amplitutde_Doc2KO] = ExtractInfo(Parvalues, par_indx, par, KO_IO, basename);
save('20220803_ktetandCaamplitude_extractedparameters.mat')

%Covary  kon7 amd tau
Parvalues = {unique([par(5)./logspace(0,1,10),par(5).*logspace(0,1,10)]),unique([par(19)./logspace(0,1,10),par(19).*logspace(0,1,10)])};
par_indx=[5,19];
KO_IO = 0;
Varyparameters(Parvalues, par_indx, par, KO_IO, basename)
disp('finished kon7 and tau')
datetime('now')
[L, Async_wt, Async_syt7KO, Async_Doc2KO, docked_wt, docked_syt7KO, docked_doc2KO,Amplitutde_wt,Amplitutde_Syt7KO, Amplitutde_Doc2KO] = ExtractInfo(Parvalues, par_indx, par, KO_IO, basename);
save('20220803_kon7andtau_extractedparameters.mat')

%Covary f7 and tau
Parvalues = {unique([par(7)./logspace(0,1,10),par(7).*logspace(0,1,10)]),unique([par(19)./logspace(0,1,10),par(19).*logspace(0,1,10)])};
par_indx=[7,19];
KO_IO = 0;
Varyparameters(Parvalues, par_indx, par, KO_IO, basename)
disp('finished f7 and tau')
datetime('now')
[L, Async_wt, Async_syt7KO, Async_Doc2KO, docked_wt, docked_syt7KO, docked_doc2KO,Amplitutde_wt,Amplitutde_Syt7KO, Amplitutde_Doc2KO] = ExtractInfo(Parvalues, par_indx, par, KO_IO, basename);
save('20220803_f7andtau_extractedparameters.mat')

%%
%Covary residual calcium amplitude and f2
Parvalues = {unique([par(11)./logspace(0,1,10),par(11).*logspace(0,1,10)]),unique([par(20)./logspace(0,1,10),par(20).*logspace(0,1,10)])};
par_indx=[11,20];
KO_IO = 0;
Varyparameters(Parvalues, par_indx, par, KO_IO, basename)
disp('finished f2 and residualamplitude')
datetime('now')
[L, Async_wt, Async_syt7KO, Async_Doc2KO, docked_wt, docked_syt7KO, docked_doc2KO,Amplitutde_wt,Amplitutde_Syt7KO, Amplitutde_Doc2KO] = ExtractInfo(Parvalues, par_indx, par, KO_IO, basename);
save('20220803_f2andresidualamplitude_extractedparameters.mat')

i = 11;
Parvalues = {unique([par(i)./logspace(0,1,10),par(i).*logspace(0,1,10)])};
par_indx = i;
KO_IO = 1;
Varyparameters(Parvalues, par_indx, par, KO_IO, basename)
disp('finished f2')
datetime('now')
[L, Async_wt, Async_syt7KO, Async_Doc2KO, docked_wt, docked_syt7KO, docked_doc2KO,Amplitutde_wt,Amplitutde_Syt7KO, Amplitutde_Doc2KO] = ExtractInfo(Parvalues, par_indx, par, KO_IO, basename);
save('20220803_Varyf2_extractedparameters.mat')


