%%% This code was written to be used in our publication              
%%% "Synaptotagmin 7 docks synaptic vesicles to support                 
%%% facilitation and Doc2α-triggered asynchronous release"          
%%% When reusing this code in a publication, in original or           
%%% modified form, please cite our work.                                                                                               
%%% Code authors:                               
%%% Manon M.M. Berns (manon.berns@sund.ku.dk)                   
%%% Alexander M. Walter (awalter@sund.ku.dk)                    
                                
%% This scripts runs the model for a predefined set of model parameters
% it returns some intial plots to evaluate the model results

%% Define model parameters
par = struct;
par.kon1 = 140;  % 1/(uM*s)
par.koff1 = 4000; % 1/s
par.f1 = 27.978;
par.b1 =0.5;
par.kon7 = 28;  % 1/(uM*s)
par.koff7 = 42; % 1/s
par.f7 =10;
par.b7 = 0.5;
par.kon2 = 28;  % 1/(uM*s)
par.koff2 = 42; % 1/s
par.f2 = 16;
par.b2 = 0.5;
par.nsites = 200;
par.K = 5;
par.Kun = 5;
par.Ktether = 7;
par.Kuntether = 7;
par.lplus = 3.5e-4; % 1/s


%% Compute steady state
Ca_bas = 0.05;
[Ves_ss] = calculate_steady_state(par, Ca_bas);

%% Calcium transient
freq = 20;%hz
no = 10; %number of APs to simulate

%generate local calcium transient
x = [0:1e-6:1/freq];
%y = normpdf(x,1.5e-3,4e-4);
y = normpdf(x,1.5e-3,2e-4);
y = y/max(y)*30; %local calcium transient with amplitude 30 uM
time = [0:1e-6:1/freq*no];
Ca= repmat(y, no); 

Casignal = [time; Ca(1,1:length(time))]';
Casignal(:,2)= Casignal(:,2) + 0.05; %addition of basal calcium concentration

%generation residual calcium transient
t0 = [1.6e-3:1/freq:1/freq*no]; t= Casignal(:,1);
tau2 = 0.2;A = 0.75; %amplitude resicual calcium uM
y1 =  exp(-((t-t0)./tau2))*A.*(t>=t0);
Casignal(:,2) = Casignal(:,2) + sum(y1,2); 
%smoothing calcium transient
km = 0.0001;
y2 = (-t0+t)./(-t0+t+km);
Casignal(:,2) = Casignal(:,2) + sum(y1.*y2,2);  

figure(); plot(Casignal(:,1), Casignal(:,2))
xlabel('time (s)')
ylabel('[Ca]')

%% solve dual sensor model
opt=[];
opts = odeset('MaxStep',1e-5,'RelTol',1e-5,'AbsTol',1e-5);
[t, Y]= MainModel_dualsensor(Casignal, par, Ves_ss, opts);

%% plotting initial results
figure();
plot(t, [sum(Y(:,1:3),2),sum(Y(:,4:6),2) ,sum(Y(:,7:24),2)] )
legend('Empty', 'tethered', 'docked')
xlabel('time (s)')
ylabel('number of vesicles')
ylim([0 200])

figure()
plot(t, Y(:, 26:28))
legend('0', '1','2')
title('states syt7')

%% plot fusion rate
sampling_rate=50e3; %hz; 
end_time=Casignal(end,1);
time_sample=0:1/sampling_rate:end_time;
fused_cum = interp1(t, Y(:,25),time_sample);
fused = diff(fused_cum,1);
figure(); plot(time_sample(1:end-1), fused)
xlabel('time (s)'); ylabel('fusion rate (vesicles/s)'); 

%% plot asynchronous release
fusion = diff(Y(:,25));
t_int_low = [10e-3:50e-3:2.5];
t_int_high = [50e-3:50e-3:2.5];
t_int_low_5 = [5e-3:50e-3:2.5];
for i = 1:length(t_int_low)
    Intervalsum_fusion_10(i) = sum(fusion(t>t_int_low(i)&t<t_int_high(i)));
end
cumsum_fusion_10 = cumsum(Intervalsum_fusion_10);
for i = 1:length(t_int_low_5)
    Intervalsum_fusion_5(i) = sum(fusion(t>t_int_low_5(i)&t<t_int_high(i)));
end
cumsum_fusion_5 = cumsum(Intervalsum_fusion_5);
figure(); plot([1:50], cumsum_fusion_5, 'LineWidth', 2); title('>10ms')
