function Run_dual_differentsettings()
%%% This code was written to be used in our publication              
%%% "Synaptotagmin 7 docks synaptic vesicles to support                 
%%% facilitation and Doc2α-triggered asynchronous release"          
%%% When reusing this code in a publication, in original or           
%%% modified form, please cite our work.                                                                                               
%%% Code authors:                               
%%% Manon M.M. Berns (manon.berns@sund.ku.dk)                   
%%% Alexander M. Walter (awalter@sund.ku.dk)         

%% This function simulates the model for different combinations of parameter settings

%change in line 15-20 the parameter values that should be evaluated
%% Define parameters to test
tau2 = [50e-3,0.1, 0.2, 300e-3, 0.5] ;
CaAmp = [25,30] ;
Caresidual = [0.5, 0.75, 1];
f7 = [10,12,14,16];
k = [2,5,7,10,12];
ktet = [2,5,7,10,12];

L = {tau2, CaAmp, Caresidual, f7, k, ktet};

n = length(L);
[L{:}] = ndgrid(L{end:-1:1});
L = cat(n+1,L{:});
L = fliplr(reshape(L,[],n));

%%
par = struct;
par.kon1 = 140;  % 1/(uM*s)
par.koff1 = 4000; % 1/s
par.f1 = 27.978;
par.b1 =0.5;
par.kon7 = 28;  % 1/(M*s)
par.koff7 = 42; % 1/s
par.f7 =10;
par.b7 = 0.5;
par.kon2 = 28;  % 1/(M*s)
par.koff2 = 42; % 1/s
par.f2 = 16;
par.b2 = 0.5;
par.nsites = 200;
par.K = 5;
par.Kun = 5;
par.Ktether = 7;
par.Kuntether = 7;

par.lplus = 3.5e-4; % 1/s
%%
parfor i = 1:length(L)
   
    %generate calcium signal
    freq = 20;
    no = 10;
    x = [0:1e-6:1/freq];
    y = normpdf(x,1.5e-3,2e-4);
    y = y/max(y)*L(i,2);
    time = [0:1e-6:1/freq*no];
    Ca= repmat(y, no);
    Casignal = [time; Ca(1,1:length(time))]';
    Casignal(:,2)= Casignal(:,2) + 0.05;
    t0 = [1.6e-3:1/freq:1/freq*no]; t= Casignal(:,1);
    tau2 = L(i,1);A = L(i,3);
    y1 =  exp(-((t-t0)./tau2))*A.*(t>=t0);
    km = 0.0001;
    y2 = (-t0+t)./(-t0+t+km);
   % Casignal(:,2) = Casignal(:,2) + sum(y1,2); 
   Casignal(:,2) = Casignal(:,2) + sum(y1.*y2,2);  
    
    % --- WT setting --- 
    param = par;
    param.f7 = L(i,4);
    param.K = L(i,5);
    param.Kun = L(i,5);
    param.Ktether = L(i,6);
    param.Kuntether = L(i,6);

    %compute steadystate
    Ca_bas = 0.05;
    [Ves_ss] = calculate_steady_state(param, Ca_bas);
    
    %Run sim
    opts = odeset('MaxStep',1e-5,'RelTol',1e-5,'AbsTol',1e-5);
    [t, Y]= MainModel_dualsensor(Casignal, param, Ves_ss, opts);
    
    fname = ['Workspace_220803_testsettings', num2str(i), '_WT.mat']
    parsave(fname, t,Y, par)
    
    % --- syt7Ko setting
    param.f7 = 1;
    
    %compute steadystate
    Ca_bas = 0.05;
    [Ves_ss] = calculate_steady_state(param, Ca_bas);
    
    %Run sim
    opts = odeset('MaxStep',1e-5,'RelTol',1e-5,'AbsTol',1e-5);
    [t, Y]= MainModel_dualsensor(Casignal, param, Ves_ss, opts);
    
    fname = ['Workspace_220803_testsettings', num2str(i), '_Syt7KO.mat']
    parsave(fname, t,Y, par)
    
    %-- Doc2KO settings
    param.f7 = L(i,4);
    param.kon2 = 0;
    
        %compute steadystate
    Ca_bas = 0.05;
    [Ves_ss] = calculate_steady_state(param, Ca_bas);
    
    %Run sim
    opts = odeset('MaxStep',1e-5,'RelTol',1e-5,'AbsTol',1e-5);
    [t, Y]= MainModel_dualsensor(Casignal, param, Ves_ss, opts);
    
    fname = ['Workspace_220803_testsettings', num2str(i), '_Doc2KO.mat']
    parsave(fname, t,Y, par)
    %
    disp(['finished setting ', num2str(i), '/' num2str(length(L))])
    

    
%     %DKO
%      param.kon1 = 140;
%      param.f7 = 1;
%      param.kon2 = 0;
%     
%             %compute steadystate
%     Ca_bas = 0.05;
%     [Ves_ss] = calculate_steady_state(param, Ca_bas);
%     
%     %Run sim
%     opts = odeset('MaxStep',1e-5,'RelTol',1e-5,'AbsTol',1e-5);
%     [t, Y]= MainModel_dualsensor(Casignal, param, Ves_ss, opts);
%     
%     fname = ['Workspace_220803_testsettings_', num2str(i), '_DKO.mat']
%     parsave(fname, t,Y, param)
    
end
    
    
    
    
    
    