function Varyparameters(Parvalues, par_indx, par_list, KO_IO, basename)
%%% This code was written to be used in our publication              
%%% "Synaptotagmin 7 docks synaptic vesicles to support                 
%%% facilitation and Doc2α-triggered asynchronous release"          
%%% When reusing this code in a publication, in original or           
%%% modified form, please cite our work.                                                                                               
%%% Code authors:                               
%%% Manon M.M. Berns (manon.berns@sund.ku.dk)                   
%%% Alexander M. Walter (awalter@sund.ku.dk)         

%% This function simulates the model for different combinations of parameter settings

%input:
%Parvlues - values of the parameters that need to be varied as a cell
%par_indx - index of the parameters that need to be varied
%par_list - array of parameter values
%KO_IO - whether or not to simulate the KO condition
%basename - folder path

%output is save in different files
%%
L = Parvalues;
n = length(L);
[L{:}] = ndgrid(L{end:-1:1});
L = cat(n+1,L{:});
L = fliplr(reshape(L,[],n));


parfor i = 1:length(L)
    
    par = par_list;
    %Define variables
    for j = 1:length(par_indx)
        par(par_indx(j))= L(i,j);
        if par_indx(j) == 16
            par(17) = par(16);
        elseif par_indx(j) == 14
            par(15) = par(14);
        elseif par_indx(j) ==  5
            par(6) = par(5)*1.5;
        elseif par_indx(j) == 9
            par(10) = par(9) * 1.5;
        end
    end
    
    param = struct;
    param.kon1 = par(1);  % 1/(uM*s)
    param.koff1 = par(2); % 1/s
    param.f1 = par(3);
    param.b1 =par(4);
    param.kon7 = par(5);  % 1/(M*s)
    param.koff7 = par(6); % 1/s
    param.f7 =par(7);
    param.b7 = par(8);
    param.kon2 = par(9);  % 1/(M*s)
    param.koff2 = par(10); % 1/s
    param.f2 = par(11);
    param.b2 = par(12);
    param.nsites = par(13);
    param.K = par(14);
    param.Kun = par(15);
    param.Ktether = par(16);
    param.Kuntether = par(17);
    param.lplus = par(21);
       
   
    %generate calcium signal
    freq = 20;
    no = 10;
    x = [0:1e-6:1/freq];
    y = normpdf(x,1.5e-3,2e-4);
    y = y/max(y)*par(18);
    time = [0:1e-6:1/freq*no];
    Ca= repmat(y, no);
    Casignal = [time; Ca(1,1:length(time))]';
    Casignal(:,2)= Casignal(:,2) + 0.05;
    t0 = [1.6e-3:1/freq:1/freq*no]; t= Casignal(:,1);
    tau2 = par(19); A = par(20);
    y1 =  exp(-((t-t0)./tau2))*A.*(t>=t0);
    km = 0.0001;
    y2 = (-t0+t)./(-t0+t+km);
    Casignal(:,2) = Casignal(:,2) + sum(y1.*y2,2);  
    
    % --- WT setting --- 

    %compute steadystate
    Ca_bas = 0.05;
    [Ves_ss] = calculate_steady_state(param, Ca_bas);
    
    %Run sim
    opts = odeset('MaxStep',1e-5,'RelTol',1e-5,'AbsTol',1e-5);
    [t, Y]= MainModel_dualsensor(Casignal, param, Ves_ss, opts);
    
    fname = [basename, 'Workspace_varypar_', num2str(par_indx), 'testsettings', num2str(i), '_WT.mat']
    parsave(fname, t,Y, param)
    
    if KO_IO
    
    % --- syt7Ko setting
    param.f7 = 1;
    
    %compute steadystate
    Ca_bas = 0.05;
    [Ves_ss] = calculate_steady_state(param, Ca_bas);
    
    %Run sim
    opts = odeset('MaxStep',1e-5,'RelTol',1e-5,'AbsTol',1e-5);
    [t, Y]= MainModel_dualsensor(Casignal, param, Ves_ss, opts);
    
    fname = [basename, 'Workspace_varypar_', num2str(par_indx), 'testsettings', num2str(i), '_Syt7KO.mat']
    parsave(fname, t,Y, param)
    
    %-- Doc2KO settings
    param.f7 = par(7);
    param.kon2 = 0;
    
        %compute steadystate
    Ca_bas = 0.05;
    [Ves_ss] = calculate_steady_state(param, Ca_bas);
    
    %Run sim
    opts = odeset('MaxStep',1e-5,'RelTol',1e-5,'AbsTol',1e-5);
    [t, Y]= MainModel_dualsensor(Casignal, param, Ves_ss, opts);
    
    fname =[basename, 'Workspace_varypar_', num2str(par_indx), 'testsettings', num2str(i),  '_Doc2KO.mat']
    parsave(fname, t,Y, param)
    end
    %
    disp(['finished setting ', num2str(i), '/' num2str(length(L))])
end