function [Ves_ss] = calculate_steady_state(par, Ca)

%%% This code was written to be used in our publication              
%%% "Synaptotagmin 7 docks synaptic vesicles to support                 
%%% facilitation and Doc2α-triggered asynchronous release"          
%%% When reusing this code in a publication, in original or           
%%% modified form, please cite our work.                                                                                               
%%% Code authors:                               
%%% Manon M.M. Berns (manon.berns@sund.ku.dk)                   
%%% Alexander M. Walter (awalter@sund.ku.dk)                    
                                
%% This scripts solves the steady state of the system

%input parameters:
% par - structure containing all parameters used in the model
% Ca - calcium concentration at which steady state is calculated in uM

%output parameters:
% Ves_ss - steady state solution of the system

%% Extract model parameters
kon1   = par.kon1;  % 1/(uM*s)
koff1  = par.koff1; % 1/s
f1     = par.f1;
b1     = par.b1;
kon7   = par.kon7;  % 1/(uM*s)
koff7  = par.koff7; % 1/s
f7     = par.f7;
b7     = par.b7;
kon2   = par.kon2;  % 1/(uM*s)
koff2  = par.koff2; % 1/s
f2     = par.f2;
b2     = par.b2;
nsites = par.nsites;
K = par.K;
Kun = par.Kun;
Ktether = par.Ktether;
Kuntether = par.Kuntether;
lplus = par.lplus; % 1/s

%% Generate itensity matrix - B
n = repmat([0:5]', 3,1); %number of syt1 bound to calcium
m= repmat([0:2], 6,1); m=m(:);
x = ones(18,1);

D = -(Kun*x + max(0, 5-(n+m)).*Ca*kon1 + n .* b1.^(n-1) * koff1 + min(max(0, 5-(n+m)),max(0, 2-m)).*Ca*kon2 + m.*b2.^(m-1)*koff2);
caDoc2 = min(max(0, 5-(n+m)),max(0, 2-(m)))*Ca*kon2;%calcium binding to doc2
e = max(0, 5-(n+m))*Ca*kon1;% calcium binding to syt

A = eye(18,18).*D;

Ax = diag(ones(18-abs(1),1),1);%matrix for calium unbinding
x = (n) .* b1.^(n-1) * koff1 ;%calcium unbinding to syt
Ae = diag(ones(18-abs(1),1),-1);%matrix for calium binding
Adoc2 = diag(ones(18-abs(6),1),-6);
caminDoc2 = (m+1).*b2.^m *koff2; %calcium unbinding to doc2
Adoc2min = diag(ones(18-abs(6),1),6);
A= A+ [1; e(1:end-1)].*Ae + Ax.*[x(2:end);1] + Adoc2.*[ones(6,1); caDoc2(1:end-6)]+caminDoc2.*Adoc2min;

B = [zeros(6,18); A];
B= [zeros(24,6), B]; 
B(2,1)= 2*kon2*Ca;
B(3,2) = 1*kon2*Ca;
B(5,4)= 2*kon2*Ca;
B(6,5) = 1*kon2*Ca;
B(1,2) = koff2;
B(2,3) = b2*2*koff2;
B(4,5) = koff2;
B(5,6) = b2*2*koff2;
B(4,1) = Ktether; B(5,2) = Ktether; B(6,3) = Ktether;
B(1,4) = Kuntether; B(3,6) = Kuntether; B(2,5) = Kuntether;
B(7,4) = K; B(13,5) = K; B(19,6) = K;
B(4, 7:12) = ones(6,1)*Kun; B(5, 13:18) = ones(6,1)*Kun; B(6, 19:24) = ones(6,1)*Kun;
for i = 1:6
B(i,i)  = -sum(B(:,i));
end


%% solve steady state for states described in B
Pi = zeros(24,1);
Pi(1) = nsites;
t = 1000;
Ves_ss = expm(B*t)*Pi;
%% add steady state for syt7
steady_syt7(1) = 1;
steady_syt7(2) = 2*kon7*Ca*steady_syt7(1)/(koff7);
steady_syt7(3) = kon7*Ca*steady_syt7(2)/(2*b7*koff7);
steady_syt7 = steady_syt7/(sum(steady_syt7));
Ves_ss(25) = 0;
Ves_ss(26:28) = steady_syt7;



           
           