clear
clc

global Monomer Bond Atype Btype BoxSize BeadSize BeadCsi BeadMass Temp kBT Damp RelaxationTime

RandStream.setGlobalStream(RandStream('mt19937ar','seed',sum(100*clock)));

load(['Parameter/Parameter.mat']);
load(['Parameter/DilutePhase.mat']);
BeadMass=Damp*BeadCsi;

InFolder='DilutePhase/In/';
OutFolder='Out/';
mkdir([InFolder OutFolder]);

index=0;
L1=[12,12,12,14,16];
NP=PolymerNumber;
VMODE{1}=['L1_' num2str(L1(1)) '_N1_' num2str(NP(1)) '_A2B2'];
VMODE{2}=['L1_' num2str(L1(2)) '_N1_' num2str(NP(2)) '_A3B3'];
VMODE{3}=['L1_' num2str(L1(3)) '_N1_' num2str(NP(3)) '_A6B6'];
VMODE{4}=['L1_' num2str(L1(4)) '_N1_' num2str(NP(4)) '_A8B6'];
VMODE{5}=['L1_' num2str(L1(5)) '_N1_' num2str(NP(5)) '_A10B6'];
Replicates=5;

for n=1:5
    for A=7
        mode=VMODE{n};
        Folder='InitialState_DilutePhase/';
        load([Folder mode '.mat']);
        InitCondFilename=[mode '.initial'];
        InitCondGenerate(InFolder,InitCondFilename);
        for rep=1:Replicates
            index=index+1;
            InFilename=['Polymer_Index_' num2str(index) '.in'];
            OutFilename=[OutFolder mode '_A'  num2str(A) '_Rep' num2str(rep)];
            InFileGenerate(InFolder,InFilename,InitCondFilename,OutFilename,A)
        end
    end
end

function []=InFileGenerate(InFolder,InFilename,InitCondFilename,OutFilename,A)

global BeadSize Temp kBT Damp

eps=kBT;
sigma=BeadSize;

Ai=-0*kBT;
Af=-A*kBT;
Rc=sigma/2;

K=0.15*kBT;
R0=10;


TimeStep=Damp/100;
RunSteps1=2.5*10^7;
RunSteps2=2*10^8;

Thermo=RunSteps2;

fid=fopen([InFolder InFilename],'w');
fprintf(fid, ['units nano\n']);
fprintf(fid, ['boundary p p p\n']);
fprintf(fid, ['atom_style bond\n\n']);

fprintf(fid, ['read_data ' InitCondFilename '\n\n']);

fprintf(fid, ['pair_style hybrid lj/cut ' num2str(sigma*2^(1/6)) ' soft ' num2str(Rc) '\n']);
fprintf(fid, ['pair_coeff 1 1 lj/cut ' num2str(eps) ' ' num2str(sigma) ' ' num2str(sigma*2^(1/6)) '\n']);
fprintf(fid, ['pair_coeff 2 2 lj/cut ' num2str(eps) ' ' num2str(sigma) ' ' num2str(sigma*2^(1/6)) '\n']);
fprintf(fid, ['pair_coeff 1 2 soft ' num2str(Ai) ' ' num2str(Rc) '\n']);
fprintf(fid, ['pair_modify shift yes\n']);
fprintf(fid, ['special_bonds lj/coul 1.0 1.0 1.0\n\n']);

fprintf(fid, ['bond_style fene\n']);
fprintf(fid, ['bond_coeff * ' num2str(K) ' ' num2str(R0) ' ' num2str(0) ' ' num2str(0) '\n\n']);

fprintf(fid, ['variable A equal "ramp(' num2str(Ai) ',' num2str(Af) ')"\n\n']);

fprintf(fid, ['neighbor ' num2str(R0-sigma*2^(1/6)) ' bin \n']);
fprintf(fid, ['neigh_modify every 1 delay 0\n\n']);

fprintf(fid, ['fix 1 all nve\n']);
fprintf(fid, ['fix 2 all langevin ' num2str(Temp) ' ' num2str(Temp) ' ' num2str(Damp) ' ' num2str(randi(10^7)) ' zero yes\n']);
fprintf(fid, ['fix 3 all adapt 1 pair soft a 1 2 v_A\n']);
fprintf(fid, ['\n']);

fprintf(fid, ['thermo ' num2str(Thermo) '\n']);
fprintf(fid, ['timestep ' num2str(TimeStep) '\n\n']);

fprintf(fid, ['dump 1 all movie ' num2str(RunSteps2/100) ' ' OutFilename '.mpeg type type zoom 2 box yes 0.01 bond type 0.3 view 85 85 size 1000 400 shiny 0.5\n']);
fprintf(fid, ['dump_modify 1 acolor 1 orange\n']); 
fprintf(fid, ['dump_modify 1 acolor 2 blue\n']);
fprintf(fid, ['dump_modify 1 bcolor 1 orange\n']); 
fprintf(fid, ['dump_modify 1 adiam 1 2.0\n']); 
fprintf(fid, ['dump_modify 1 adiam 2 2.0\n\n']);

fprintf(fid, ['run ' num2str(RunSteps1) '\n\n']);

fprintf(fid, ['unfix 3\n']);
fprintf(fid, ['pair_style hybrid lj/cut ' num2str(sigma*2^(1/6)) ' soft ' num2str(Rc) '\n']);
fprintf(fid, ['pair_coeff 1 1 lj/cut ' num2str(eps) ' ' num2str(sigma) ' ' num2str(sigma*2^(1/6)) '\n']);
fprintf(fid, ['pair_coeff 2 2 lj/cut ' num2str(eps) ' ' num2str(sigma) ' ' num2str(sigma*2^(1/6)) '\n']);
fprintf(fid, ['pair_coeff 1 2 soft ' num2str(Af) ' ' num2str(Rc) '\n']);
fprintf(fid, ['pair_modify shift yes\n']);
fprintf(fid, ['special_bonds lj/coul 1.0 1.0 1.0\n\n']);

fprintf(fid, ['run ' num2str(RunSteps1) '\n\n']);

fprintf(fid, ['run ' num2str(RunSteps2) '\n\n']);

fprintf(fid, ['write_restart ' OutFilename '.restart\n\n']);

fclose(fid); 

end

function []=InitCondGenerate(InFolder,InitCondFilename)

global Monomer Bond Atype Btype BoxSize BeadMass

Natom_type=2; %number of atom types;
Natom=length(Monomer);
Nbond_type=1; %number of bond types;
Nbond=length(Bond); %number of DNA bonds;
Nangl_type=0;  %number of angle types;
Nangl=0; %number of angles;
Ndihe_type=0; %number of dihedral types;
Ndihe=0; %number of dihedrals;
Nimpr_type=0; %number of improper types;
Nimpr=0; %number of impropers;

xlo=-BoxSize(1)/2; xhi=BoxSize(1)/2; %x boundary
ylo=-BoxSize(2)/2; yhi=BoxSize(2)/2; %y boundary
zlo=-BoxSize(3)/2; zhi=BoxSize(3)/2; %z boundary

V=zeros(3,Natom);

fid=fopen([InFolder InitCondFilename],'w');
fprintf(fid,'LAMMPS chain data file\n\n');
fprintf(fid,'%d atoms\n', Natom);
fprintf(fid,'%d bonds\n', Nbond);
fprintf(fid,'%d angles\n', Nangl);
fprintf(fid,'%d dihedrals\n', Ndihe);
fprintf(fid,'%d impropers\n\n', Nimpr);
fprintf(fid,'%d atom types\n', Natom_type);
fprintf(fid,'%d bond types\n', Nbond_type);
fprintf(fid,'%d angle types\n', Nangl_type);
fprintf(fid,'%d dihedral types\n', Ndihe_type);
fprintf(fid,'%d improper types\n\n', Nimpr_type);
fprintf(fid,'%8.5f %8.5f xlo xhi\n', xlo, xhi);
fprintf(fid,'%8.5f %8.5f ylo yhi\n', ylo, yhi);
fprintf(fid,'%8.5f %8.5f zlo zhi\n\n', zlo, zhi);

fprintf(fid,'Masses\n\n');
fprintf(fid,'%d %8.5f\n',1,BeadMass);
fprintf(fid,'%d %8.5f\n\n',2,BeadMass);

fprintf(fid,'Atoms\n\n');
for i=1:Natom
    Mole_type=1;
    Atom_type=Atype(i);
    fprintf(fid,[num2str(i) ' ' num2str(Mole_type) ' ' num2str(Atom_type) ' ' ...
                 num2str(Monomer(1,i)) ' ' num2str(Monomer(2,i)) ' ' num2str(Monomer(3,i)) '\n']);
end
fprintf(fid,'\n');

fprintf(fid,'Velocities\n\n');
for i=1:Natom
    fprintf(fid,[num2str(i) ' ' num2str(V(1,i)) ' ' num2str(V(2,i)) ' ' num2str(V(3,i)) '\n']);
end
fprintf(fid,'\n');

fprintf(fid,'Bonds\n\n');
for i=1:Nbond
    fprintf(fid,'%d %d %d %d\n',...
            i,Btype(i),Bond(1,i),Bond(2,i));
end
fprintf(fid,'\n');

fclose(fid); 
end

