clear
clc

global Monomer Bond Atype Btype BoxSize BeadSize BeadCsi BeadMass Temp kBT Damp RelaxationTime

RandStream.setGlobalStream(RandStream('mt19937ar','seed',sum(100*clock)));

load(['Parameter/Parameter.mat']);
% Damp=5;
BeadMass=Damp*BeadCsi;

InFolder='FullSystem/In_Droplet/';
OutFolder='Out/';
mkdir([InFolder OutFolder]);

index=0;
L1=12;
NP=2000;
NM=NP*L1;
VMODE=['L1_' num2str(L1) '_N1_' num2str(NP) '_A6B6'];
Replicates=10;

mode=VMODE;
Folder='InitialState_FullSystem/';
load([Folder mode '.mat']);
InitCondFilename=[mode '.initial'];
for A=7
    for rep=1:Replicates
        index=index+1;
        InFilename=['Polymer_Index_' num2str(index) '.in'];
        OutFilename=[OutFolder mode '_A'  num2str(A) '_Rep' num2str(rep)];
        InFileGenerate(InFolder,InFilename,InitCondFilename,OutFilename,A)
        InitCondGenerate(InFolder,InitCondFilename)
    end
end

function []=InFileGenerate(InFolder,InFilename,InitCondFilename,OutFilename,A)

global BeadSize Temp kBT Damp

eps=kBT;
sigma=BeadSize;

Ai=-0*kBT;
Af=-A*kBT;
Rc=sigma/2;

% K=1.2*kBT;
% R0=4;

% K=0.6*kBT;
% R0=5;
% K=0.4*kBT;
% R0=6;

K=0.15*kBT;
R0=10;

DeltaF=A2DeltaF(A,Rc);

TimeStep=Damp/100;
RunSteps=10^8;

Thermo=RunSteps;

fid=fopen([InFolder InFilename],'w');
fprintf(fid, ['units nano\n']);
fprintf(fid, ['boundary p p p\n']);
fprintf(fid, ['atom_style bond\n\n']);

%fprintf(fid, ['processors 2 * *\n\n']);

fprintf(fid, ['read_data ' InitCondFilename '\n\n']);

fprintf(fid, ['pair_style hybrid lj/cut ' num2str(sigma*2^(1/6)) ' soft ' num2str(Rc) '\n']);
fprintf(fid, ['pair_coeff 1 1 lj/cut ' num2str(eps) ' ' num2str(sigma) ' ' num2str(sigma*2^(1/6)) '\n']);
fprintf(fid, ['pair_coeff 2 2 lj/cut ' num2str(eps) ' ' num2str(sigma) ' ' num2str(sigma*2^(1/6)) '\n']);
fprintf(fid, ['pair_coeff 1 2 soft ' num2str(Ai) ' ' num2str(Rc) '\n']);
fprintf(fid, ['pair_modify shift yes\n']);
fprintf(fid, ['special_bonds lj/coul 1.0 1.0 1.0\n\n']);

% fprintf(fid, ['bond_style fene/expand\n']);
% fprintf(fid, ['bond_coeff * ' num2str(K) ' ' num2str(R0) ' ' num2str(0) ' ' num2str(0) ' ' num2str(sigma) '\n\n']);
fprintf(fid, ['bond_style fene\n']);
fprintf(fid, ['bond_coeff * ' num2str(K) ' ' num2str(R0) ' ' num2str(0) ' ' num2str(0) '\n\n']);

fprintf(fid, ['variable A equal "ramp(' num2str(Ai) ',' num2str(Af) ')"\n\n']);

fprintf(fid, ['group gr1 molecule 1\n']);
fprintf(fid, ['group gr2 molecule 2\n\n']);

Rb=55;
fprintf(fid, ['region sphere1 sphere 0.0 0.0 0.0 ' num2str(Rb) ' side in\n']);
fprintf(fid, ['region sphere2 sphere 0.0 0.0 0.0 ' num2str(Rb) ' side out\n\n']);

fprintf(fid, ['neighbor ' num2str(R0-sigma*2^(1/6)) ' bin \n']);
fprintf(fid, ['neigh_modify every 1 delay 0\n\n']);

fprintf(fid, ['fix 1 all nve\n']);
fprintf(fid, ['fix 2 all langevin ' num2str(Temp) ' ' num2str(Temp) ' ' num2str(Damp) ' ' num2str(randi(10^7)) ' zero yes\n']);
fprintf(fid, ['fix 3 all adapt 1 pair soft a 1 2 v_A\n']);
fprintf(fid, ['fix 4 gr1 wall/region sphere1 lj126 ' num2str(eps) ' ' num2str(sigma) ' ' num2str(sigma*2^(1/6)) '\n']);
fprintf(fid, ['fix 5 gr2 wall/region sphere2 lj126 ' num2str(eps) ' ' num2str(sigma) ' ' num2str(sigma*2^(1/6)) '\n']);
fprintf(fid, ['fix 6 all balance ' num2str(RunSteps/1000) ' 1.05 shift xyz 10 1.05\n\n']);
%
fprintf(fid, ['thermo ' num2str(Thermo) '\n']);
fprintf(fid, ['timestep ' num2str(TimeStep) '\n\n']);

%fprintf(fid, ['dump 1 all movie ' num2str(RunSteps/1000) ' ' OutFilename '.mpeg type type zoom 4 box yes 0.01 bond type 0.3 view 85 85 size 1000 400 shiny 0.5\n']);
fprintf(fid, ['dump 1 all movie ' num2str(RunSteps/100) ' ' OutFilename '.mpeg mol type zoom 1.2 box yes 0.005 bond type 0.1 view 75 75 size 800 800 shiny 0.5\n']);
% fprintf(fid, ['dump_modify 1 acolor 1 orange\n']); 
% fprintf(fid, ['dump_modify 1 acolor 2 blue\n']);
% fprintf(fid, ['dump_modify 1 bcolor 1 orange\n']); 
fprintf(fid, ['dump_modify 1 adiam 1 2.0\n']); 
fprintf(fid, ['dump_modify 1 adiam 2 2.0\n\n']);

fprintf(fid, ['run ' num2str(RunSteps*0.4) '\n\n']);

fprintf(fid, ['unfix 3\n']);
fprintf(fid, ['pair_style hybrid lj/cut ' num2str(sigma*2^(1/6)) ' soft ' num2str(Rc) '\n']);
fprintf(fid, ['pair_coeff 1 1 lj/cut ' num2str(eps) ' ' num2str(sigma) ' ' num2str(sigma*2^(1/6)) '\n']);
fprintf(fid, ['pair_coeff 2 2 lj/cut ' num2str(eps) ' ' num2str(sigma) ' ' num2str(sigma*2^(1/6)) '\n']);
fprintf(fid, ['pair_coeff 1 2 soft ' num2str(Af) ' ' num2str(Rc) '\n']);
fprintf(fid, ['pair_modify shift yes\n']);
fprintf(fid, ['special_bonds lj/coul 1.0 1.0 1.0\n\n']);

fprintf(fid, ['run ' num2str(RunSteps*0.1) '\n\n']);

fprintf(fid, ['unfix 4\n']);
fprintf(fid, ['unfix 5\n']);

fprintf(fid, ['dump 2 all xyz ' num2str(RunSteps/100) ' ' OutFilename '.xyz\n']); 
fprintf(fid, ['run ' num2str(RunSteps*0.5) '\n\n']);

%fprintf(fid, ['dump 2 all xyz ' num2str(RunSteps/300) ' ' OutFilename '.xyz\n']); 
%fprintf(fid, ['run ' num2str(RunSteps) '\n\n']);

fprintf(fid, ['write_restart ' OutFilename '.restart\n\n']);

fclose(fid); 

end

function []=InitCondGenerate(InFolder,InitCondFilename)

global Monomer Bond Atype Btype BoxSize BeadMass

Natom_type=2; %number of atom types;
Natom=length(Monomer);
Nbond_type=1; %number of bond types;
Nbond=length(Bond); %number of DNA bonds;
Nangl_type=0;  %number of angle types;
Nangl=0; %number of angles;
Ndihe_type=0; %number of dihedral types;
Ndihe=0; %number of dihedrals;
Nimpr_type=0; %number of improper types;
Nimpr=0; %number of impropers;

xlo=-BoxSize(1)/2; xhi=BoxSize(1)/2; %x boundary
ylo=-BoxSize(2)/2; yhi=BoxSize(2)/2; %y boundary
zlo=-BoxSize(3)/2; zhi=BoxSize(3)/2; %z boundary

V=zeros(3,Natom);

fid=fopen([InFolder InitCondFilename],'w');
fprintf(fid,'LAMMPS chain data file\n\n');
fprintf(fid,'%d atoms\n', Natom);
fprintf(fid,'%d bonds\n', Nbond);
fprintf(fid,'%d angles\n', Nangl);
fprintf(fid,'%d dihedrals\n', Ndihe);
fprintf(fid,'%d impropers\n\n', Nimpr);
fprintf(fid,'%d atom types\n', Natom_type);
fprintf(fid,'%d bond types\n', Nbond_type);
fprintf(fid,'%d angle types\n', Nangl_type);
fprintf(fid,'%d dihedral types\n', Ndihe_type);
fprintf(fid,'%d improper types\n\n', Nimpr_type);
fprintf(fid,'%8.5f %8.5f xlo xhi\n', xlo, xhi);
fprintf(fid,'%8.5f %8.5f ylo yhi\n', ylo, yhi);
fprintf(fid,'%8.5f %8.5f zlo zhi\n\n', zlo, zhi);

fprintf(fid,'Masses\n\n');
fprintf(fid,'%d %8.5f\n',1,BeadMass);
fprintf(fid,'%d %8.5f\n\n',2,BeadMass);

fprintf(fid,'Atoms\n\n');
for i=1:Natom
    if i<=12*1000
        Mole_type=1;
    else 
        Mole_type=2;
    end
    Atom_type=Atype(i);
    fprintf(fid,[num2str(i) ' ' num2str(Mole_type) ' ' num2str(Atom_type) ' ' ...
                 num2str(Monomer(1,i)) ' ' num2str(Monomer(2,i)) ' ' num2str(Monomer(3,i)) '\n']);
end
fprintf(fid,'\n');

fprintf(fid,'Velocities\n\n');
for i=1:Natom
    fprintf(fid,[num2str(i) ' ' num2str(V(1,i)) ' ' num2str(V(2,i)) ' ' num2str(V(3,i)) '\n']);
end
fprintf(fid,'\n');

fprintf(fid,'Bonds\n\n');
for i=1:Nbond
    fprintf(fid,'%d %d %d %d\n',...
            i,Btype(i),Bond(1,i),Bond(2,i));
end
fprintf(fid,'\n');

fclose(fid); 
end


function DeltaF=A2DeltaF(A,rcut)
dr=10^-4;
r=dr/2:dr:(rcut-dr/2);
DeltaF=zeros(length(A),1);
for na=1:length(A)
    DeltaF(na,1)=log(sum(4*pi*r.^2.*exp(U_Soft(r,A(na),rcut)))*dr/sum(4*pi*r.^2*dr));
end
end

function y=U_Soft(r,A,rcut)
y=A*(1+cos(r*pi/rcut)).*(r<rcut);
end