clear
clc

global Monomer Bond Atype Btype BoxSize BeadSize BeadCsi BeadMass Temp kBT Damp RelaxationTime

RandStream.setGlobalStream(RandStream('mt19937ar','seed',sum(100*clock)));

load(['Parameter/Parameter.mat']);
% Damp=5;
BeadMass=Damp*BeadCsi;

InFolder='FullSystem/In_A/';
%mkdir(InFolder)

index=0;
L1=12;
NP=1000;
NM=NP*L1;

VMODE{1}=['L1_' num2str(L1(1)) '_N1_' num2str(NP) '_A6B6'];

Replicates=10;
for n=1
    for A=[6.75,7.25,7.5]
        OutFolder=['Out_Record_A' num2str(A) '/'];
        mkdir([InFolder OutFolder]);
        for rep=1:Replicates
            mode=VMODE{n};
            index=index+1;
            InFilename=['Record_Index_' num2str(index) '.in'];
            InitCondFilename=['Out_A' num2str(A) '/' mode '_A' num2str(A) '_Rep' num2str(rep) '.restart'];
            OutFilename=[OutFolder mode '_A' num2str(A) '_Rep' num2str(rep)];
            InFileGenerate(InFolder,InFilename,InitCondFilename,OutFilename,A)
        end
    end
end

function []=InFileGenerate(InFolder,InFilename,InitCondFilename,OutFilename,A)

global BeadSize Temp kBT Damp

eps=kBT;
sigma=BeadSize;

Af=-A*kBT;
Rc=sigma/2;

K=0.15*kBT;
R0=10;


TimeStep=Damp/100;
RunSteps=2*10^8;
Thermo=RunSteps;

fid=fopen([InFolder InFilename],'w');
fprintf(fid, ['processors 2 * *\n\n']);
fprintf(fid, ['read_restart ' InitCondFilename '\n\n']);

fprintf(fid, ['pair_style hybrid lj/cut ' num2str(sigma*2^(1/6)) ' soft ' num2str(Rc) '\n']);
fprintf(fid, ['pair_coeff 1 1 lj/cut ' num2str(eps) ' ' num2str(sigma) ' ' num2str(sigma*2^(1/6)) '\n']);
fprintf(fid, ['pair_coeff 2 2 lj/cut ' num2str(eps) ' ' num2str(sigma) ' ' num2str(sigma*2^(1/6)) '\n']);
fprintf(fid, ['pair_coeff 1 2 soft ' num2str(Af) ' ' num2str(Rc) '\n']);
fprintf(fid, ['pair_modify shift yes\n']);
fprintf(fid, ['special_bonds lj/coul 1.0 1.0 1.0\n\n']);

fprintf(fid, ['bond_style fene\n']);
fprintf(fid, ['bond_coeff * ' num2str(K) ' ' num2str(R0) ' ' num2str(0) ' ' num2str(0) '\n\n']);


fprintf(fid, ['neighbor ' num2str(R0-sigma*2^(1/6)) ' bin \n']);
fprintf(fid, ['neigh_modify every 1 delay 0\n\n']);

fprintf(fid, ['fix 1 all nve\n']);
fprintf(fid, ['fix 2 all langevin ' num2str(Temp) ' ' num2str(Temp) ' ' num2str(Damp) ' ' num2str(randi(10^7)) ' zero yes\n']);
fprintf(fid, ['fix 3 all balance ' num2str(RunSteps/200) ' 1.05 shift x 10 1.05\n\n']);

fprintf(fid, ['thermo ' num2str(Thermo) '\n']);
fprintf(fid, ['timestep ' num2str(TimeStep) '\n\n']);

fprintf(fid, ['dump 1 all movie ' num2str(RunSteps/200) ' ' OutFilename '.mpeg type type zoom 4 box yes 0.01 bond type 0.3 view 85 85 size 1000 400 shiny 0.5\n']);
fprintf(fid, ['dump_modify 1 acolor 1 orange\n']); 
fprintf(fid, ['dump_modify 1 acolor 2 blue\n']);
fprintf(fid, ['dump_modify 1 bcolor 1 orange\n']); 
fprintf(fid, ['dump_modify 1 adiam 1 2.0\n']); 
fprintf(fid, ['dump_modify 1 adiam 2 2.0\n\n']);

fprintf(fid, ['dump 2 all xyz ' num2str(RunSteps/800) ' ' OutFilename '.xyz\n']); 
fprintf(fid, ['run ' num2str(RunSteps) '\n\n']);

fprintf(fid, ['write_restart ' OutFilename '.restart\n\n']);

fclose(fid); 

end


function DeltaF=A2DeltaF(A,rcut)
dr=10^-4;
r=dr/2:dr:(rcut-dr/2);
DeltaF=zeros(length(A),1);
for na=1:length(A)
    DeltaF(na,1)=log(sum(4*pi*r.^2.*exp(U_Soft(r,A(na),rcut)))*dr/sum(4*pi*r.^2*dr));
end
end

function y=U_Soft(r,A,rcut)
y=A*(1+cos(r*pi/rcut)).*(r<rcut);
end