clear
clc

Folder='InitialState_DensePhase/';
mkdir(Folder)

L1=[12,12,12,14,16];
NP=1000;
NM=NP*L1;
VMODE{1}=['L1_' num2str(L1(1)) '_N1_' num2str(NP) '_A2B2'];
VMODE{2}=['L1_' num2str(L1(2)) '_N1_' num2str(NP) '_A3B3'];
VMODE{3}=['L1_' num2str(L1(3)) '_N1_' num2str(NP) '_A6B6'];
VMODE{4}=['L1_' num2str(L1(4)) '_N1_' num2str(NP) '_A8B6'];
VMODE{5}=['L1_' num2str(L1(5)) '_N1_' num2str(NP) '_A10B6'];

atype=zeros(16,5);
atype(:,1)=[1,1,2,2,1,1,2,2,1,1,2,2,0,0,0,0]; 
atype(:,2)=[1,1,1,2,2,2,1,1,1,2,2,2,0,0,0,0];
atype(:,3)=[1,1,1,1,1,1,2,2,2,2,2,2,0,0,0,0]; 
atype(:,4)=[1,1,1,1,1,1,1,1,2,2,2,2,2,2,0,0]; 
atype(:,5)=[1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2];

for n=1:5

load('Parameter/DensePhase.mat')
mode=VMODE{n};
BoxSize(1)=BoxLength(n);
BoxSize(2)=50;
BoxSize(3)=50;

NB=23;
x1=([-1 1])*L1(n);
y1=((1:NB)-(NB+1)/2)*(BoxSize(2)/NB);
z1=((1:NB)-(NB+1)/2)*(BoxSize(2)/NB);

[X1,Y1,Z1]=meshgrid(x1,y1,z1);
X1=reshape(X1,[],1);
Y1=reshape(Y1,[],1);
Z1=reshape(Z1,[],1);
    
Polymer1=zeros(3,L1(n),NP);

for np=1:NP
    Polymer1(1,:,np)=(1:L1(n))*2-mean(1:L1(n))*2+X1(np,1);
    Polymer1(2,:,np)=Y1(np,1);
    Polymer1(3,:,np)=Z1(np,1);
end
    
figure(n)
for np=1:NP
  	plot3(Polymer1(1,:,np),Polymer1(2,:,np),Polymer1(3,:,np),'b.-'); hold on
end
axis equal
axis([-BoxSize(1)/2 BoxSize(1)/2 -BoxSize(2)/2 BoxSize(2)/2 -BoxSize(3)/2 BoxSize(3)/2])

Monomer=zeros(3,NM(n));
NB=(L1(n)-1)*NP;
Bond=zeros(1,NB);
Btype=zeros(1,NB);
Atype=zeros(1,NM(n));

nm=0;
nb=0;

for np=1:NP
    for l=1:L1(n)
       	nm=nm+1;
       	Monomer(1,nm)=Polymer1(1,l,np);
       	Monomer(2,nm)=Polymer1(2,l,np);
       	Monomer(3,nm)=Polymer1(3,l,np);
        Atype(1,nm)=atype(l,n);
      	if l~=L1(n)
         	nb=nb+1;
           	Bond(1,nb)=nm;
           	Bond(2,nb)=nm+1;
           	Btype(1,nb)=1;
        end
    end
end
save([Folder mode '.mat'],'Monomer','Bond','Atype','Btype','BoxSize');
end



