clear
clc

Folder='InitialState_FullSystem/';
mkdir(Folder)

Cden=7.744282616;
Cdil=0.049660541251384;
Cden=Cden*6.02*10^23/10^27; % per nm^3
Cdil=Cdil*6.02*10^23/10^27; 

% Ndil=(300^3-10000/Cden)/(1/Cdil-1/Cden)
% Ndil=300^3*Cdil
% %%

Nden=1000;
Ndil=1000;
(Nden/Cden/(4*pi/3))^(1/3)
(Ndil/Cdil+Nden/Cden)^(1/3)

%(5000/Cdil)^(1/3)

L1=12;
NP=Nden+Ndil;
NM=NP*L1;
VMODE=['L1_' num2str(L1) '_N1_' num2str(NP) '_A6B6'];
atype=[1,1,1,1,1,1,2,2,2,2,2,2]; 
mode=VMODE;

BoxSize(1)=286;
BoxSize(2)=BoxSize(1);
BoxSize(3)=BoxSize(1);

NB=23;
x1=[-1 1]*2.25*7;
y1=((1:NB)-(NB+1)/2)*2;
z1=((1:NB)-(NB+1)/2)*2;

[X1,Y1,Z1]=meshgrid(x1,y1,z1);
X1=reshape(X1,[],1);
Y1=reshape(Y1,[],1);
Z1=reshape(Z1,[],1);

Polymer1=zeros(3,L1,Nden);

for np=1:Nden
    Polymer1(1,:,np)=(1:L1)*2.25-mean(1:L1)*2.25+X1(np,1);
    Polymer1(2,:,np)=Y1(np,1);
    Polymer1(3,:,np)=Z1(np,1);
end
    
figure(1)
for np=1:Nden
  	plot3(Polymer1(1,:,np),Polymer1(2,:,np),Polymer1(3,:,np),'b.-'); hold on
end

max(max((Polymer1(1,:,:).^2+Polymer1(2,:,:).^2+Polymer1(3,:,:).^2).^0.5))

NB=18;
x1=((1:NB)-(NB+1)/2)*(BoxSize(1)/NB);
y1=((1:NB)-(NB+1)/2)*(BoxSize(1)/NB);
z1=((1:NB)-(NB+1)/2)*(BoxSize(1)/NB);

[X1,Y1,Z1]=meshgrid(x1,y1,z1);
X1=reshape(X1,[],1);
Y1=reshape(Y1,[],1);
Z1=reshape(Z1,[],1);

RDrop=70;
for i=1:NB^3
    if abs(X1(i,1))>RDrop || abs(Y1(i,1))>RDrop || abs(Z1(i,1))>RDrop
        if i==1
            Index=i;
        else
            Index=[Index i];
        end
    end
end
Index=Index(randperm(length(Index)));
X1=X1(Index);
Y1=Y1(Index);
Z1=Z1(Index);

for np=1:Ndil    
    Polymer1(1,:,np+Nden)=(1:L1)*2.25-mean(1:L1)*2.25+X1(np,1);
    Polymer1(2,:,np+Nden)=Y1(np,1);
    Polymer1(3,:,np+Nden)=Z1(np,1);
end
    
figure(1)
for np=Nden+(1:Ndil)
  	plot3(Polymer1(1,:,np),Polymer1(2,:,np),Polymer1(3,:,np),'.-'); hold on
end

axis equal
axis([-BoxSize(1)/2 BoxSize(1)/2 -BoxSize(2)/2 BoxSize(2)/2 -BoxSize(3)/2 BoxSize(3)/2])

Monomer=zeros(3,NM);
NB=(L1-1)*NP;
Bond=zeros(1,NB);
Btype=zeros(1,NB);
Atype=zeros(1,NM);

nm=0;
nb=0;

for np=1:NP
    for l=1:L1
       	nm=nm+1;
       	Monomer(1,nm)=Polymer1(1,l,np);
       	Monomer(2,nm)=Polymer1(2,l,np);
       	Monomer(3,nm)=Polymer1(3,l,np);
        Atype(1,nm)=atype(l);
      	if l~=L1
         	nb=nb+1;
           	Bond(1,nb)=nm;
           	Bond(2,nb)=nm+1;
           	Btype(1,nb)=1;
        end
    end
end
save([Folder mode '.mat'],'Monomer','Bond','Atype','Btype','BoxSize');



