dir1 = getDirectory("Choose Image Directory");
list = getFileList(dir1);
dir2 = getDirectory("Choose Destination Directory: ROI_Surface");
dir3 = getDirectory("Choose Destination Directory: ROI_CellCount");



setBatchMode(true);


for (i=0; i<list.length; i++) {
 showProgress(i+1, list.length);
 open(dir1+list[i]); 
 title = File.nameWithoutExtension ;
 run("Set Scale...", "distance=353.8 known=1 unit=mm global");
    run("Split Channels");

selectWindow(File.name+" (blue)");
 close(); //Closes Blue channel

selectWindow(File.name+" (red)");
close(); //Closes Red channel

//Green channel (ROI volume)
run("Gamma...", "value=0.06"); wait(20);
run("Brightness/Contrast...");
setMinAndMax(127, 128);
run("Apply LUT"); wait(20);
//run("Threshold...");
setThreshold(5, 255);
setOption("BlackBackground", true);
run("Convert to Mask"); wait(20);
saveAs("TIFF", dir2+title+"_ROI_Surface.Tif");
run("Analyze Particles...", "summarize");
close("*");
   
 }
 saveAs("Results", dir2+"ROI_Surfaces.csv");
 run("Close");


for (i=0; i<list.length; i++) {
 showProgress(i+1, list.length);
 open(dir1+list[i]);

 
 title = File.nameWithoutExtension ;
  run("Split Channels");

selectWindow(File.name+" (blue)");
 close(); //Closes Blue channel

selectWindow(File.name+" (green)");
close(); //Closes Green channel


//Red channel (Cell count) 
run("Gamma...", "value=1.30"); wait(20);
run("Gaussian Blur...", "sigma=0.002 scaled"); wait(20);
run("Brightness/Contrast...");
setMinAndMax(30, 170);
run("Apply LUT"); wait(20);
//run("Threshold...");
setAutoThreshold("RenyiEntropy dark");
 setOption("BlackBackground", true);
  run("Convert to Mask"); wait(20);
   run("Analyze Particles...", "size=0.00005-0.0005 circularity=0.75-1.00 show=Masks summarize"); wait(20);
     saveAs("TIFF", dir3+title+"_ROI_CellCount.Tif");
     close("*");
      
 }
 saveAs("Results", dir3+"ROI_CellCounts.csv");
  run("Close");
  setBatchMode(false);