% This routine collects data from excel sheets created using matlab routine "plotDPOAEbySubfolder" in two groups and groups the result by frequency and intensity
% The Groups are called "red" and "black", typically representing "mutant" and "wildtype".
% collects all excel sheets in the folders indicated on the top. Careful, in the case of repeated recordings, one of the recordings will be collected
% pseudo-randomly, hence you should select and delete or move lower-quality recordings before running this.

% newest versiion uses max noise from offline analysis instead of mean
% noise from online analysis (as all previous routines did)
% requires that data analysis for individual animals was done using V3 or above of plotDPOAEbySubfolderV3 so that max noise data is available (16 columns in excel files)
% version "DPOAE" rather than "dpspl" does not have the calibration for the
% DPOAE probe saved together with the original data. Calibration in this
% file here is for Box2 in 02 level. I don't have the correction factor for
% 4.7kHz at hand so it is not included.

% new in version 4: interpolation of threshold.
% the routine analyzes the growth function to find the first point where
% the variable "threshold" is crossed (but DP SPL above noise SPL in same recording).
% It also finds the point before and performs a
% linear interpolation between these two points to find the dB of the DPOAE at threshold.
% For thresholds below the minimal SPL measured, a threshold of minimal SPL
% minus "offsetbelowthreshold" is assumed (try to avoid, better to see with a high value(e.g.10) and closer to reality with a low value (e.g.1)).
% For thresholds above the maximal SPL, you will receive an output which is
% higher than your maximal SPL. In both of these cases you should choose a
% nonparametric test for statistical significance.
% A threshold of 0 will result from no data for a given DPOAE file.
% Advice: reduce "threshold" until too many of your threshold marks are
% above/below the highest intensity used.
% turn on "doXLS" only after you found the threshold value you like: it
% takes time to save all the data.

% new in version 20-04: also adds mean and SEM data in column format for
% easy copy&paste to Igor, done by Shashank

%new in version 5: alternative option: analysis of DPOAE amplitude for a
%fixed F1 and varying F2 intensities: "doIntensityRatio".
% new in version 5: adds a separate sheet with DPOAE thresholds and the dBoffset correctin factors for easy overview whether analysis was consistent

close all
clear all
warning off MATLAB:divideByZero
addpath('Z:\public\Software\Matlab\Nicola\general')

% make general settings for running the analysis
%FolderForSummary='W:\public\Data\Palm3\Systems\ABR_viral_rescue\ABR_DPOAE_analysis\'; %folder in which to save resulting data; end with \
FolderForSummary='\\wfs-medizin.top.gwdg.de\ukon-all$\UKON100\public\Data\noiseexposure\Systems\DPOAE\Isoflurane_Shamexposure_David\AnalysisNicola\'
doPlotInvidivualIO=1;
doPlotMeanIO=1
SaveFigures=1;
doXLS=1; % saves an XLS file with the data and the entire matlab workspace.

doIntensityRatio=0;
SPLF1=[20 25 30 35 40 45 50 55 60 65 70]; % for analysis of different intensity ratios
fixedSPLF2=50; % F2 at which you want to analyze the different F1 intensities

dothreshold=0;
threshold = -5;
offsetbelowthreshold=1;
%enter filenames for the group of WT/black and Mut/red containing the desired XLS files.

black=[

    'W:\archiv\systems\2024\08\DO\204719\2w\dpoae'
    'W:\archiv\systems\2024\08\DO\204720\2w\dpoae'
    ];
red = [
    'W:\archiv\systems\2024\08\DO\204719\post\dpoae'
    'W:\archiv\systems\2024\08\DO\204720\post\dpoae'
    ];
% enter desired frequencies

%FrequenciesF1=[4.7222 6.6667 9.4444 13.3333 18.8889 26.6667];
FrequenciesF1=[6.6667 9.4444 13.3333 18.8889 26.6667 37.7778];

SPLF1=[30 35 40 45 50 55 60 65 70];

dothreshold=1;
threshold = 10;
offsetbelowthreshold=1;


%%% main routine

%%% analysis
FrequenciesF2=FrequenciesF1*1.2;
foldernumber=size(red,1);
redDPMax(1:size(SPLF1,2))=0;
redNoiseMean(1:size(SPLF1,2))=0;
redNoiseStd(1:size(SPLF1,2))=0;
redfilenumber=0;


for jj=1:foldernumber
    clear foldername files ss ff type sheets
    foldername=regexprep(red(jj,:),' ','');
    files=dir(fullfile(foldername,'*DPOAE.xls'));
    for file=1:size(files)
        redfilenumber=redfilenumber+1;
        redfilenames(redfilenumber,:)={fullfile(foldername,files(file).name)}
        [type, sheets]=xlsfinfo(fullfile(foldername,files(file).name));
        for ss=1:size(sheets,2)
            for ff=1:size(FrequenciesF1,2)
                if strcmp (char(sheets(ss)),num2str(FrequenciesF1(ff)))>0;
                    Data=(xlsread(fullfile(foldername,files(file).name),char(sheets(ss))));
                    if isempty(Data)==0; reddBOffset(redfilenumber)=(Data(1,10)); end
                    for dd=1:size(Data,1)
                        for spl=1:size(SPLF1,2)
                            if round(SPLF1(spl)*10)==round(Data(dd,4)*10)
                                if doIntensityRatio==0 | (doIntensityRatio==1 & fixedSPLF2==Data(dd,5));
                                    %SPL(file,spl,ff)=Data(dd,4);
                                    redDPMax(redfilenumber+4,spl,ff)=(Data(dd,13));
                                    redNoiseMean(redfilenumber+4,spl,ff)=(Data(dd,14));
                                    redNoiseStd(redfilenumber+4,spl,ff)=(Data(dd,16));
                                    %if exist('redRecDur') && size(redRecDur,1)>=file && size(redRecDur,2)>=spl && size(redRecDur,3)>=ff && redRecDur(file,spl,ff)>0
                                    %    message=['recording made twice in ',fullfile(foldername,files(file).name)]
                                    %end % does not make sense when individual files are read, no doubles possible.
                                    redRecDur(redfilenumber+4,spl,ff)=Data(dd,9);
                                    
                                end
                            end
                        end
                    end
                end
            end
        end
    end
end

%interpolate DPOAE threshold
if dothreshold==1;
    for line=1:redfilenumber;
        for ff=1:size(redDPMax,3);
            growthfunction=redDPMax(line+4,:,ff)
            stillbelowthreshold=1;
            if isequal(sum(growthfunction),0)==1
                belowthreshold=threshold;splbelowthreshold=0;
                redthreshold(line+4,ff)=0;
            else
                belowthreshold=threshold; splbelowthreshold=min(SPLF1)-offsetbelowthreshold; %when the first value is already above threshold, assume values of threshold and 0dB
                splabovethreshold=1000; abovethreshold=1000; %when threshold is not reached at all, thresholds > max intensity will result
                for spl=1:size(growthfunction,2)
                    if growthfunction(spl)<=threshold && stillbelowthreshold==1 && isequal(growthfunction(spl),0)==0;
                        belowthreshold=growthfunction(spl);
                        splbelowthreshold=SPLF1(spl);
                    elseif growthfunction(spl)>threshold && stillbelowthreshold==1 && isequal(growthfunction(spl),0)==0;
                        if growthfunction(spl)>redNoiseMean(line+4,spl,ff)
                            abovethreshold=growthfunction(spl);
                            splabovethreshold=SPLF1(spl);
                            stillbelowthreshold=0;
                        else
                            abovethreshold=10000;splabovethreshold=10000% when noise is higher than DP treat as if threshold is not reached.
                        end
                    end
                    
                end
                redthreshold(line+4,ff)=interp1([belowthreshold abovethreshold],[splbelowthreshold splabovethreshold],threshold)
            end
            
        end
    end
end

% do everything the same for black
foldernumber=size(black,1);
blackDPMax(1:size(SPLF1,2))=0;
blackNoiseMean(1:size(SPLF1,2))=0;
blackNoiseStd(1:size(SPLF1,2))=0;
blackfilenumber=0;
for jj=1:foldernumber
    clear foldername files ss ff type sheets
    foldername=regexprep(black(jj,:),' ','');
    files=dir(fullfile(foldername,'*DPOAE.xls'));
    for file=1:size(files)
        blackfilenumber=blackfilenumber+1;
        blackfilenames(blackfilenumber,:)={fullfile(foldername,files(file).name)}
        [type, sheets]=xlsfinfo(fullfile(foldername,files(file).name));
        for ss=1:size(sheets,2)
            for ff=1:size(FrequenciesF1,2)
                if strcmp (char(sheets(ss)),num2str(FrequenciesF1(ff)))>0;
                    Data=(xlsread(fullfile(foldername,files(file).name),char(sheets(ss))));
                    if isempty(Data)==0;  blackdBOffset(blackfilenumber)=(Data(1,10)); end
                    for dd=1:size(Data,1)
                        for spl=1:size(SPLF1,2)
                            if round(SPLF1(spl)*10)==round(Data(dd,4)*10)
                                if doIntensityRatio==0 | (doIntensityRatio==1 & fixedSPLF2==Data(dd,5));
                                    %SPL(file,spl,ff)=Data(dd,4);
                                    blackDPMax(blackfilenumber+4,spl,ff)=(Data(dd,13));
                                    blackNoiseMean(blackfilenumber+4,spl,ff)=(Data(dd,14));
                                    blackNoiseStd(blackfilenumber+4,spl,ff)=(Data(dd,16));
                                    %if exist('blackRecDur') && size(blackRecDur,1)>=file && size(blackRecDur,2)>=spl && size(blackRecDur,3)>=ff && blackRecDur(file,spl,ff)>0
                                    %    message=['recording made twice in ',fullfile(foldername,files(file).name)]
                                    %end % does not make sense when individual files are read, no doubles possible.
                                    blackRecDur(blackfilenumber+4,spl,ff)=Data(dd,9);
                                end
                            end
                        end
                    end
                end
            end
        end
    end
end

if dothreshold==1;
    for line=1:blackfilenumber;
        for ff=1:size(blackDPMax,3);
            growthfunction=blackDPMax(line+4,:,ff)
            stillbelowthreshold=1;
            if isequal(sum(growthfunction),0)==1
                belowthreshold=threshold;splbelowthreshold=0
                blackthreshold(line+4,ff)=0;
            else
                belowthreshold=threshold; splbelowthreshold=min(SPLF1)-offsetbelowthreshold; %when the first value is already above threshold, assume values of threshold and 0dB
                splabovethreshold=1000; abovethreshold=1000; %when threshold is not reached at all, thresholds > max intensity will result
                for spl=1:size(growthfunction,2)
                    if growthfunction(spl)<=threshold && stillbelowthreshold==1 && isequal(growthfunction(spl),0)==0;
                        belowthreshold=growthfunction(spl);
                        splbelowthreshold=SPLF1(spl);
                    elseif growthfunction(spl)>threshold && stillbelowthreshold==1 && isequal(growthfunction(spl),0)==0;
                        if growthfunction(spl)>blackNoiseMean(line+4,spl,ff)
                            abovethreshold=growthfunction(spl);
                            splabovethreshold=SPLF1(spl);
                            stillbelowthreshold=0;
                        else
                            abovethreshold=10000;splabovethreshold=10000% when noise is higher than DP treat as if threshold is not reached.
                        end
                        
                    end
                end
                blackthreshold(line+4,ff)=interp1([belowthreshold abovethreshold],[splbelowthreshold splabovethreshold],threshold)
            end
        end
    end
end

%%% calculate means and SEMs


for ii=1:size(redDPMax,3)
    for jj=1:size(redDPMax,2)
        redDPMax(3,jj,ii)=size(nonzeros(redDPMax(5:size(redDPMax,1),jj,ii)),1);
        redDPMax(1,jj,ii)=mean(nonzeros(redDPMax(5:size(redDPMax,1),jj,ii)));
        redDPMax(2,jj,ii)=std(nonzeros(redDPMax(5:size(redDPMax,1),jj,ii)));
        redNoiseMean(3,jj,ii)=size(nonzeros(redNoiseMean(5:size(redNoiseMean,1),jj,ii)),1);
        redNoiseMean(1,jj,ii)=mean(nonzeros(redNoiseMean(5:size(redNoiseMean,1),jj,ii)));
        redNoiseMean(2,jj,ii)=std(nonzeros(redNoiseMean(5:size(redNoiseMean,1),jj,ii)));
        redNoiseStd(3,jj,ii)=size(nonzeros(redNoiseStd(5:size(redNoiseStd,1),jj,ii)),1);
        redNoiseStd(1,jj,ii)=mean(nonzeros(redNoiseStd(5:size(redNoiseStd,1),jj,ii)));
        redNoiseStd(2,jj,ii)=std(nonzeros(redNoiseStd(5:size(redNoiseStd,1),jj,ii)));
        if dothreshold==1;
            redthreshold(1,ii)=mean(nonzeros(redthreshold(5:size(redthreshold,1),ii,:)));
            redthreshold(2,ii)=std(nonzeros(redthreshold(5:size(redthreshold,1),ii,:)));
            redthreshold(3,ii)=size(nonzeros(redthreshold(5:size(redthreshold,1),ii,:)),1);
        end
        if isnan(redDPMax(1,jj,ii))==0;
            redDPMax(4,jj,ii)=std(nonzeros(redDPMax(5:size(redDPMax,1),jj,ii)))/sqrt(size(nonzeros(redDPMax(5:size(redDPMax,1),jj,ii)),1)-1);
            redNoiseMean(4,jj,ii)=std(nonzeros(redNoiseMean(5:size(redNoiseMean,1),jj,ii)))/sqrt(size(nonzeros(redNoiseMean(5:size(redNoiseMean,1),jj,ii)),1)-1);
            redNoiseStd(4,jj,ii)=std(nonzeros(redNoiseStd(5:size(redNoiseStd,1),jj,ii)))/sqrt(size(nonzeros(redNoiseStd(5:size(redNoiseStd,1),jj,ii)),1)-1);
            if dothreshold==1;
                redthreshold(4,ii)=std(nonzeros(redthreshold(5:size(redthreshold,1),ii,:)))/sqrt(size(nonzeros(redthreshold(5:size(redthreshold,1),ii,:)),1));
            end
        end
    end
end

for ii=1:size(blackDPMax,3)
    for jj=1:size(blackDPMax,2)
        blackDPMax(3,jj,ii)=size(nonzeros(blackDPMax(5:size(blackDPMax,1),jj,ii)),1);
        blackDPMax(1,jj,ii)=mean(nonzeros(blackDPMax(5:size(blackDPMax,1),jj,ii)));
        blackDPMax(2,jj,ii)=std(nonzeros(blackDPMax(5:size(blackDPMax,1),jj,ii)));
        blackNoiseMean(3,jj,ii)=size(nonzeros(blackNoiseMean(5:size(blackNoiseMean,1),jj,ii)),1);
        blackNoiseMean(1,jj,ii)=mean(nonzeros(blackNoiseMean(5:size(blackNoiseMean,1),jj,ii)));
        blackNoiseMean(2,jj,ii)=std(nonzeros(blackNoiseMean(5:size(blackNoiseMean,1),jj,ii)));
        blackNoiseStd(3,jj,ii)=size(nonzeros(blackNoiseStd(5:size(blackNoiseStd,1),jj,ii)),1);
        blackNoiseStd(1,jj,ii)=mean(nonzeros(blackNoiseStd(5:size(blackNoiseStd,1),jj,ii)));
        blackNoiseStd(2,jj,ii)=std(nonzeros(blackNoiseStd(5:size(blackNoiseStd,1),jj,ii)));
        if dothreshold==1;
            blackthreshold(1,ii)=mean(nonzeros(blackthreshold(5:size(blackthreshold,1),ii,:)));
            blackthreshold(2,ii)=std(nonzeros(blackthreshold(5:size(blackthreshold,1),ii,:)));
            blackthreshold(3,ii)=size(nonzeros(blackthreshold(5:size(blackthreshold,1),ii,:)),1);
        end
        
        if isnan(blackDPMax(1,jj,ii))==0;
            blackDPMax(4,jj,ii)=std(nonzeros(blackDPMax(5:size(blackDPMax,1),jj,ii)))/sqrt(size(nonzeros(blackDPMax(5:size(blackDPMax,1),jj,ii)),1));
            blackNoiseMean(4,jj,ii)=std(nonzeros(blackNoiseMean(5:size(blackNoiseMean,1),jj,ii)))/sqrt(size(nonzeros(blackNoiseMean(5:size(blackNoiseMean,1),jj,ii)),1));
            blackNoiseStd(4,jj,ii)=std(nonzeros(blackNoiseStd(5:size(blackNoiseStd,1),jj,ii)))/sqrt(size(nonzeros(blackNoiseStd(5:size(blackNoiseStd,1),jj,ii)),1));
            if dothreshold==1;
                blackthreshold(4,ii)=std(nonzeros(blackthreshold(5:size(blackthreshold,1),ii,:)))/sqrt(size(nonzeros(blackthreshold(5:size(blackthreshold,1),ii,:)),1));
            end
        end
    end
end

if doPlotInvidivualIO==1
    IndividualIO=figure('name','IndividualIO','Units','normalized','Position',[0.05,0.5,0.9,0.4],'toolbar','figure');
    for ii=1:size(FrequenciesF1,2)
        subplot(1,size(FrequenciesF1,2),ii)
        hold on
        for jj=5:size(blackDPMax,1)
            plot(SPLF1,blackDPMax(jj,:,ii),'k-+')
            set (gca,'ColorOrder',[0.753 0.753 0.753])%gray
            plot(SPLF1,blackNoiseMean(jj,:,ii))
        end
        for jj=5:size(redDPMax,1)
            plot(SPLF1,redDPMax(jj,:,ii),'r-x')
            set (gca,'ColorOrder',[1.000 0.502 0.753]) %pink
            plot(SPLF1,redNoiseMean(jj,:,ii))
            
        end
        if dothreshold==1;
            plot(redthreshold(5:size(redthreshold,1),ii),threshold,'gx')
            plot(blackthreshold(5:size(blackthreshold,1),ii),threshold,'bx')
        end
        ylabel('DPOAE amplitude (dB)','Fontweight','bold')
        xlabel('SPL F1','Fontweight','bold')
        title (['F2 ',num2str(FrequenciesF2(ii))])
        hold off
    end
end


if doPlotMeanIO==1
    MeanIO=figure('name','MeanIO','Units','normalized','Position',[0.05,0.05,0.9,0.4],'toolbar','figure')
    for ii=1:size(FrequenciesF1,2)
        subplot(1,size(FrequenciesF1,2),ii)
        hold on
        for jj=5:size(blackDPMax,1)
            set (gca,'ColorOrder',[0.753 0.753 0.753])%gray
            plot(SPLF1,(blackDPMax(jj,:,ii)))
        end
        for jj=5:size(redDPMax,1)
            set (gca,'ColorOrder',[1.000 0.502 0.753]) %pink
            plot(SPLF1,redDPMax(jj,:,ii))
        end
        
        %set (gca,'ColorOrder',[0.753 0.753 0.753])%gray
        plot (SPLF1,blackNoiseMean(1,:,ii),'xk')
        %set (gca,'ColorOrder',[1.000 0.502 0.753]) %pink
        plot (SPLF1,redNoiseMean(1,:,ii),'xr')
        
        errorbar (SPLF1,blackDPMax(1,:,ii),blackDPMax(4,:,ii),'k-o')
        errorbar (SPLF1,redDPMax(1,:,ii),redDPMax(4,:,ii),'r-o')
        ylabel('DPOAE amplitude (dB)','Fontweight','bold')
        xlabel('SPL F1; F2 is 10 less','Fontweight','bold')
        title (['F2 ',num2str(FrequenciesF2(ii))])
        hold off
    end
end

if doIntensityRatio==1;
    IntensityRatio=figure('name','IntensityRatio','Units','normalized','Position',[0.05,0.5,0.9,0.4],'toolbar','figure');
    for ii=1:size(FrequenciesF1,2)
        subplot(1,size(FrequenciesF1,2),ii)
        hold on
        for jj=5:size(blackDPMax,1)
            plot(SPLF1,blackDPMax(jj,:,ii),'k+')
            %set (gca,'ColorOrder',[0.753 0.753 0.753])%gray
            %plot(SPLF1,blackNoiseMean(jj,:,ii))
        end
        for jj=5:size(redDPMax,1)
            plot(SPLF1,redDPMax(jj,:,ii),'rx')
            %set (gca,'ColorOrder',[1.000 0.502 0.753]) %pink
            %plot(SPLF1,redNoiseMean(jj,:,ii))
            
        end
        ylabel('DPOAE amplitude (dB)','Fontweight','bold')
        xlabel('SPL F1','Fontweight','bold')
        title (['F2 ',num2str(FrequenciesF2(ii)),'kHz ', num2str(fixedSPLF2), 'dB'])
        hold off
    end
    %saveas(IntensityRatio,strcat(FolderForSummary,'IntensityRatio_',datestr(now,1),'.fig'))
    %saveas(IntensityRatio,strcat(FolderForSummary,'IntensityRatio_',datestr(now,1),'.fig'))
end




if SaveFigures==1;
    saveas(MeanIO,strcat(FolderForSummary,'MeanDP-IO_',datestr(now,1),'.png'))
    saveas(IndividualIO,strcat(FolderForSummary,'IndividualDP-IO_',datestr(now,1),'.png'))
    saveas(MeanIO,strcat(FolderForSummary,'MeanDP-IO_',datestr(now,1),'.fig'))
    saveas(IndividualIO,strcat(FolderForSummary,'IndividualDP-IO_',datestr(now,1),'.fig'))
    
end

if doXLS==1
    XLSFilename=strcat(FolderForSummary,'DPOAE-Result_','_',datestr(now,1))
    legend={'DPOAE','Mean','Std','n','SEM'}
    legendred={'Mean','SEM','red'}
    legendblack={'Mean','SEM','black'}
    
    %SPLF1=num2str(SPLF1')
    %,blackfilenames'}
    %={' ','Mean','Std','n','SEM',redfilenames'}
    
    for ii=1:size(redDPMax,3)
        Sheetname=['DP-',num2str(FrequenciesF1(ii))];
        xlswrite(XLSFilename,redDPMax(:,:,ii),Sheetname,'B2')
        xlswrite(XLSFilename,{'F1 Threshold (usually, F2, 10dB less, is shown',threshold},Sheetname,'X1')
        if dothreshold==1 xlswrite(XLSFilename,redthreshold(:,ii),Sheetname,'X2'); end
        xlswrite(XLSFilename,legend',Sheetname,'A1')
        xlswrite(XLSFilename,SPLF1,Sheetname,'B1')
        xlswrite(XLSFilename,redfilenames,Sheetname,'A6')
        xlswrite(XLSFilename,redDPMax([1,4],:,ii)',Sheetname,'I2')
        xlswrite(XLSFilename,legendred,Sheetname,'I1')
        
        
        Sheetname=['Noise-',num2str(FrequenciesF1(ii))];
        xlswrite(XLSFilename,redNoiseMean(:,:,ii),Sheetname,'B2')
        xlswrite(XLSFilename,legend',Sheetname,'A1')
        xlswrite(XLSFilename,SPLF1,Sheetname,'B1')
        xlswrite(XLSFilename,redfilenames,Sheetname,'A6')
        xlswrite(XLSFilename,redNoiseMean([1,4],:,ii)',Sheetname,'I2')
        xlswrite(XLSFilename,legendred,Sheetname,'I1')
        
        
        Sheetname=['NoiseStd-',num2str(FrequenciesF1(ii))];
        xlswrite(XLSFilename,redNoiseStd(:,:,ii),Sheetname,'B2')
        xlswrite(XLSFilename,legend',Sheetname,'A1')
        xlswrite(XLSFilename,SPLF1,Sheetname,'B1')
        xlswrite(XLSFilename,redfilenames,Sheetname,'A6')
        xlswrite(XLSFilename,redNoiseStd([1,4],:,ii)',Sheetname,'I2')
        xlswrite(XLSFilename,legendred,Sheetname,'I1')
    end
    
    
    
    
    for ii=1:size(blackDPMax,3)
        Sheetname=['DP-',num2str(FrequenciesF1(ii))];
        xlswrite(XLSFilename,blackDPMax(:,:,ii),Sheetname,'N2')
        if dothreshold==1 xlswrite(XLSFilename,blackthreshold(:,ii),Sheetname,'Y2'); end
        xlswrite(XLSFilename,legend',Sheetname,'M1')
        xlswrite(XLSFilename,SPLF1,Sheetname,'N1')
        xlswrite(XLSFilename,blackfilenames,Sheetname,'M6')
        xlswrite(XLSFilename,blackDPMax([1,4],:,ii)',Sheetname,'U2')
        xlswrite(XLSFilename,legendblack,Sheetname,'U1')
        
        Sheetname=['Noise-',num2str(FrequenciesF1(ii))];
        xlswrite(XLSFilename,blackNoiseMean(:,:,ii),Sheetname,'N2')
        xlswrite(XLSFilename,legend',Sheetname,'M1')
        xlswrite(XLSFilename,SPLF1,Sheetname,'N1')
        xlswrite(XLSFilename,blackfilenames,Sheetname,'M6')
        xlswrite(XLSFilename,blackNoiseMean([1,4],:,ii)',Sheetname,'U2')
        xlswrite(XLSFilename,legendblack,Sheetname,'U1')
        
        Sheetname=['NoiseStd-',num2str(FrequenciesF1(ii))];
        xlswrite(XLSFilename,blackNoiseStd(:,:,ii),Sheetname,'N2')
        xlswrite(XLSFilename,legend',Sheetname,'M1')
        xlswrite(XLSFilename,SPLF1,Sheetname,'N1')
        xlswrite(XLSFilename,blackfilenames,Sheetname,'M6')
        xlswrite(XLSFilename,blackNoiseStd([1,4],:,ii)',Sheetname,'U2')
        xlswrite(XLSFilename,legendblack,Sheetname,'U1')
    end
    if dothreshold==1
        Sheetname=['Thresholds'];
        xlswrite(XLSFilename,redfilenames,Sheetname,'A9')
        xlswrite(XLSFilename,reddBOffset',Sheetname,'B9')
        xlswrite(XLSFilename,FrequenciesF1,Sheetname,'C1')
        xlswrite(XLSFilename,redthreshold,Sheetname,'C6')
        
        xlswrite(XLSFilename,blackfilenames,Sheetname,'M9')
        xlswrite(XLSFilename,blackdBOffset',Sheetname,'N9')
        xlswrite(XLSFilename,FrequenciesF1,Sheetname,'O1')
        xlswrite(XLSFilename,redthreshold,Sheetname,'O6')
    end
    
    save ([XLSFilename,'-mat'])
end