% browses for DPOAE files in a specified folder and first order subfolders. Plots DPOAE (taken from online analysis
% saved in (IsData) and noise floors +-SEMs and generates an excel file containing tables with the data.
% amplitudes are currently uncalibrated original recording amplitudes
% improvements to Version 1: plot FFT of microphone signals and mark DPOAE to give possibility to double-check results, plot DP-Gram

% Version 2, Nicola Strenzke, 21.04.11
% Version 2.1, Andreas Brandt, 22.07.11
% (removed BERA-related code, removed bugs, increased performance, added deletion of
% empty excel-sheets)

% Version 2, Nicola Strenzke26.03.2015
% uses newer Version of DPOAE measurement routine which results in "DPOAEdpSPL" files which include the microphone calibration data from the
% B&K vs the Sennheiser Probe microphone. Thus, the output is now in dB  SPL. Also, the noise floor is now not only given as mean noise but as maximum
% noise in a range of 3*SearchRange around the DP search area (DP expected frequency +- SearchRange) but also as max in that area which is better for calculating DB above noise floor. 

% in FFT plots, the FFT (blue) is calibrated using dBoffset (3) which is at DP frequency. Thus, F1 and F2 (from original online FFT) may be slightly
% off, these are calibrated by dBoffset(1) and (2), respectively. Black symbols are from offline analysis, green/red symbols for DPOAE from online
% analysis.
% The new noise analysis is taken from 

%Excel Sheet will contain: 
%Freq F1	Freq F2	Freq DP	SPL F1 set	SPL F2 set	DP Max online	NoiseMean online	NoiseStd online	RecDur(s):	from online analysis
% dB offset: mean of all 4 measured microphone calibration offsets, dBoffset(4) 
% F1 rec	F2 rec	DP rec	noise max rec	noise mean rec	noise std rec:  from offline analysis
%110615_max noise instead of mean(noise) from the two noises above and
%below DP frequency

% in version 3 the offset was calculated per frequency from the calibration data saved in the file.  
%in version 4: offset is 111,6, the grand average from f1,f2 and DP in the range of 8 to 32 kHz from DP as before the 11.3kHz data was shifted because that
% value was an outlier. Calculated from data by mattia,
% W:\archiv\systems\2016\11\MN\NoiseTrauma\69\DPOAE_231116_Before, 
% 8	102,5	107,5	114	105		102.5105  107.4892  114.3219  104.9998			
% 11,3kHz	112	116	101	114		112.3165  116.3106  101.3226  114.3135			
% 16	110,8	118,8	113,4497	114,8		 110.8198  118.8239  113.4497  114.8219			
% 23	106,9	115,888	116,3753	111,39		  106.8990  115.8885  116.3753  111.3937			
% 32	110,8594	110,31	117,0858	110,6		110.8594  110.3111  117.0858  110.5852			
% 			111,6						
% older value from 2013 excel in
% W:\public\Software\Matlab\Nicola\MainPlugin\DPOAE is 112dB very close.
% new version 5, 10/2024: automatically calculates dBoffset from
% calibration values saved in the same file. Compares with standard values
% and gives error message when the two values differ by >3dB. Talk with
% Nicola when this error message appears. 

% the previous OTOFIT version was still using different correction factors
% for the offset, not the straight 111,6; resulting in higher noise floor
% than DPOAE amplitude at 11 kHz in the xls files. 



clear all
close all


% enter one or more "main" folder names here
folder=[
% 'W:\archiv\systems\2024\08\DO\204708\2w\dpoae  ' % bei 8kHz und 11 Khz ein paar Strungen aber eigentlich ganz ok, ein paar extra peaks
% 'W:\archiv\systems\2024\08\DO\204709\2w\dpoae  ' % bei 8und 11 ein paar Strungen aber eigentlich ganz ok, ein paar extra peaks, besser als8
% 'W:\archiv\systems\2024\08\DO\204719\2w\dpoae  ' % ein paar extra peaks
% 'W:\archiv\systems\2024\08\DO\204720\2w\dpoae  ' % wenige extra peaks, 
% in all august measurments, f1 is 15-30dB less than expected from calibration. F1/F2 ratio roughly ok. 
% 'W:\archiv\systems\2024\03\DO\194910\2w\dpoae  ' % Rauschen va bei 8 und 32, IO schlecht
% 'W:\archiv\systems\2024\03\DO\194911\2w\dpoae  ' % rauschen va bei 16 und 23, IO schlecht 
% 'W:\archiv\systems\2024\03\DO\194912\2w\dpoae  ' % Rauschen bei 8,11,16, IO schlecht
% bei 03/2024 Messungen starke Abweichung, F1 und F2 40dB lauter als Kalibrierung
% 
% 'W:\archiv\systems\2024\08\DO\204708\post\dpoae' % 8 verrauscht, extra peaks aber ganz ok. IO ok aber 1 Outlier 
% 'W:\archiv\systems\2024\08\DO\204709\post\dpoae' % ok
'W:\archiv\systems\2024\08\DO\204719\post\dpoae' %einzelne Peaks, Ergebnis ok
'W:\archiv\systems\2024\08\DO\204720\post\dpoae' % einzelne vllig verrauscht
'W:\archiv\systems\2024\03\DO\194910\post\dpoae' % teilweise verrauscht, teilsweise ist F2 grer als F1. 
'W:\archiv\systems\2024\03\DO\194911\post\dpoae' %sieht vllig verrauscht aus. 
'W:\archiv\systems\2024\03\DO\194912\post\dpoae' % F2 ist oft hher als F1.11kHz verrauscht
];

searchsubfolders=0;         % set to 1 if you want main folder and subfolders to be processed
doIOplot=1;                 % set to 1 if you want a matlab figure and jpg of the individual IO functions
doXLS=1;                    % set to 1 if you want the excel file with the data tables
closefigures=1;             % set to 1 if you want to close the matlab figures immediately. JPG files will nonetheless be generated
doDPGramplot=1;             % set to 1 if you want a DP Gram (DPOAE amplitudes for different frequency regions at same primary levels)
doplotFFT=1;                % set to 1 if you want plots of FFTs - useful to check quality of results.
doMicrophoneTracePlot=0;    % set to 1 if you want the raw microphone date to be displayed

SearchRange=3; %points to search for maximum



%%% loop through the "main folders" given in 'folder' to collect the
%%% names of DPOAE-files-containing folders and subfolders, stored in 'folders'
FolderFiles=['*-DPOAE.mat'];
ii=1;
for iii=1:size(folder,1) 
   MainFolderName=(regexprep(folder(iii,:),' ',''));
   if size(dir(fullfile(MainFolderName,FolderFiles)),1) > 0 %only if DPOAE files are contained
      folders(ii,1:300)=' ';
      folders(ii,1:size(MainFolderName,2))=MainFolderName; % enters name of main folder into folder list for analysis
      ii=ii+1;
   end
   if searchsubfolders==1;
      subfolders = dir(MainFolderName);
      for iiii=1:size(subfolders,1)
         if (subfolders(iiii).isdir)==1 &~ (strcmp(subfolders(iiii).name,'.')) &~ (strcmp(subfolders(iiii).name,'..')) % if the current dir element is a real subfolder and not a system command '\.' or '\..')
            FolderName=(fullfile(MainFolderName,subfolders(iiii).name));
            if size(dir([FolderName,'\',FolderFiles]),1)>0 % only if DPOAE files are contained
               folders(ii,1:300)=' ';
               folders(ii,1:size(FolderName,2))=FolderName; % enters name of subfolder into folder list for analysis
               ii=ii+1;
            end
         end
      end
   end
end


%%% main routine
XLSlegend={'Freq F1','Freq F2','Freq DP','SPL F1 set','SPL F2 set','DP Max online','NoiseMean online','NoiseStd online','RecDur(s)','dB offset','F1 rec','F2 rec','DP rec','noise max rec','noise mean rec','noise std rec'};
for jj=1:(size(folders,1)) % loop through folders in 'folders'
   FolderName = regexprep(folders(jj,:),' ','');
   files=dir(fullfile(FolderName,FolderFiles));
   if size (files,1)==0
      Message = ['no DPOAE files in folder ',FolderName]
   else
      for kk=1:size(files,1) % loop through files in actual folders
         load(fullfile(FolderName,files(kk).name)) %loads each file one by one
         fullfile(FolderName,files(kk).name)
         %t=single(1:size(IsData(1).MicroDat));t=t/ExpInfo.FreqRP2*1000;
         if exist('IsData') && size(IsData,1)>0; % only if data exists
            F2frequencies=[]; overview=0; NoOfLevel=0; DPGram(1:size(IsData,2), 1:size(IsData,2))=NaN; %clears previous datasets
            if doplotFFT==1 %generates proper figure layout FFT plots depending on number of datasets
               FFTfigure=figure('name',['FFTs ',FolderName],'Units','normalized','Position',[0.1,0.1,0.8,0.8]);
               FFTPlots=[1,size(IsData,2)];
               if (size(IsData,2))>30;
                   FFTPlots=[6,(ceil(size(IsData,2)/6))]; % 8 Zeilen  
               elseif (size(IsData,2))>24;
                   FFTPlots=[6,(ceil(size(IsData,2)/6))]; % 7 Zeilen
               elseif (size(IsData,2))>20;
                   FFTPlots=[6,(ceil(size(IsData,2)/6))]; % 6 Zeilen              
               elseif (size(IsData,2))>16;
                   FFTPlots=[5,(ceil(size(IsData,2)/5))]; % 5 Zeilen
               elseif (size(IsData,2))>12;
                   FFTPlots=[4,(ceil(size(IsData,2)/4))]; % 4 Zeilen
               elseif size(IsData,2)>8;
                   FFTPlots=[3,(ceil(size(IsData,2)/3))]; % 3 Zeilen
               else  
                   FFTPlots=[2,(ceil(size(IsData,2)/2))]; % 2 Zeilen
               end
            end
            
            %%% dB offset correction, chronological order
            %as indicated at the top, 112 was a standard value used for a long time for MF1NF speakers
            dBoffsetTable=0;
            if isfield(ExpInfo,'CalFile')
                if isempty(strfind(ExpInfo.CalFile,'CalDPOAE_MF1NF_21-May-2012thinTubes'))==0
                    dBoffsetTable=112.2; %probably startle computer, terratec amplifier, box2 in 02
                    Message='careful, check calibration file, used calibration factor from times before calibration was saved with each dataset, noted "before 06/2013'
                elseif isempty(strfind(ExpInfo.CalFile,'CalDPOAE_MF1NF_26-Jun-2013.mat'))==0
                    % used by Justin&Stefan on March 1st, 2021. for the analysis they used a correction factor of 111.6 which as explained at the top is from Mattias data in 2016.
                    dBoffsetTable=112.3;% 02 box 2 startle computer TDT System III-1, terratec amplifier which broke around february 2021 (when Justin was there).
                elseif isempty(strfind(ExpInfo.CalFile,'CalDPOAE_MF1NF_Box1_12-Feb-2021'))==0
                    dBoffsetTable=86.2; % MF1 speakers, zoom amplifier, new pipette tip probe, TDT System III-1, distorsion computer, in old analyses, we used manually entered 86.1597619
                elseif isempty(strfind(ExpInfo.CalFile,'CalDPOAE_MF1NF_02-Mar-2021_UAC2_Box2'))==0
                    dBoffsetTable=103.0; %MF1 speakers, new pipette tip probe, TDT System III-1, distorsion computer, UAC amplifier
                elseif isempty(strfind(ExpInfo.CalFile,'CalDPOAE_MF1NF_15-Feb-2022'))==0
                    dBoffsetTable=118.6; % mobile setup red salon, MF1 speakers, TDT System III-2, startle computer "mobile setup", used by David for most noise trauma studies 2022/2023, UAC amplifier, custom silicone artifical ear same for two different calibration sessions
                elseif isempty(strfind(ExpInfo.CalFile,'CalDPOAE_MF1NF_28-Mar-2024_B'))==0
                    dBoffsetTable=101.7; % mobile setup red salon, MF1 speakers, TDT System III-2, startle computer "mobile setup", used by David for isoflurane vs ketamine studies, same custom silicone artifical ear same for two different calibration sessions at the same setup, probably this and 2022 (above)
                end
            elseif isempty(strfind(ExpInfo.AllCalFile(1).sine,'CalDPOAE_MF1NF_11-Jan-2024_GRAS40dB_Terratec'))==0 && round(ExpInfo.FrequenciesDPOAE.F2calSPL(1))==104 && round(ExpInfo.FrequenciesDPOAE.F2calSPL(11))==76
                dBoffsetTable=113.8; % room, MF1 speakers, custom 3d printed probe, TDT System III-1, new distortion computer 2024, Terratec amplifier
                %somehow the variable "ExpInfo.CalFile" does not exist in this version.
            end

        
%%% calculates dBOffset from the calibration data saved with the individual dataset in the range between F2 =
%%% 8kHz and F2 = 26.7kHz using the three values measured for F1, F2 and DP
%%%then compares with the value above. 
dBoffsetCalcRange(1)=find(ExpInfo.FrequenciesDPOAE.F2==8000,1);
dBoffsetCalcRange(2)=find(round(ExpInfo.FrequenciesDPOAE.F2)==round(2.2667e+04));
dBoffset(1,:)=ExpInfo.FrequenciesDPOAE.DPcalSPL(dBoffsetCalcRange(1):dBoffsetCalcRange(2))-ExpInfo.FrequenciesDPOAE.DPmicFFTSPL(dBoffsetCalcRange(1):dBoffsetCalcRange(2));
dBoffset(2,:)=ExpInfo.FrequenciesDPOAE.F1calSPL(dBoffsetCalcRange(1):dBoffsetCalcRange(2))-ExpInfo.FrequenciesDPOAE.F1micFFTSPL(dBoffsetCalcRange(1):dBoffsetCalcRange(2));
dBoffset(3,:)=ExpInfo.FrequenciesDPOAE.F2calSPL(dBoffsetCalcRange(1):dBoffsetCalcRange(2))-ExpInfo.FrequenciesDPOAE.F2micFFTSPL(dBoffsetCalcRange(1):dBoffsetCalcRange(2));
dBoffsetNew=mean(mean(dBoffset));
if dBoffsetNew-dBoffsetTable>3 | dBoffsetNew-dBoffsetTable<-3 % somewhat arbitrary value: when offset value differs by >3dB I begin to worry
    Message='check offset correction'
    dBoffsetNew
    dBoffsetTable
end

            
            for ij=1:size(IsData,2) % goes through individual file
               if isempty(IsData(ij).SPL2)==0
                  if ismember(IsData(ij).F2,F2frequencies)==1 %if other datasets at the same frequency have been collected before
                     [tf,FrequencyNo]=ismember(IsData(ij).F2,F2frequencies); clear tf  %get FrequencyNo
                     NoOfLevel(FrequencyNo) = NoOfLevel(FrequencyNo)+1;
                  else %if first measurement with that particular frequency, add to F2Frequencies
                     F2frequencies(size(F2frequencies,2)+1)=IsData(ij).F2;
                     FrequencyNo=(size(F2frequencies,2));
                     NoOfLevel(FrequencyNo)=1;
                  end
                  
                  % correct for microphone calibration
                  FreqPos=find(ExpInfo.FrequenciesDPOAE.DP==IsData(ij).DP);
                  %dBoffset(1)=ExpInfo.FrequenciesDPOAE.F1calSPL(FreqPos)-ExpInfo.FrequenciesDPOAE.F1micFFTSPL(FreqPos);
                  %dBoffset(2)=ExpInfo.FrequenciesDPOAE.F2calSPL(FreqPos)-ExpInfo.FrequenciesDPOAE.F2micFFTSPL(FreqPos);
                  %dBoffset(3)=ExpInfo.FrequenciesDPOAE.DPcalSPL(FreqPos)-ExpInfo.FrequenciesDPOAE.DPmicFFTSPL(FreqPos);
                  %dBoffset(1)=-FrequenciesDPOAE.F1micFFTSPL(FreqPos);
                  %dBoffset(2)=-FrequenciesDPOAE.F2micFFTSPL(FreqPos);
                  %dBoffset(3)=-FrequenciesDPOAE.DPmicFFTSPL(FreqPos);
                  %dBoffset(4)=mean(dBoffset(1:3));
                    
                  % collect data from IsData           
                  overview(1,NoOfLevel(FrequencyNo),FrequencyNo)=IsData(ij).F1;
                  overview(2,NoOfLevel(FrequencyNo),FrequencyNo)=IsData(ij).F2;
                  overview(3,NoOfLevel(FrequencyNo),FrequencyNo)=(IsData(ij).DP);
                  overview(4,NoOfLevel(FrequencyNo),FrequencyNo)=IsData(ij).SPL1;
                  overview(5,NoOfLevel(FrequencyNo),FrequencyNo)=IsData(ij).SPL2;
                  overview(6,NoOfLevel(FrequencyNo),FrequencyNo)=20*log10(IsData(ij).DPMax)+dBoffsetNew;%DP from online analysis, corrected for microphone offset at DP frequency
                  overview(7,NoOfLevel(FrequencyNo),FrequencyNo)=20*log10(IsData(ij).DPNoiseMean)+dBoffsetNew; %noise from online analysis
                  overview(8,NoOfLevel(FrequencyNo),FrequencyNo)=20*log10(IsData(ij).DPNoiseStd); %noise STD from online analysis
                  overview(9,NoOfLevel(FrequencyNo),FrequencyNo)=round(size(IsData(ij).MicroDat,2)/ExpInfo.FreqRP2);%recording duration
                  overview(10,NoOfLevel(FrequencyNo),FrequencyNo)=dBoffsetNew;  
                  
                  DPGramline=round(IsData(ij).SPL2/10);
                  if DPGramline<1; DPGramline=1; end
                  DPGramLegendF2(DPGramline,:)=num2str(round(IsData(ij).SPL2));
                  DPGram(DPGramline,FrequencyNo)=20*log10(IsData(ij).DPMax)+dBoffsetNew;

                  if doplotFFT==1;
                     FFTSize=size(IsData(ij).MicroDat,2)/2; %/2
                     FFTSizeDiv2=round(FFTSize/2);
                     yFFT=fft(IsData(ij).MicroDat(1:FFTSize),FFTSize);
                     Pyy=(sqrt(yFFT.*conj(yFFT))*2/FFTSize);
                     frecFFT=0:FFTSize-1;
                     frecFFT=frecFFT*(ExpInfo.FreqRP1/FFTSize)/1000;

                     left = round((2*IsData(ij).DP-IsData(ij).F1)/ExpInfo.FreqRP1*FFTSize);
                     right = round((2*IsData(ij).F2-IsData(ij).F1)/ExpInfo.FreqRP1*FFTSize);
                     Pyy(right:end) = []; Pyy(1:left) = []; 
                     frecFFT(right:end) = []; frecFFT(1:left) = []; 
                     
                     %dwnsmpldPyy=downsample(Pyy,10);
                     %dwnsmpldPyy=Pyy;
                     %dwnsmpldfrecFFT=downsample(frecFFT,10);
                     %dwnsmpldfrecFFT=frecFFT;
                    
                     %figure
                     subplot(FFTPlots(1),FFTPlots(2),ij);
                     
                     
                     
                     %semilogy(frecFFT,Pyy);
                     Pyylog=20*log10(Pyy);
                     plot(frecFFT,Pyylog+dBoffsetNew)
                     a=frecFFT';
                     b=(Pyylog+dBoffsetNew)';
                     %axis ([((2*IsData(ij).DP-IsData(ij).F1)/1000) ((2*IsData(ij).F2-IsData(ij).F1)/1000) -200 100])
                     hold on;
                     if (IsData(ij).DPMax)> (IsData(ij).DPNoiseMean+(3*IsData(ij).DPNoiseStd));
                         plot(IsData(ij).DP/1000,20*log10(IsData(ij).DPMax)+dBoffsetNew,'go');
                         plot(IsData(ij).DP/1000,20*log10(IsData(ij).DPMax)+dBoffsetNew,'g*');
                     else 
                         plot(IsData(ij).DP/1000,20*log10(IsData(ij).DPMax)+dBoffsetNew,'rx');
                     end
                     if ij==1; ylabel('Amplitude','Fontweight','bold');end
                     if ij==size(IsData,2); xlabel('Frequency(kHz)','Fontweight','bold');end
                     title (strcat(num2str(round(IsData(ij).F2/1000)), 'kHz/ ', num2str(round(IsData(ij).SPL2)), 'dB/ ', num2str(round(size(IsData(ij).MicroDat,2)/ExpInfo.FreqRP2)), 's'));
                     drawnow;
                     
                     [F1max F1maxPos]=max (Pyylog(find(frecFFT>IsData(ij).F1/1000,1)-SearchRange:find(frecFFT>IsData(ij).F1/1000,1)+SearchRange));
                     %F1maxPos=F1maxPos+find(frecFFT>IsData(ij).F1/1000,1)-1;
                     plot(IsData(ij).F1/1000,F1max+dBoffsetNew,'kx')
                     overview(11,NoOfLevel(FrequencyNo),FrequencyNo)=F1max+dBoffsetNew;
                     
                     [F2max F2maxPos]=max (Pyylog(find(frecFFT>IsData(ij).F2/1000,1)-SearchRange:find(frecFFT>IsData(ij).F2/1000,1)+SearchRange));
                     %F1maxPos=F2maxPos+find(frecFFT>IsData(ij).F2/1000,1)-1;      
                     plot(IsData(ij).F2/1000,F2max+dBoffsetNew,'kx')
                     overview(12,NoOfLevel(FrequencyNo),FrequencyNo)=F2max+dBoffsetNew;
                     
                     
                     % finds maximum value of Pyylog in search range of
                     % e.g. 3 data points above and 3data points below expected DP frequency.
                     [DPmax DPmaxPos]=max (Pyylog(find(frecFFT>IsData(ij).DP/1000,1)-SearchRange:find(frecFFT>IsData(ij).DP/1000,1)+SearchRange));
                     %DPmaxPos=DPmaxPos+find(frecFFT>IsData(ij).F1/1000,1)-1;
                     plot(IsData(ij).DP/1000,DPmax+dBoffsetNew,'k+')
                     overview(13,NoOfLevel(FrequencyNo),FrequencyNo)=DPmax+dBoffsetNew;
                     
                     [noisemax(1) noisemaxPos1]=max (Pyylog(find(frecFFT>IsData(ij).DP/1000,1)-SearchRange*3-SearchRange:find(frecFFT>IsData(ij).DP/1000,1)-SearchRange*3+SearchRange));
                     noisemean(1)= mean (Pyylog(find(frecFFT>IsData(ij).DP/1000,1)-SearchRange*3-SearchRange:find(frecFFT>IsData(ij).DP/1000,1)-SearchRange*3+SearchRange));
                     noisestd(1)= std (Pyylog(find(frecFFT>IsData(ij).DP/1000,1)-SearchRange*3-SearchRange:find(frecFFT>IsData(ij).DP/1000,1)-SearchRange*3+SearchRange));

                     [noisemax(2) noisemaxPos2]=max (Pyylog(find(frecFFT>IsData(ij).DP/1000,1)+SearchRange*3-SearchRange:find(frecFFT>IsData(ij).DP/1000,1)+SearchRange*3+SearchRange));
                     noisemean(2)= mean (Pyylog(find(frecFFT>IsData(ij).DP/1000,1)+SearchRange*3-SearchRange:find(frecFFT>IsData(ij).DP/1000,1)+SearchRange*3+SearchRange));
                     noisestd(2)= std (Pyylog(find(frecFFT>IsData(ij).DP/1000,1)+SearchRange*3-SearchRange:find(frecFFT>IsData(ij).DP/1000,1)+SearchRange*3+SearchRange));
                     noisemax=max(noisemax);
                     overview(14,NoOfLevel(FrequencyNo),FrequencyNo)=noisemax+dBoffsetNew;
                     overview(15,NoOfLevel(FrequencyNo),FrequencyNo)=mean(noisemean)+dBoffsetNew;
                     overview(16,NoOfLevel(FrequencyNo),FrequencyNo)=mean(noisestd);
                  end

                  if doMicrophoneTracePlot==1;      %scaling has to be adjusted to FFT-plot
                      MicDat = downsample(IsData(ij).MicroDat,10);
                      t = 0:(size(MicDat,2)-1);
                      plot (t,MicDat);
                  end
               end

            end

            if doplotFFT==1 && exist('IsData') && size(IsData,1)>0;
               saveas(FFTfigure,strcat(FolderName,'\DPOAE-FFT_',files(kk).name(1:size(files(kk).name,2)-4),'.jpg'))
            end

            if doIOplot==1 && overview(1,1,1)>0;
               IOfigure=figure('name',['DPOAE ',FolderName],'Units','normalized','Position',[0.1,0.1,0.8,0.8]);
               for ii=1:FrequencyNo;
                  IOplots=[1,size(F2frequencies,2)];
                  if size(F2frequencies,2)>4; IOplots=[2,(ceil(size(F2frequencies,2)/2))];
                  elseif size(F2frequencies,2)>8;
                     IOplots=[3,(ceil(size(F2frequencies,2)/3))]
                  end
                  subplot(IOplots(1),IOplots(2),ii)
                  hold on
                  %plot(overview(3,:,ii),overview(5,:,ii),'x','MarkerSize',10);
                  plot(nonzeros(overview(5,:,ii)),nonzeros(overview(11,:,ii)),'k-x');
                  plot(nonzeros(overview(5,:,ii)),nonzeros(overview(12,:,ii)),'k-o');
                  plot(nonzeros(overview(5,:,ii)),nonzeros(overview(6,:,ii)),'r-x','MarkerSize',10);
                  %plot(nonzeros(overview(5,:,ii)),nonzeros(overview(8,:,ii)),'b-x');%std noise
                  plot(nonzeros(overview(5,:,ii)),nonzeros(overview(14,:,ii)),'b-+');
                  plot(nonzeros(overview(5,:,ii)),nonzeros(overview(15,:,ii)),'r-+');
                  plot(60,60,'go');plot(50,50,'go');plot(40,40,'go');plot(30,30,'go');
                  title (strcat('F1: ',(num2str(overview(1,1,ii)/1000)),'kHz'));
                  ylabel('amplitude','Fontweight','bold');xlabel('F2 (dB SPL)','Fontweight','bold');
                  %axis tight;
               end
               legend('F1','F2','DPOAE','noise max','noise mean','expected F1')
               legend('boxoff')
               hold off
               %axis ([-inf inf -250 100])
               saveas(IOfigure,strcat(FolderName,'\DPOAE-IO_',files(kk).name(1:size(files(kk).name,2)-4),'.jpg'))
            end

            if doDPGramplot==1 && overview(1,1,1)>0;
               DPGram(:,size(F2frequencies,2)+1:size(DPGram,2))=[];
               DPGramfigure=figure('name',['DPGram ',FolderName],'Units','normalized','Position',[0.1,0.1,0.3,0.4]);
               plot(F2frequencies/1000,DPGram,'-x')
               legend(DPGramLegendF2);
               legend('boxoff');
               ylabel('DPOAE amplitude (dB SPL)','Fontweight','bold');xlabel('F2 (kHz)','Fontweight','bold');
               title([num2str(round(size(IsData(ij).MicroDat,2)/ExpInfo.FreqRP2)),' sec'])
               saveas(DPGramfigure,strcat(FolderName,'\DP-Gram_',files(kk).name(1:size(files(kk).name,2)-4),'.jpg'))
            end

            if doXLS==1
                warning off MATLAB:xlswrite:AddSheet
                fileName = strcat(fullfile(FolderName,files(kk).name(1:size(files(kk).name,2)-4)),'.xls');
                if exist(fileName, 'file') 
                    delete (fileName);
                end
                for ii=1:FrequencyNo;
                  xlswrite(fileName,XLSlegend,num2str(overview(1,1,ii)/1000),'A1')
                  xlswrite(fileName,overview(:,:,ii)',num2str(overview(1,1,ii)/1000),'A2')
                end
                
                
                %part from Andreas
                excelObj = actxserver('Excel.Application');
                excelWorkbook = excelObj.workbooks.Open(fileName);
                worksheets = excelObj.sheets;
                sheetIdx = 1;
                sheetIdx2 = 1;
                numSheets = worksheets.Count;
                excelObj.EnableSound = false;  % Prevent beeps from sounding if we try to delete a non-empty worksheet.
                
                while sheetIdx2 <= numSheets  % Loop over all sheets
                    temp = worksheets.count;  % Saves the current number of sheets in the workbook
                    if or(sheetIdx>1,numSheets-sheetIdx2>0)  % Check whether the current worksheet is the last one. As there always need to be at least one worksheet in an xls-file the last sheet must not be deleted. worksheets.Item(sheetIdx).UsedRange.Count is the number of used cells. This will be 1 for an empty sheet. It may also be one for certain other cases but in those cases, it will beep and not actually delete the sheet.
                        if worksheets.Item(sheetIdx).UsedRange.Count == 1
                            worksheets.Item(sheetIdx).Delete;
                        end
                    end
                    if temp == worksheets.count; % Check whether the number of sheets has changed. If this is not the case the counter "sheetIdx" is increased by one.
                        sheetIdx = sheetIdx + 1;
                    end
                    sheetIdx2 = sheetIdx2 + 1;
                end
                excelObj.EnableSound = true;
                excelWorkbook.Save;
                excelWorkbook.Close(false);
                excelObj.Quit;
                delete(excelObj);
                % end part from Andreas
            end
         end
      end
      if closefigures==1; close all; end
   end
end
