%note that the file fluo_PHPeB.mat was renamed to Figure6_source_data4.mat
%according to elife request

clear;
%&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
cd('W:\public\Data\CaBP1_2\Immuno\Rescue\PHPeB')
[FileName,PathName] = uigetfile('*.*','Select the experiment you want to open');
filename=[PathName,FileName];

image=imread(filename);
image=image(:,:,1:2);

%image=fliplr(image); %used for 97_i_4 
%image=flipud(image); %used for 1_i_5 and 97_n_3 and 96_i_5 
%image=fliplr(image);image=flipud(image); %used for 96_i_2 and 96_i_4 
figure(1),imshow(image(:,:,1))
[x, y] = getline(figure(1));


D = bspline_estimate(3,0.1:0.05:1,[x';y']);
%D = bspline_estimate(3,0.1:0.07:1,[x';y']);
% used 0.07 for one of the 99_n parts and for 96_n_3 
%D = bspline_estimate(2,0.1:0.05:1,[x';y']); -> also for [C,U]... used so for 96_i_2


for i =1:length(D)-1,distD(i)=sqrt((D(1,i+1)-D(1,i))^2 + (D(2,i+1)-D(2,i))^2);end
lenD=sum(distD);
[C,U] = bspline_deboor(3,0.1:0.05:1,D,round(lenD)*2);
%[C,U] = bspline_deboor(3,0.1:0.07:1,D,round(lenD)*2);
figure(1),hold on,plot(C(1,:),C(2,:),'y-'),plot(x,y,'g')

Cr=round(C);
for i =1:length(Cr)-1,distCr(i)=sqrt((Cr(1,i+1)-Cr(1,i))^2 + (Cr(2,i+1)-Cr(2,i))^2);end
max(distCr)

% if max(distCr)>=2, repeat bspline_deboor with double last parameter value
%lines from 65 to 70 are then not needed, and 42 also not

Er=[];E=[];E(:,1)=C(:,1);Er(:,1)=Cr(:,1);
b=0;
for i =1:length(Cr)-1,
    if i==1,d=sqrt((Cr(1,i+1)-Cr(1,i))^2+(Cr(2,i+1)-Cr(2,i))^2);else
        d=sqrt((Cr(1,i+1)-XY(1))^2+(Cr(2,i+1)-XY(2))^2);end
    if d<1,
        if b==0,b=b+1;XY=Cr(:,i);else XY=Cr(:,i-b);b=b+1;end
    elseif 0<d<2,Er=[Er Cr(:,i+1)];E=[E C(:,i+1)];b=0;XY=Cr(:,i+1);
    elseif d>=2,b=0;XY=[round((Cr(1,i+1)+Er(1,end))/2);round((Cr(2,i+1)+Er(2,end))/2)];
        Er=[Er XY];Ad=[Ad XY];E=[E XY];
    end
end
clear XY b d

for i =1:length(E),
    if i==1,dist(i)=0;else dist(i)=sqrt((E(1,i)-E(1,i-1))^2 + (E(2,i)-E(2,i-1))^2);end
end

%&&&&&&&&&&&&&&&

Ei=[];Eo=[];
for j=1:3,
    [x_inner, y_inner, x_outer, y_outer, R, unv, concavity, overlap]=parallel_curve(E(1,:), E(2,:), j, 0,0);
    Ei=[Ei;x_inner';y_inner'];Eo=[Eo;x_outer';y_outer'];
end
clear x_inner x_outer y_inner y_outer R unv concavity overlap

figure(4),imshow(image(:,:,1)),hold on,plot(E(1,:),E(2,:),'y'),plot(Ei(1,:),Ei(2,:),'m'),plot(Ei(3,:),Ei(4,:),'c'),plot(Ei(5,:),Ei(6,:),'b'),...
plot(Eo(1,:),Eo(2,:),'m'),plot(Eo(3,:),Eo(4,:),'c'),plot(Eo(5,:),Eo(6,:),'b')

image2=image;
image=double(image);
for i =1:length(E),
    PV(i)=(image(round(E(2,i)),round(E(1,i)),1)+image(round(Ei(2,i)),round(Ei(1,i)),1)+image(round(Ei(4,i)),round(Ei(3,i)),1)+image(round(Ei(6,i)),round(Ei(5,i)),1)+image(round(Eo(2,i)),round(Eo(1,i)),1)+image(round(Eo(4,i)),round(Eo(3,i)),1)+image(round(Eo(6,i)),round(Eo(5,i)),1))./7;
    GFP(i)=(image(round(E(2,i)),round(E(1,i)),2)+image(round(Ei(2,i)),round(Ei(1,i)),2)+image(round(Ei(4,i)),round(Ei(3,i)),2)+image(round(Ei(6,i)),round(Ei(5,i)),2)+image(round(Eo(2,i)),round(Eo(1,i)),2)+image(round(Eo(4,i)),round(Eo(3,i)),2)+image(round(Eo(6,i)),round(Eo(5,i)),2))./7;
    if i==1,
        dist(i)=0;pos(i)=0;
    else
        dist(i)=sqrt((Er(1,i)-Er(1,i-1))^2 + (Er(2,i)-Er(2,i-1))^2);
        pos(i)=sum(dist(1:i));
    end
end
clear image
image=image2;
clear image2

%========================================================
[pks,locs]=findpeaks(PV,'MinPeakDistance',5,'MinPeakProminence',10);
[pks2,locs2]=findpeaks(-PV,'MinPeakDistance',5,'MinPeakProminence',10);

% [pks,locs]=findpeaks(PV,'MinPeakDistance',5,'MinPeakProminence',20);
% [pks2,locs2]=findpeaks(-PV,'MinPeakDistance',5,'MinPeakProminence',20);

locs3=locs2(1:end-1)+round(diff(locs2)./2);
pks3=PV(locs3);

figure(5),plot(PV)
hold on,plot(locs,pks,'r.'),plot(locs2,-pks2,'g.'),plot(locs3,pks3,'k.')

%=================================== verify for each=================
pks3(2:end+1)=pks3;
locs3(2:end+1)=locs3;
pks3(1)=pks(1);
locs3(1)=locs(1);
pks3(end+1)=pks(end);
locs3(end+1)=locs(end);
%===============================================================

temp=image;
temp(:,:,3)=zeros(size(image,1),size(image,2));
figure(8),subplot(1,2,1),imshow(temp),hold on,plot(E(1,locs3),E(2,locs3),'k.')
subplot(1,2,2),imshow(temp),hold on,plot(E(1,locs),E(2,locs),'m.'),hold on,plot(E(1,locs3),E(2,locs3),'b.')
clear temp


F=E(:,locs3);
f=figure(10);imshow(image(:,:,1)),hold on,plot(E(1,:),E(2,:),'y.'),
h=plot(E(1,locs3),E(2,locs3),'b.');
locs4=locs3;

retry=menu('Edit?','Delete','Add','NO');
while retry<3,
    while retry==1,
        delete=ginput;
        for i=1:size(delete,1),
            for j=1:length(F),disttemp(i,j)=sqrt((F(1,j)-delete(i,1))^2 + (F(2,j)-delete(i,2))^2);end
            [temp(i) distind(i)]=min(disttemp(i,:));
        end
        clear temp
        locs4(distind)=[];
        h.Visible='off';
        h=plot(E(1,locs4),E(2,locs4),'b.');
        F=E(:,locs4);
        clear disttemp distind
        retry=menu('Edit?','Delete','Add','NO');
    end
    while retry==2,
        add=ginput;
        for i=1:size(add,1),
            for j=1:length(E),disttemp(i,j)=sqrt((E(1,j)-add(i,1))^2 + (E(2,j)-add(i,2))^2);end
            [temp(i) distind(i)]=min(disttemp(i,:));
        end
        clear temp
        locs4=[locs4,distind];
        locs4=sort(locs4);
        h.Visible='off';
        h=plot(E(1,locs4),E(2,locs4),'b.');
        F=E(:,locs4);
        clear disttemp distind
        retry=menu('Edit?','Delete','Add','NO');
    end
end

temp=image;
temp(:,:,3)=zeros(size(image,1),size(image,2));
figure(9),imshow(temp),hold on,hold on,plot(E(1,locs4),E(2,locs4),'b.')
clear temp



for i=1:length(locs4),
    cellPV(i)=mean(PV(locs4(i)-1:locs4(i)+1));
    cellGFP(i)=mean(GFP(locs4(i)-1:locs4(i)+1));
end

figure(9),subplot(2,1,1),plot(cellPV,'r'),hold on,plot(cellGFP,'g')
subplot(2,2,3),histogram(cellPV,'BinWidth',10),title('PV'),subplot(2,2,4),histogram(cellGFP,'BinWidth',10),title('GFP')
figure(10),subplot(2,1,1),plot(cellGFP./cellPV),subplot(2,1,2),histogram(cellGFP./cellPV,'BinWidth',0.05)


reg=regexp(filename,'\');
name=['_' filename(reg(end-2)+1:reg(end-1)-1) '_' filename(reg(end-1)+1) '_' filename(reg(end)+2)];
name1=['image' name];eval([name1 '=image;'])
name2=['x' name];eval([name2 '=x;'])
name3=['y' name];eval([name3 '=y;'])
name4=['C' name];eval([name4 '=C;'])
name5=['PV' name];eval([name5 '=PV;'])
name6=['GFP' name];eval([name6 '=GFP;'])
name7=['pos' name];eval([name7 '=pos;'])
name8=['locs4' name];eval([name8 '=locs4;'])
name9=['cellPV' name];eval([name9 '=cellPV;'])
name10=['cellGFP' name];eval([name10 '=cellGFP;'])
name11=['E' name];eval([name11 '=E;'])

save('W:\public\Data\CaBP1_2\Immuno\Rescue\fluo_PHPeB.mat', name1, name2, name3, name4, name5, name6, name7, name8, name9, name10, name11, '-append')

order=[1 2 3];

name12=['order' name];eval([name12 '=order;'])
save('W:\public\Data\CaBP1_2\Immuno\Rescue\fluo_PHPeB.mat', name12, '-append')

%``````````````````````````````
load 'W:\public\Data\CaBP1_2\Immuno\Rescue\fluo_PHPeB.mat' '-regexp' 'cellPV' 'cellGFP'

cellGFP_1_i=[cellGFP_1_i_1,cellGFP_1_i_2,cellGFP_1_i_3,cellGFP_1_i_4,cellGFP_1_i_5];
cellGFP_1_n=[cellGFP_1_n_1,cellGFP_1_n_2,cellGFP_1_n_3];
cellGFP_95_i=[cellGFP_95_i_1,cellGFP_95_i_2];
cellGFP_95_n=[cellGFP_95_n_1,cellGFP_95_n_2,cellGFP_95_n_3,cellGFP_95_n_4,cellGFP_95_n_5,cellGFP_95_n_6];
cellGFP_96_i=[cellGFP_96_i_1,cellGFP_96_i_2,cellGFP_96_i_3,cellGFP_96_i_4,cellGFP_96_i_5];
cellGFP_96_n=[cellGFP_96_n_1,cellGFP_96_n_2,cellGFP_96_n_3,cellGFP_96_n_4,cellGFP_96_n_5,cellGFP_96_n_6];
cellGFP_97_i=[cellGFP_97_i_1,cellGFP_97_i_2,cellGFP_97_i_3,cellGFP_97_i_4];
cellGFP_97_n=[cellGFP_97_n_1,cellGFP_97_n_2,cellGFP_97_n_3,cellGFP_97_n_4];
cellGFP_99_n=[cellGFP_99_n_1,cellGFP_99_n_2,cellGFP_99_n_3,cellGFP_99_n_4];
cellPV_1_i=[cellPV_1_i_1,cellPV_1_i_2,cellPV_1_i_3,cellPV_1_i_4,cellPV_1_i_5];
cellPV_1_n=[cellPV_1_n_1,cellPV_1_n_2,cellPV_1_n_3];
cellPV_95_i=[cellPV_95_i_1,cellPV_95_i_2];
cellPV_95_n=[cellPV_95_n_1,cellPV_95_n_2,cellPV_95_n_3,cellPV_95_n_4,cellPV_95_n_5,cellPV_95_n_6];
cellPV_96_i=[cellPV_96_i_1,cellPV_96_i_2,cellPV_96_i_3,cellPV_96_i_4,cellPV_96_i_5];
cellPV_96_n=[cellPV_96_n_1,cellPV_96_n_2,cellPV_96_n_3,cellPV_96_n_4,cellPV_96_n_5,cellPV_96_n_6];
cellPV_97_i=[cellPV_97_i_1,cellPV_97_i_2,cellPV_97_i_3,cellPV_97_i_4];
cellPV_97_n=[cellPV_97_n_1,cellPV_97_n_2,cellPV_97_n_3,cellPV_97_n_4];
cellPV_99_n=[cellPV_99_n_1,cellPV_99_n_2,cellPV_99_n_3,cellPV_99_n_4];

figure(1)
subplot(5,3,1),histogram(cellPV_1_i,'BinWidth',10,'Normalization','probability'),hold on,histogram(cellPV_1_n,'BinWidth',10,'Normalization','probability'),title('PV'),axis([0 250 0 0.26]),ylabel('Fraction of cells'),text(10,0.24,['n = ' num2str(length(cellPV_1_n))],'Color',[0.85 0.33 0.1]),text(10,0.21,['n = ' num2str(length(cellPV_1_i))],'Color',[0 0.45 0.74]) 
subplot(5,3,2),histogram(cellGFP_1_i,'BinWidth',10,'Normalization','probability'),hold on,histogram(cellGFP_1_n,'BinWidth',10,'Normalization','probability'),title('GFP'),axis([0 250 0 0.26])
subplot(5,3,3),histogram(cellGFP_1_i./cellPV_1_i,'BinWidth',0.05,'Normalization','probability'),hold on,histogram(cellGFP_1_n./cellPV_1_n,'BinWidth',0.05,'Normalization','probability'),title('GFP/PV'),axis([0 3 0 0.26]),text(2.5,0.24,'#1') 

subplot(5,3,4),histogram(cellPV_95_i,'BinWidth',10,'Normalization','probability'),hold on,histogram(cellPV_95_n,'BinWidth',10,'Normalization','probability'),axis([0 250 0 0.26]),ylabel('Fraction of cells'),text(10,0.24,['n = ' num2str(length(cellPV_95_n))],'Color',[0.85 0.33 0.1]),text(10,0.21,['n = ' num2str(length(cellPV_95_i))],'Color',[0 0.45 0.74])
subplot(5,3,5),histogram(cellGFP_95_i,'BinWidth',10,'Normalization','probability'),hold on,histogram(cellGFP_95_n,'BinWidth',10,'Normalization','probability'),axis([0 250 0 0.26])
subplot(5,3,6),histogram(cellGFP_95_i./cellPV_95_i,'BinWidth',0.05,'Normalization','probability'),hold on,histogram(cellGFP_95_n./cellPV_95_n,'BinWidth',0.05,'Normalization','probability'),axis([0 3 0 0.26]),text(2.5,0.24,'#95') 

subplot(5,3,7),histogram(cellPV_96_i,'BinWidth',10,'Normalization','probability'),hold on,histogram(cellPV_96_n,'BinWidth',10,'Normalization','probability'),axis([0 250 0 0.26]),ylabel('Fraction of cells'),text(10,0.24,['n = ' num2str(length(cellPV_96_n))],'Color',[0.85 0.33 0.1]),text(10,0.21,['n = ' num2str(length(cellPV_96_i))],'Color',[0 0.45 0.74])
subplot(5,3,8),histogram(cellGFP_96_i,'BinWidth',10,'Normalization','probability'),hold on,histogram(cellGFP_96_n,'BinWidth',10,'Normalization','probability'),axis([0 250 0 0.26])
subplot(5,3,9),histogram(cellGFP_96_i./cellPV_96_i,'BinWidth',0.05,'Normalization','probability'),hold on,histogram(cellGFP_96_n./cellPV_96_n,'BinWidth',0.05,'Normalization','probability'),axis([0 3 0 0.26]),text(2.5,0.24,'#96') 

subplot(5,3,10),histogram(cellPV_97_i,'BinWidth',10,'Normalization','probability'),hold on,histogram(cellPV_97_n,'BinWidth',10,'Normalization','probability'),axis([0 250 0 0.26]),ylabel('Fraction of cells'),text(10,0.24,['n = ' num2str(length(cellPV_97_n))],'Color',[0.85 0.33 0.1]),text(10,0.21,['n = ' num2str(length(cellPV_97_i))],'Color',[0 0.45 0.74])
subplot(5,3,11),histogram(cellGFP_97_i,'BinWidth',10,'Normalization','probability'),hold on,histogram(cellGFP_97_n,'BinWidth',10,'Normalization','probability'),axis([0 250 0 0.26])
subplot(5,3,12),histogram(cellGFP_97_i./cellPV_97_i,'BinWidth',0.05,'Normalization','probability'),hold on,histogram(cellGFP_97_n./cellPV_97_n,'BinWidth',0.05,'Normalization','probability'),axis([0 3 0 0.26]),text(2.5,0.24,'#97') 

subplot(5,3,13),histogram(cellPV_99_n,'BinWidth',10,'Normalization','probability','FaceColor',[0.85 0.33 0.1]),axis([0 250 0 0.26]),ylabel('Fraction of cells'),xlabel('Fluorescence (a.u.)'),text(10,0.24,['n = ' num2str(length(cellPV_99_n))],'Color',[0.85 0.33 0.1])
subplot(5,3,14),histogram(cellGFP_99_n,'BinWidth',10,'Normalization','probability','FaceColor',[0.85 0.33 0.1]),axis([0 250 0 0.26]),xlabel('Fluorescence (a.u.)')
subplot(5,3,15),histogram(cellGFP_99_n./cellPV_99_n,'BinWidth',0.05,'Normalization','probability','FaceColor',[0.85 0.33 0.1]),axis([0 3 0 0.26]),xlabel('Fluorescence ratio'),text(2.5,0.24,'#99') 

set(gcf,'Position',[322 59 662 1036])

for i=1:15,
    subplot(5,3,i),
    set(gca,'Box','off','LineWidth',1,'TickLength',[0.03 0.025],'TickDir','out','FontName','Arial','YTick',[0 0.1 0.2])
    if ((i-1)./3)==(round((i-1)./3)),
        y=0.13;
        %ylabel('Fraction of cells'),
    elseif ((i-1)./3)-(round((i-1)./3))>0.3,
        y=0.41;
        set(gca,'YTickLabel','')
    else
        y=0.69;
        set(gca,'YTickLabel','')
    end
    x=(5-ceil(i./3))*0.17+0.1;  
    if (ceil(i./3)<5),
        set(gca,'XTickLabel','')
        %set(gca,'YTickLabel',[0 0.1 0.2])
    end
    set(gca,'Position',[y x 0.25 0.1492])
end

%==========================================================================
load 'W:\public\Data\CaBP1_2\Immuno\Rescue\fluo_PHPeB.mat' '-regexp' 'freq'

freq_1_i=[freq_1_i_1;freq_1_i_2;freq_1_i_3;freq_1_i_4;freq_1_i_5];
freq_1_n=[freq_1_n_1_1;freq_1_n_1_2;freq_1_n_2;freq_1_n_3];
freq_95_n=[freq_95_n_1;freq_95_n_2;freq_95_n_3;freq_95_n_4;freq_95_n_5;freq_95_n_6];
freq_96_i=[freq_96_i_1;freq_96_i_2;freq_96_i_3;freq_96_i_4;freq_96_i_5];
freq_96_n=[freq_96_n_1;freq_96_n_2;freq_96_n_3;freq_96_n_4;freq_96_n_5;freq_96_n_6];
freq_97_i=[freq_97_i_1;freq_97_i_2;freq_97_i_3;freq_97_i_4];
freq_97_n=[freq_97_n_1;freq_97_n_2;freq_97_n_3;freq_97_n_4];
freq_99_n=[freq_99_n_1;freq_99_n_2;freq_99_n_3;freq_99_n_4];


cellGFP_i=[cellGFP_1_i,cellGFP_96_i,cellGFP_97_i];
freq_i=[freq_1_i;freq_96_i;freq_97_i];

cellGFP_n=[cellGFP_1_n,cellGFP_95_n,cellGFP_96_n,cellGFP_97_n,cellGFP_99_n];
freq_n=[freq_1_n;freq_95_n;freq_96_n;freq_97_n;freq_99_n];

for i=1:8,
    binind=find(freq_i<exp(7.6+i*0.5) & freq_i>exp(7.1+i*0.5));
    binfreqi(i)=exp(7.35+i*0.5);
    binfluomi(i)=mean(cellGFP_i(binind));
    binfluosemi(i)=std(cellGFP_i(binind))./sqrt(length(cellGFP_i(binind))-1);
    
    binind=find(freq_n<exp(7.6+i*0.5) & freq_n>exp(7.1+i*0.5));
    binfreqn(i)=exp(7.35+i*0.5);
    binfluomn(i)=mean(cellGFP_n(binind));
    binfluosemn(i)=std(cellGFP_n(binind))./sqrt(length(cellGFP_n(binind))-1);
end

xtick=(1:7).*0.5+7.35;
xticklabel=round((binfreqi)/100)./10;

cellPV_i=[cellPV_1_i,cellPV_96_i,cellPV_97_i];
cellPV_n=[cellPV_1_n,cellPV_95_n,cellPV_96_n,cellPV_97_n,cellPV_99_n];

for i=1:8,
    binind=find(freq_i<exp(7.6+i*0.5) & freq_i>exp(7.1+i*0.5));
    PVbinfluomi(i)=mean(cellPV_i(binind));
    PVbinfluosemi(i)=std(cellPV_i(binind))./sqrt(length(cellPV_i(binind))-1);
    
    binind=find(freq_n<exp(7.6+i*0.5) & freq_n>exp(7.1+i*0.5));
    PVbinfluomn(i)=mean(cellPV_n(binind));
    PVbinfluosemn(i)=std(cellPV_n(binind))./sqrt(length(cellPV_n(binind))-1);
end

figure(1),
%subplot(1,3,1),
errorbar(log(binfreqi),binfluomi,binfluosemi,'k.'),title('PHP.eB'),
hold on,bar(log(binfreqi),binfluomi,'FaceColor',[128/255 254/255 0])
hold on,errorbar(log(binfreqn),binfluomn,binfluosemn,'k.'),
hold on,bar(log(binfreqn),binfluomn,'FaceColor',[0 169/255 254/255])
axis([7.5 11.2 0 200])
set(gca,'XTick',xtick,'XTickLabel',xticklabel)
xlabel('Tonotopic frequency (kHz)')
ylabel('Fluorescence (a.u.)')
set(gca,'Box','off','FontName','Arial','LineWidth',1,'TickDir','out','TickLength',[0.02 0.05]) 

