function [Afpar, Ifpar]=fitkin(steps,ssv,ftr,sttF,whatfit,constrainToFirstFit)

% INPUTS
% steps ... time x numberOfSweeps vector of just the current response to a
% a voltage step, where time is in intervals of 0.1 ms. 
% ssv ... numberOfSweeps x 1 vector of the voltage of each sweep (mV)
% ftr ... the handle of the figure you want to plot into
% sttF ... 1x2 vector defining range of state factor or n, it's the power some equations are raised to.
% Ranges 1-4 but typically 2 or 3
% whatfit ...'w' or 'z' or 'wz' where w = activation and z = inactivation
% constrainToFirstFit ... Boolean, is I want to use some values from the
% first fit. I didn't use this.

% Set up the activation fit equations
expgro = fittype( @(A, t, n, y0, x) A*(1-exp(-x/t)).^n + y0);
expgro2 = fittype( @(A, t, n, As, ts, y0, x) A*(1-exp(-x/t)).^n +As*(1-exp(-x/ts)).*(1-exp(-x/t)).^n+y0);
Rusch=fittype( @(A,t1,t2,y0,x) A-(A-y0).*(t1.*exp(-x./t1)-t2.*exp(-x./t2))./(t1-t2));
sgldel = fittype( @(F,taud,d,c,x) F*(1 - exp(-(x - d)./taud)) + c);
%dbldel = fittype( @(F,taud,d,c,x) (1 - exp(-(x - d)./tau3)).*(F3 + F2*(1 - exp(-(x - d)./tau2))) + c);

% Define variable names for an eventual big table
varNames={'V';'A';'tau';'n';'y0';'R2';'R2adj';'t1';'t2';...
    'Af';'tauf';'n2';'As';'taus';'y02';'R22';'R2adj2';...
    'Ar';'t1r';'t2r';'y0r';'R2r';'R2adj3';...
    'F';'taud';'d';'c';'R2d';'R2dadj';...
    'F3';'tau3';'F2';'tau2';'c2';'R2dd';'R2ddadj'};
varTypes={'double';'double';'double';'double';'double';'double';'double';...
    'double';'double';'double';'double';'double';'double';'double';'double';...
    'double';'double';'double';'double';'double';'double';'double';'double';...
    'double';'double';'double';'double';'double';...
    'double';'double';'double';'double';'double';'double';'double';'double'};


% Define some things
nswp=numel(steps(1,:)); % number of sweeps
ssv=ssv(1:nswp); % sometimes ssv is larger than steps, if I manually cut off some sweeps where the recording quality got worse
npts=numel(steps(:,1)); % number of time points

% Assumes all have been downsampled to 0.1ms. I downsampled before these
% fits because K currents are too slow to require that much temporal
% resolution and makes fits go faster
time=[0.1:0.1:0.1*npts]';

% Allocate space
Afpar=nan(nswp,36);

% Decide which sweeps to actually fit based on 3 conditions: 
%(1) Current is a sizeable response (threshold 0.03nA)
%(2) Step is at least 200ms long
%(3) There are fewer than 300 repeated values--this avoids the steps that
%clipped and saturated the amplifier. I never liked how I did this though,
%so I ended up manually removing clipped sweeps. They didn't happen often
%anyway, moreso in my earlier recordings.
m=[];
for b=1:nswp
    if abs((max(steps(20:end,b))-min(steps(20:end,b))))>0.03 && npts>=2000
        %cleaned=npts-numel(unique(steps(:,b))); %this cleaning method
        %sucks
        %if cleaned<300 %300 repeated values = 30ms
        m=[m,b];
        %end
    end
end

% Run the activation fit if that was requested
if contains(whatfit,'w')
    
    % This loops through each selected sweep and fits it
    for j=m % m being our "to-be-fitted" sweep selection
        set(0,'currentfigure',ftr)
        Afpar(j,1) = ssv(j); %assigning ssv to fpar(1)
        i0 = 5; %always start looking for the place to start the fit after the first 0.5-1 ms of the step to avoid capacitance transients
        % i1 = first fit point
        % i2 = last fit point

        %plots after the first 0.5ms in grey
        plot(time(i0:end),steps(i0:end,j),'DisplayName',num2str(Afpar(j,1),2),'Color',[0.8 0.8 0.8])
        hold on

        grid on
        grid minor

        % Pick the start and stop indices to fit

        %picking the start and stop point is automated, not manual. The
        %manual option has been commented out below.
        %t1=input('start time: ');
        %i1=11*t1;

        %i2 means last point fitted for activation fitting
        %to find start point, find the minimum
            %constrain minimum to between 1ms and 11ms
        %I have made it absolute value to be tolerant of sodium currents

        % We need to mind gK,L here. Because gK,L starts to activate
        % negative to EK, we will get some negative going activating
        % currents
        neg = mean(steps(i0:end-100,j))<0; %if the first 10 ms are negative

        % Find the minimum in the first 20 ms
        [mni,i1] = min(abs(steps(i0:200,j))); %abs value makes it tolerant of sodium currents
        i1=i1+i0; %add i0 bcz min gives relative idx
        t1=i1/10; %converts to time for records and plotting on correct timescale  

        % Find the maximum (peak) between that early minimum and the step
        % end
        [pki,i2]=max(abs(steps(i1:end-5,j)));    
            %abs is for gKL
            %this causing failure of fitting for a small numbers of cells with small outward currents
        i2=i2+i1;    %add 20 bcz max gives relative idx and add 10 bcz
        
        % Halfpoint-related code is an aborted attempt to fit just one part
        % of the activation curve. This can be a good thing to do if you
        % want a simple fit but have many overlapping currents. I never
        % ended up using it much though.
        halfpoint = round(i2/2);
        halftime = halfpoint/10;

        t2=i2/10; %converts to time for records and plotting on correct timescale     

        % Cut out the time and current that will be fit
        fy = steps(i1:i2,j); %the portion of sweep that is fit
        tf=0.1*numel(fy); % tf is the duration being fit, for generation of shifted time, for use in fitting 
        ft=[t1:0.1:t2]'; %IMPORTANT: ft is the real time corresponding to the 
                         %portion of the sweep being fit, 
                         %0 is the start of the sweep and fit, even if 0 is not
                         %being fit
        %ft = [0.1:0.1:tf]'; % for example, this is incorrect, it sets the wrong time 0

        % Halfpoint-related code
        ftdel=[halftime:0.1:t2]';
        fydel=steps(halfpoint:end,j);

        % Plotting the portion of the sweep to be fit
        plot(ft,fy,'k','DisplayName',num2str(Afpar(j,1),2))
        hold on

        xlim([0 time(end)])
        xlabel('time (ms)')
        ylabel('current (nA)')



        % Set reasonable initial values for fit parameters
        if neg % if gK,l and <EK
            %getting initial values for both FAST and SLOW
            %some functions have more wiggle room than others
            pki=-pki;
            Aguess = pki;
            tguess = 15;
            nguess = 3;
            Asguess=pki/5;
            tsguess=tguess*5;
            y0guess = mni;
            guesses = [Aguess tguess nguess y0guess];
            guesses2 = [Aguess tguess nguess Asguess tsguess y0guess];
            lolim = -10;
            uplim = 0;
        else
            %getting initial values for both FAST and SLOW
            %some functions have more wiggle room than others
            Aguess = pki;
            tguess = 15;
            nguess = 3;
            Asguess=pki/5;
            tsguess=tguess*5;
            y0guess = mni;
            guesses = [Aguess tguess nguess y0guess];
            guesses2 = [Aguess tguess nguess Asguess tsguess y0guess];

            lolim=0;
            uplim=30;
        end

   %     ylim([min(steps(10:end-10,j))-0.1 pki+0.1]); %gKL will dip below this sometimes...


        try %FAST
            %some limits are important depending on the function and data. 
            %exponent n is often limited to 2, since it is usually around
            %there
            ftcurve=fit(ft,fy, expgro,'StartPoint',guesses,...
                'Lower',[lolim 0 sttF(1) -neg*mni],'Upper',[uplim 10000 sttF(2) mni-neg*mni]);

            fp=coeffvalues(ftcurve);

            %this generates a fit curve for 2 purposes: plot on the graph
            %in red for visual inspection and calculate Rsqrd
            yy=fp(1).*(1-exp(-ft./fp(2))).^fp(3) + fp(4);

            Afpar(j,2:5)=coeffvalues(ftcurve);
            Afpar(j,8)=t1;
            Afpar(j,9)=t2;

            %calculate Rsqrd
            R2=1-sum((fy-yy).^2)./sum((fy-mean(fy)).^2);
            R2adj=1-(1-R2)*(numel(fy)-1)./(numel(fy)-numel(fp)-1);
            Afpar(j,6)=R2;
            Afpar(j,7)=R2adj;

            plot(ft,yy,'r','LineWidth',1,'DisplayName',num2str(R2))
            hold on
        catch
            disp('expgro failed')
            %do nothing
        end %of expdec try


        %using a try loop for the actual fit is important because fits fail
        %a lot
        try %FAST and SLOW
            %some limits are important depending on the function and data. 
            %exponent n is often limited to 2, since it is usually around
            %there
            ftcurve=fit(ft,fy, expgro2,'StartPoint',guesses2,...
                'Lower',[lolim 0 sttF(1) lolim 1 -neg*mni],'Upper',[uplim 10000 sttF(2) uplim 10000 mni-neg*mni]);

            fp=coeffvalues(ftcurve);

            %this generates a fit curve for 2 purposes: plot on the graph
            %in red for visual inspection and calculate Rsqrd
            yy=fp(1).*(1-exp(-ft./fp(2))).^fp(3) + fp(4).*(1-exp(-ft./fp(5)))+fp(6);

            Afpar(j,10:15)=coeffvalues(ftcurve);

            %calculate Rsqrd
            R2=1-sum((fy-yy).^2)./sum((fy-mean(fy)).^2);
            R2adj=1-(1-R2)*(numel(fy)-1)./(numel(fy)-numel(fp)-1);
            Afpar(j,16)=R2;
            Afpar(j,17)=R2adj;

            plot(ft,yy,'g','LineWidth',1,'DisplayName',num2str(R2))
            hold on
        catch
            Afpar(j,10:17)=nan(1,8);
            %do nothing
        end %of expgro2 try




        try %Rusch
            %some limits are important depending on the function and data. 
            %exponent n is often limited to 2, since it is usually around
            %there
            Rguesses=[Aguess 60 1 0.1];
            ftcurve=fit(ft,fy,Rusch,'StartPoint',Rguesses,...
                'Lower',[lolim 0 0 -0.1],'Upper',[uplim 10000 100 1]);

            fp=coeffvalues(ftcurve);

            %this generates a fit curve for 2 purposes: plot on the graph
            %in red for visual inspection and calculate Rsqrd
            yy=fp(1)-(fp(1)-fp(4)).*(fp(2).*exp(-ft./fp(2))-fp(3).*exp(-ft./fp(3)))./(fp(2)-fp(3));

            Afpar(j,18:21)=coeffvalues(ftcurve);

            %calculate Rsqrd
            R2=1-sum((fy-yy).^2)./sum((fy-mean(fy)).^2);
            R2adj=1-(1-R2)*(numel(fy)-1)./(numel(fy)-numel(fp)-1);
            Afpar(j,22)=R2;
            Afpar(j,23)=R2adj;

            plot(ft,yy,'b','LineWidth',1,'DisplayName',num2str(R2))
            hold on
        catch
            Afpar(j,18:23)=nan(1,6);
            %do nothing
        end %of expdec try
        
        try %single exp with delay
            guesses=[Aguess 30 halftime/2 mni];
            ftcurve=fit(ftdel,fydel,sgldel,'StartPoint',guesses,...
                'Lower',[lolim 0 0 -neg*mni],'Upper',[uplim 2000 halftime mni-neg*mni]);

            fp=coeffvalues(ftcurve);

            %this generates a fit curve for 2 purposes: plot on the graph
            %in red for visual inspection and calculate Rsqrd
            yy=fp(1).*(1 - exp(-(ftdel-fp(3))./fp(2))) + fp(4);

            Afpar(j,24:29)=coeffvalues(ftcurve);

            %calculate Rsqrd
            R2=1-sum((fy-yy).^2)./sum((fy-mean(fy)).^2);
            R2adj=1-(1-R2)*(numel(fy)-1)./(numel(fy)-numel(fp)-1);
            Afpar(j,22)=R2;
            Afpar(j,23)=R2adj;

            plot(ft,yy,'b','LineWidth',1,'DisplayName',num2str(R2))
            hold on
        catch
        end
    end %of for sweep
    Afpar = array2table(Afpar,'VariableNames',varNames);
    
end
    


%
%
%
%
%
%
%
%
%
%
%
%
%
%


% Run inactivation fit if requested
if contains (whatfit,'z')
    
    % Define fit functions
    expdec = fittype( @(A, t, y0, x) A*exp(-x/t) + y0);
    expdec2 = fittype( @(As, ts, Af, tf, y0, x) As*exp(-x/ts) + Af*exp(-x/tf) + y0);
    linear=fittype( @(A, m, x) A + m*x); %linear

    % Set some variable names to save parameters in
    varNames={'V';'A';'t';'y0';'R2';'R2adj';'t1';'t2';'Af';'tf';'As';'ts';'y02';'R22';'R2adj2';'A3';'m';'R23';'R2adj3'};
    varTypes={'double';'double';'double';'double';'double';'double';'double';...
        'double';'double';'double';'double';'double';'double';'double';'double';...
        'double';'double';'double';'double'};


    % Make time vector assuming all have been downsampled to 0.1ms
    time=[0.1:0.1:0.1*npts]';
    
    % Pre-allocated space for parameters
    Ifpar=nan(nswp,19);

    % Decide which sweeps to fit based on 3 conditions:
    %(1) they would actually be able to be fit (threshold 0.05nA)
    %(2) step is at least 200ms
    %(3) there are fewer than 300 repeated values (avoid the steps that
    %saturate)
    m=[];
    for k=1:nswp
        if (max(steps(20:end,k))-min(steps(20:end,k)))>0.03 && npts>=2000
            %cleaned=npts-numel(unique(steps(:,u)));
            %if cleaned<300
            m=[m,k];
            %end
        end
    end

    % Loop through each sweep in m and fit it
    for j=m
        set(0,'currentfigure',ftr)
        Ifpar(j,1)=ssv(j); %assigning ssv to fpar(1)

        % Plots after the first 1ms in grey
        plot(time(10:end),steps(10:end,j),'DisplayName',num2str(Ifpar(j,1),2),'Color',[0.8 0.8 0.8])
        hold on

        grid on
        grid minor

        % Pick the start and stop time  
        [pki,i1]=max(abs(steps(20:end-10,j))); 
        i1=i1+20+10; %need to add 20 bcz max gives relative idx
            %adding 1ms to try to start after end of peak
        t1=i1/10;

        i2=npts-5; %just before the end of the step
        t2=i2/10;

        fy = steps(i1:i2,j); %the portion of sweep that is fit
        tf=0.1*numel(fy); %the duration being fit 
        ft=[t1:0.1:t2]'; %real time, for activation fitting           
        ftfake = [0.1:0.1:tf]'; %fake time, for inactivation fitting

        % Plotting the portion of the sweep to be fit
        plot(ft,fy,'k','DisplayName',num2str(Ifpar(j,1),2))
        hold on

        xlim([0 time(end)])
        xlabel('time (ms)')
        ylabel('current (nA)')

        ylim([-0.1 pki+0.1]);

        % Set initial values
        Aguess = pki/3;
        tguess = 50;
        Asguess=pki/3;
        tsguess=tguess*3;
        y0guess = pki/3;
        guesses = [Aguess tguess  y0guess];
        guesses2 = [Aguess tguess Asguess tsguess y0guess];

        % Run fits in try loops
        try %SINGLE
            %some limits are important depending on the function and data. 
            %exponent n is often limited to 2, since it is usually around
            %there
            ftcurve=fit(ft,fy, expdec,'StartPoint',guesses,...
                'Lower',[0 0 0],'Upper',[20 10000 15]);

            fp=coeffvalues(ftcurve);

            %this generates a fit curve for 2 purposes: plot on the graph
            %in red for visual inspection and calculate Rsqrd
            yy=fp(1).*exp(-ft./fp(2)) + fp(3);

            Ifpar(j,2:4)=coeffvalues(ftcurve);
            Ifpar(j,7)=t1;
            Ifpar(j,8)=t2;

            %calculate Rsqrd
            R2=1-sum((fy-yy).^2)./sum((fy-mean(fy)).^2);
            R2adj=1-(1-R2)*(numel(fy)-1)./(numel(fy)-numel(fp)-1);
            Ifpar(j,5)=R2;
            Ifpar(j,6)=R2adj;

            plot(ft,yy,'r','LineWidth',1,'DisplayName',num2str(R2))
            hold on
        catch
            %do nothing
        end %of expdec try


        %using a try loop for the actual fit is important because fits fail
        %a lot
        try %DOUBLE
            %some limits are important depending on the function and data. 
            if ~constrainToFirstFit || j==1
                ftcurve=fit(ft,fy, expdec2,'StartPoint',guesses2,...
                    'Lower',[0 0 0 0 0],'Upper',[20 10000 20 10000 15]);
            elseif constrainToFirstFit && j>1
               
                ftcurve=fit(ft,fy, expdec2,'StartPoint',guesses2,...
                    'Lower',[0 Ifpar(j-1,10:12) 0],'Upper',[20 Ifpar(j-1,10:12) 15]);
            end

            fp=coeffvalues(ftcurve);

            %this generates a fit curve for 2 purposes: plot on the graph
            %in red for visual inspection and calculate Rsqrd
            yy=fp(1).*exp(-ft./fp(2))+fp(3).*exp(-ft./fp(4)) + fp(5);

            Ifpar(j,9:13)=coeffvalues(ftcurve);

            % Calculate Rsqrd
            R2=1-sum((fy-yy).^2)./sum((fy-mean(fy)).^2);
            R2adj=1-(1-R2)*(numel(fy)-1)./(numel(fy)-numel(fp)-1);
            Ifpar(j,14)=R2;
            Ifpar(j,15)=R2adj;

            plot(ft,yy,'b','LineWidth',1,'DisplayName',num2str(R2))
            hold on
        catch

        end %of expdec try

                %using a try loop for the actual fit is important because fits fail
        %a lot
        try %LINE
            %some limits are important depending on the function and data. 
            ftcurve=fit(ft,fy, linear,'StartPoint',[pki -0.001],...
                'Lower',[0 -Inf],'Upper',[20 0]);

            fp=coeffvalues(ftcurve);

            %this generates a fit curve for 2 purposes: plot on the graph
            %in red for visual inspection and calculate Rsqrd
            yy=fp(1)+fp(2).*ft;
            Ifpar(j,16:17)=coeffvalues(ftcurve);

            %calculate Rsqrd
            R2=1-sum((fy-yy).^2)./sum((fy-mean(fy)).^2);
            R2adj=1-(1-R2)*(numel(fy)-1)./(numel(fy)-numel(fp)-1);
            Ifpar(j,18)=R2;
            Ifpar(j,19)=R2adj;

            plot(ft,yy,'g','LineWidth',1,'DisplayName',num2str(R2))
            hold on
        catch

            %do nothing
        end %of expdec try

    end %of for sweep

    Ifpar = array2table(Ifpar,'VariableNames',varNames);
else
    Ifpar = [];
end



end