%% Written by Q. Peter Su on Nov 11-19 2012
%  for combine all the matlab codes for STORM 


%  Combine all the STORM codes together
%  0. ST00_STdata5_2S              Raw tiff data analysis
%  1. ST01_ViewPointFits2()        Pre-view dots in tiff movie
%  2. ST02_Merge_and_plotfiles()   Merge and plot dots in a layer
%  3. ST03_AvImage2()              Crop image every x frames
%  4. ST04_genXcorrDrift_3D()      Generate drift correction vector
%  5. ST05_DriftCorrect_3D()       Drift Correction
%  6. ST06_2colorXcorr_3D()        Two color drift correction vector
%  7. ST07_precisionstat_3D        Precision and cluster picking
%  8. ST08_fastmap()               Generate tiff file
%  9. ST09_STcoloc_3D()            3D Colocalization analysis
% 10. ST10_Domain3D()              Domain analysis
% 11. ST11_DeletePoint()           Delete Unexpected Beads or Bckg
% 21. ST21_insight2matlab()        Convert insight3 mol. list to dat file
% 22. ST22_IndexBF_and_GenDrift()  Use Bright Field image to Correct Drift


%%
function ST00_1_allSTcodes

clc
clear all
close all
%% Single-Color or Dual-Color
disp('How Many Colors Did You Image for This Sample ? ')
disp('Press s for Single-Color Image, d for Dual-Color Image.')
judge1=input('Or, You Wanna Select a STORM Code, Press c  ','s');
%% Single Color STORM
if judge1=='s'
    %%%%%%%% Pre view the picked dots in tiff file %%%%%%%%%%%%%%%%%%%%%%%
    disp('Want to Preview the Dots in tiff File First?');
    judge2=input('y for Yes and n for No  ','s');
    if judge2=='y'
        while judge2=='y'
            ST01_ViewPointFits2();
            clc
            judge2=input('Preview Another File? y or n? ','s');
        end
    end
    %%%%%%%%% Display the procedure for the analysis %%%%%%%%%%%%%%%%%%%%%
    disp('Here is the Procedure for the Single-Color Data Analysis.');
    disp('1.Merge & plot the dots          2.Crop a Single Bead');
    disp('3.Generate Drift Vector          4.Drift Correction');
    disp('5.Precision and Cluster Picking  6.Domain Picking(Optional)');
    disp('7.Fastmap tiff Image(Optional)');
    %%%%%%%%%% Process the analysis %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    judge3=input('Are You Clear with the Procedure, y ?  ','s');    
    if judge3=='y'
        disp('1.Merge & plot the dots');
        disp('ST02_Merge_and_plotfiles()');  ST02_Merge_and_plotfiles();        
        driftjudge=input('Drift Correction? y or n?  ','s');
        if driftjudge=='y'
        disp('2. Crop a Single Bead in the ');
        disp('ST03_AvImage2()');             ST03_AvImage2();    
        disp('3.Generate Drift Vector');
        disp('ST04_genXcorrDrift_3D()');     ST04_genXcorrDrift_3D();
        disp('4.Drift Correction');
        disp('ST05_DriftCorrect_3D()');      ST05_DriftCorrect_3D();
        end
        deletejudge=input('You Wanna Delete Some Unexpected Dots? y or n?  ','s');
        if deletejudge=='y'
            disp('4.1 Delete Unexpected Dots');  
            disp('ST11_DeletePoint()');      ST11_DeletePoint()
        end        
        while judge3=='y'
            disp('5.Precision and Cluster Picking');
            disp('ST07_precisionstat_3D()'); ST07_precisionstat_3D();
            clc
            judge3=input('You Wanna Use Another Cluster Threshold? y or n?  ');
        end
        %%%%%%%%%%%%% domain analysis or not %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        judge4=input('You wanna analyse domains, y or n?  ','s');
        if judge4=='y'
            disp('6.Domain Picking');
            disp('ST10_Domain3D()');         ST10_Domain3D();
        end
        %%%%%%%%%%%% fastmap tiff file or not %%%%%%%%%%%%%%%%%%%%%%%%%%%%
        judge5=input('Want a tiff image of the STORM image, y or n?  ','s');
        if judge5=='y'
            disp('7.Fastmap tiff Image');
            disp('ST08_fastmap()');          ST08_fastmap();
        end
    end
end

%% Dual color
if judge1=='d'
    %%%%%%%%% Display the procedure for the analysis %%%%%%%%%%%%%%%%%%%%%
    disp('Here is the Procedure for the Dual-Color Data Analysis.');
    disp('1.1.Merge & plot the dots(Red)       1.2.Crop Whole Image(Red)');
    disp('2.1.Merge & plot the dots(Green)     2.2.Crop Whole Image(Green)');
    disp('*** Crop a single Bead at Same ROI in Image J for Two Color ***');
    disp('3.1.Generate Drift Vector(R)         3.2.Drift Correction(R)');
    disp('4.1.Generate Drift Vector(G)         4.2.Drift Correction(G)');
    disp('4.3.Two Color Drift Vector(GtoR)     4.4.Drift Correction(G)');
    disp('5.1.Precision and Cluster Picking(R) 5.2.Domain Picking(Optional)');
    disp('5.3.Fastmap tiff Image(Optional)');
    disp('6.1.Precision and Cluster Picking(G) 6.2.Domain Picking(Optional)');
    disp('6.3.Fastmap tiff Image(Optional)');
    disp('7.0 Two Color Colocalization');
    %%%%%%%%%% Process the analysis %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    disp('');
    judge3=input('Are You Clear with the Procedure, y ?  ','s');    
    if judge3=='y' 
        %%%%%%%%%%% Red image %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        disp('First Color for Longer Wavelength (Red)');
        %%%%%%%% Pre view the picked dots in tiff file %%%%%%%%%%%%%%%%%%%
        disp('Want to Preview the Red Dots in tiff File First?');
        judge2=input('y for Yes and n for No  ','s');
        if judge2=='y'
            while judge2=='y'
                ST01_ViewPointFits2();
                clc
                judge2=input('Preview Another Red File? y or n? ','s');
            end
        end
        clc
        disp('1.1.Merge & plot the dots(Red)');
        disp('ST02_Merge_and_plotfiles()');  ST02_Merge_and_plotfiles();
        disp('1.2.Crop Whole Image(Red)');
        disp('Crop the whole image only 1 pixel smaller');
        disp('ST03_AvImage2()');             ST03_AvImage2();
                
        %%%%%%%%%%% Green image %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        clc
        disp('Second Color for Shorter Wavelength (Green)');
        %%%%%%%% Pre view the picked dots in tiff file %%%%%%%%%%%%%%%%%%%
        disp('Want to Preview the Green Dots in tiff File First?');
        judge2=input('y for Yes and n for No  ','s');
        if judge2=='y'
            while judge2=='y'
                ST01_ViewPointFits2();
                clc
                judge2=input('Preview Another Green File? y or n? ','s');
            end
        end
        disp('2.1.Merge & plot the dots(Green)');
        disp('ST02_Merge_and_plotfiles()');  ST02_Merge_and_plotfiles();
        disp('2.2.Crop Whole Image(Green)');
        disp('Crop the whole image only 1 pixel smaller');
        disp('ST03_AvImage2()');             ST03_AvImage2();
                
        %%%% Crop a single Bead at Same ROI in Image J for Two Color %%%%%
        clc
        disp('Copy the new generated files to one folder.')
        disp('Crop a single Bead at Same ROI in Image J for Two Color');
        judge6=input('Finished Bead Picking, press y to continue   ','s');
        if judge6=='y'
            %%%%%%%%%%% Red image %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            disp('3.1.Generate Drift Vector (Red)');
            disp('ST04_genXcorrDrift_3D()');     ST04_genXcorrDrift_3D();
            disp('3.2.Drift Correction (Red)');
            disp('ST05_DriftCorrect_3D()');      ST05_DriftCorrect_3D();
            
            %%%%%%%%%%% Green image %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            disp('4.1.Generate Drift Vector (Green)');
            disp('ST04_genXcorrDrift_3D()');     ST04_genXcorrDrift_3D();
            disp('4.2.Drift Correction (Green)');
            disp('ST05_DriftCorrect_3D()');      ST05_DriftCorrect_3D();
            
            %%%%%%%%%% Two Color Drift %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            disp('4.3.Two Color Drift Vector (GtoR)');
            disp('ST06_2colorXcorr_3D()');       ST06_2colorXcorr_3D();
            disp('4.4. 2nd Drift Correction (Green)');
            disp('ST05_DriftCorrect_3D()');      ST05_DriftCorrect_3D();            
            
            %%%%%%%%%% Red Color %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            clc
            deletejudge=input('You Wanna Delete Some Unexpected Dots? y or n?  ','s');
            if deletejudge=='y'
                disp('Delete Unexpected Dots');  
                disp('ST11_DeletePoint()');      ST11_DeletePoint()
            end
            clc
            disp('5.1.Precision and Cluster Picking (Red)');
            disp('ST07_precisionstat_3D()');     ST07_precisionstat_3D();
            %%%%%%%%%%%%% domain analysis or not %%%%%%%%%%%%%%%%%%%%%%%%%
            clc
            judge4=input('You wanna analyse Red domains, y or n?  ','s');
            if judge4=='y'
                disp('ST10_Domain3D()');         ST10_Domain3D();
            end            
            %%%%%%%%%%%% fastmap tiff file or not %%%%%%%%%%%%%%%%%%%%%%%%
            clc
            judge5=input('Want a tiff image of the Red STORM image, y or n?  ','s');
            if judge5=='y'
                disp('ST08_fastmap()');          ST08_fastmap();
            end
            
            %%%%%%%%%% Green Color %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            clc
            deletejudge=input('You Wanna Delete Some Unexpected Dots? y or n?  ','s');
            if deletejudge=='y'
                disp('Delete Unexpected Dots');  
                disp('ST11_DeletePoint()');      ST11_DeletePoint()
            end
            clc
            disp('6.1.Precision and Cluster Picking (Green)');
            disp('ST07_precisionstat_3D()');     ST07_precisionstat_3D();            
            %%%%%%%%%%%%% domain analysis or not %%%%%%%%%%%%%%%%%%%%%%%%%
            clc
            judge4=input('You wanna analyse Green domains, y or n?  ','s');
            if judge4=='y'
                disp('ST10_Domain3D()');         ST10_Domain3D();
            end
            %%%%%%%%%%%% fastmap tiff file or not %%%%%%%%%%%%%%%%%%%%%%%%
            clc
            judge5=input('Want a tiff image of the Green STORM image, y or n?  ','s');
            if judge5=='y'
                disp('ST08_fastmap()');          ST08_fastmap();
            end            
        end
        clc
        judge7=input('Want Two Color Colocalization? y or n?  ','s');
        if judge7=='y'
            disp('7.0 Two Color Colocalization')
            disp('ST09_STcoloc_3D');             ST09_STcoloc_3D();
        end
    else
        disp('Wrong judge information input');
    end
end


%%
if judge1=='c'
    disp(' 0. ST00_STdata5_2S              Raw tiff data analysis');
    disp(' 1. ST01_ViewPointFits2()        Pre-view dots in tiff movie');
    disp(' 2. ST02_Merge_and_plotfiles()   Merge and plot dots in a layer');
    disp(' 3. ST03_AvImage2()              Crop image every x frames');
    disp(' 4. ST04_genXcorrDrift_3D()      Generate drift correction vector');
    disp(' 5. ST05_DriftCorrect_3D()       Drift Correction');
    disp(' 6. ST06_2colorXcorr_3D()        Two color drift correction vector');
    disp(' 7. ST07_precisionstat_3D        Precision and cluster picking');
    disp(' 8. ST08_fastmap()               Generate tiff file');
    disp(' 9. ST09_STcoloc_3D()            3D Colocalization analysis');
    disp('10. ST10_Domain3D()              Domain analysis');  
    disp('11. ST11_DeletePoint()           Delete Unexpected Dots')
    disp('21. ST21_Insight_to_Matlab()     Convert insight3 mol. list to dat file')
    disp('22. ST22_IndexBF_and_GenDrift()  Use Bright Field image to Correct Drift')
    disp('');
    judge8=input('Press Number of the Codes.  ');
    switch judge8
        case 0
            disp(' 0. ST00_STdata5_2S');              ST00_STdata5_2S
        case 1
            disp(' 1. ST01_ViewPointFits2()');        ST01_ViewPointFits2()
        case 2
            disp(' 2. ST02_Merge_and_plotfiles()');   ST02_Merge_and_plotfiles()
        case 3
            disp(' 3. ST03_AvImage2()');              ST03_AvImage2()
        case 4
            disp(' 4. ST04_genXcorrDrift_3D()');      ST04_genXcorrDrift_3D() 
        case 5
            disp(' 5. ST05_DriftCorrect_3D()');       ST05_DriftCorrect_3D()
        case 6
            disp(' 6. ST06_2colorXcorr_3D()');        ST06_2colorXcorr_3D()
        case 7
            disp(' 7. ST07_precisionstat_3D');        ST07_precisionstat_3D
        case 8
            disp(' 8. ST08_fastmap()');               ST08_fastmap() 
        case 9
            disp(' 9. ST09_STcoloc_3D()');            ST09_STcoloc_3D()
        case 10
            disp('10. ST10_Domain3D()');              ST10_Domain3D()  
        case 11
            disp('11. ST11_DeletePoint()');           ST11_DeletePoint()
        case 21
            disp('21. ST21_Insight_to_Matlab()');     ST21_Insight_to_Matlab()
        case 22
            disp('22. ST22_IndexBF_and_GenDrift()');  ST22_IndexBF_and_GenDrift()
    end
end


end

