%% Wrote by Q.Peter Su on Mar 28-29 2013
%  Used to pre-separate the tif file whose sizes are suitable for STdata5_2S

%% Input
%   1. *tif file(s) output by ImageJ (convert *.nd2 to *.tif)
%   2. filesize, which is the file size of output separated tif file 
%                suitable for STdata5_2S analyzing (<200Mb)

%% Output
%   1. separated *1-10000.tif *10001-20000.tif file  






function ST00_2_PreSeparateTif()
[FileName,PathName] = uigetfile({'*.tif','Multilayer TIFF-Files (*.tif)'},...
                                 'Select the *.tif Stack',...
                                 'MultiSelect', 'on'); 
cd(PathName);disp(PathName);disp(FileName);
%%
if ischar(FileName)
    info = imfinfo([PathName FileName]);
    %xwidth = info(1,1).Width   * Xpixel/1000;     %um values (160nm pixel)
    %yheight = info(1,1).Height * Ypixel/1000;
    FileSize=info(1,1).FileSize / 1000000; % FileSize in Mb
    FrameNo=length(info);
    SeparateSize=100;    % 100Mb per file
    %SeparateSize=input('Type in the Separated Output tif File Size - ');
    SeparateFileNo=ceil(FileSize/SeparateSize);
    SeparateFrameNo=FrameNo/SeparateFileNo;
    FrameUnit=10^(length(num2str(SeparateFrameNo)));
    SeparateFrameNo=ceil(SeparateFrameNo/FrameUnit)*FrameUnit;  
    
    tic
    Stack=uint16([]);
    for smallfilei=1:SeparateFileNo-1
        num1=(smallfilei-1)*SeparateFrameNo+1;
        num2=smallfilei*SeparateFrameNo;
        newFileName=[FileName(1:end-4) '-' num2str(num1) '-' num2str(num2) '.tif'];
        [stack, img_read] = tiffread3(FileName, num1, num2);
        for smallfileframei=1:SeparateFrameNo            
            Stack(:,:)=stack(1,smallfileframei).data;
            imwrite(uint16(Stack),newFileName,'Compression','none','WriteMode','append');            
        end
    end
    
    RestFrameNo=FrameNo-smallfilei*SeparateFrameNo;
    smallfilei=smallfilei+1;
    num1=(smallfilei-1)*SeparateFrameNo+1;
    num2=num1+RestFrameNo-1;
    newFileName=[FileName(1:end-4) '-' num2str(num1) '-' num2str(num2) '.tif'];
    [stack, img_read] = tiffread3(FileName, num1, num2);    
    for smallfileframei=1:RestFrameNo             
        Stack(:,:)=stack(1,smallfileframei).data;
        imwrite(uint16(Stack),newFileName,'Compression','none','WriteMode','append');
    end
    toc
end
%%
if ~ischar(FileName)
    for filei=1:length(FileName)
        fName=char(FileName(filei));
        disp('*** ***');
        str=['This is No. -' num2str(filei) '- file of total -' num2str(length(FileName)) '- files'];
        disp(str);        disp(fName);
        info = imfinfo([PathName fName]);
        %xwidth = info(1,1).Width   * Xpixel/1000;     %um values (160nm pixel)
        %yheight = info(1,1).Height * Ypixel/1000;
        FileSize=info(1,1).FileSize / 1000000; % FileSize in Mb
        FrameNo=length(info);
        SeparateSize=100;    % 100Mb per file
        %SeparateSize=input('Type in the Separated Output tif File Size - ');
        SeparateFileNo=ceil(FileSize/SeparateSize);
        SeparateFrameNo=FrameNo/SeparateFileNo;
        FrameUnit=10^(length(num2str(SeparateFrameNo)));
        SeparateFrameNo=ceil(SeparateFrameNo/FrameUnit)*FrameUnit;  
    
        tic
        Stack=uint16([]);
        for smallfilei=1:SeparateFileNo-1
            num1=(smallfilei-1)*SeparateFrameNo+1;
            num2=smallfilei*SeparateFrameNo;
            newFileName=[fName(1:end-4) '-' num2str(num1) '-' num2str(num2) '.tif'];
            disp(newFileName);
            [stack, img_read] = tiffread3(fName, num1, num2);
            for smallfileframei=1:SeparateFrameNo            
                Stack(:,:)=stack(1,smallfileframei).data;
                imwrite(uint16(Stack),newFileName,'Compression','none','WriteMode','append');            
            end
        end
    
        RestFrameNo=FrameNo-smallfilei*SeparateFrameNo;
        smallfilei=smallfilei+1;
        num1=(smallfilei-1)*SeparateFrameNo+1;
        num2=num1+RestFrameNo-1;
        newFileName=[fName(1:end-4) '-' num2str(num1) '-' num2str(num2) '.tif'];
        disp(newFileName);
        [stack, img_read] = tiffread3(fName, num1, num2);    
        for smallfileframei=1:RestFrameNo             
            Stack(:,:)=stack(1,smallfileframei).data;
            imwrite(uint16(Stack),newFileName,'Compression','none','WriteMode','append');
        end
        toc
    end
end

end