% Code lets you load all RSI**.stk files in a folder and use fit_spots for fitting 
% Gaussians to them 
% Modified from STdata to look for all files in folder and subfolders

%% Rahul July 15, 2011
% removed waitbar function (now STdata3 calls load_images3; tiffread3)

%% Rahul Aug16, 2011
% modified to run fit_spots in two steps
% first a 'heavily' denoised image is used for thresholding (SNR=6) calling
% fit_spots1S then the spots are fed into fit_spots2S for gaussian fitting

%% Rahul Feb10, 2012
% modified from STdata3_2S to now use tiffread30 to read image data, calls load_images4
% also asks which set of images to analyze (original, a, b) 
% set 'a' and 'b' are created by createDiffimages from the original by
% substracting frame n+1 from frame n and frame n-1 from frame n respectively
% created a new subfunction analyse_images()

%% Revised by Q.Peter Su on Apr 15 2013
%  add diary




function ST00_3_STdata5_2S()  %plot and save dots using certain criteria

close all;


%directory = uigetdir;
directory=input('Enter the file directory for analysis\n', 's');  
%input directory of the STORM files
cd(directory);

outfilenametxt=strcat(datestr(now, 1), 'Log.txt');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
diary(outfilenametxt); % diary function
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


SNR = input('Enter the SNR for analysis\n');
% use ImageJ to preview the data for a better Signal to Noise Ratio setting
disp('Which set of images to analyze? ')
setofimages = input('ori for original, ab for set a and b and all for all(default)', 's'); 

A = getAllFiles(directory);  %????????

numberfiles=length(A); % numbers of all the selected files waiting to analyze

inc=1;
n=1;

while (n<=numberfiles)  
   filename = char(A(n));   
 if (filename(end-3:end)=='.tif')   %judge the file type    
    strgcount = ['*** *** This is no.' num2str(n) ' *.tif file of total ' num2str(numberfiles) ' files *** ***'];
     %help num2str: NUM2STR Convert numbers to a string.
     % revised on sep18 2012 by qpsu
        disp(strgcount);  %display on screen This is no.1 tif file of 200 files 
    
   switch lower(setofimages)
    case 'ab'
        TT = (filename(end-4)=='a') | (filename(end-4)=='b');
        if (TT)
           analyze_images(filename, SNR);
        end
    case 'ori'
      TT = (filename(end-4)~='a') & (filename(end-4)~='b');
      if (TT)
         analyze_images(filename, SNR);
      end
    case 'all'     
        analyze_images(filename, SNR);
    otherwise
        display('No files selected for analysis!!!');
   end     
 end
   n=n+inc;
end

diary off;

end

%while
