%% Wrote by Q. Peter Su on Mar 08 2013
%  Used to generate a drift matrix from the last frame to the first one
%  in the red image channel, then applied in all the green frames.




function ST04_1_gen2Cdrift1_RedFirst2Lst()

[FileName,PathName] = uigetfile({'*drift*.mat','Driftave *.mat file';...
         '*.mat','All mat file'},...
         'Select *.mat file of the Red Movie Driftave',...
         'MultiSelect', 'off');
cd(PathName); 
disp(PathName);disp(FileName);
                                  %%%%%%%%%%%%%%%%%%%%%%%
Afname=char(FileName);            %%% X Y Z all in um %%%
Driftave = importdata(Afname);    %%%%%%%%%%%%%%%%%%%%%%%

%% 
disp('Driftave Value in um');
disp('      No.       X         Y        Z       (in um)');
disp(Driftave(1,:));
disp('              Max X     Max Y    Max Z     (in um)');
strg=[0 max(Driftave(:,2)) max(Driftave(:,3)) max(Driftave(:,4)) 0];
disp(strg);
disp('              Min X     Min Y    Min Z     (in um)');
strgg=[0 min(Driftave(:,2)) min(Driftave(:,3)) min(Driftave(:,4)) 0];
disp(strgg);
strggg=[0 max(Driftave(:,2))-min(Driftave(:,2))...
          max(Driftave(:,3))-min(Driftave(:,3))...
          max(Driftave(:,4))-min(Driftave(:,4)) 0];
disp('             Delta X   Delta Y   Delta Z   (in um)');
disp(strggg);
%%
GreenFrame=input('Input the frame number of the Green Movie - ');
frameno=1:GreenFrame;
Driftave2C=zeros([GreenFrame 5]);
Driftave2C(:,1)=frameno';
lastframe=size(Driftave,1);
Driftave2C(:,2)=Driftave(lastframe,2);
Driftave2C(:,3)=Driftave(lastframe,3);
%%
%saveas(gcf, [FileName(1:end-4) '-2Color-Drift.fig'], 'fig');
save([FileName(1:end-4) '-2C_Drift-RedFirst2Last.mat'],'Driftave2C');
%%
%disp('ST05_DriftCorrect_3D()')
%ST05_DriftCorrect_3D()
end