%% Wrote by Q. Peter Su on Mar 16 2013
%  Used to generate a drift matrix 
%  from 
%  the first frame in GREEN movie
%  to 
%  the first frame in RED movie
%  then applied in all the green frames.

%%%%%%%%%%%%  Apr 16 2013 calculate the chromatic aberration %%%%%%%%%%%%
% Xdrift=Xdrift+0.0688*Xpixel/1000;
% strXX=['Chromatic Aberration X Drift - ',num2str(Xdrift*+0.0688),'nm'];
% Ydrift=Ydrift-0.1201*Ypixel/1000;
% strYY=['Chromatic Aberration Y Drift - ',num2str(Ydrift*-0.1201),'nm'];
% disp('---');disp(strXX);disp(strYY);disp('---')

%% Revised by Q.Peter Su on Jan 20 2014
%  add blue channel 2 color drift

%% Revised by Q.Peter Su on Jan 20 2014
% disp('Check the averaged tif image, double check the drift value');
% judge_draw=input('Press Enter Key for right value, -n- for wrong and draw a center','s');


%%
function ST04_2_gen2Cdrift2_Red2Green(Xpixel,Ypixel,Color)
[FileNameR,PathNameR] = uigetfile({'*new*.tif','Normalized BF tif Files (*.tif)';...
                                   '*.tif','All tif Files (*.tif)'},...
                                 'Select the Red Movie *.tif File Stack',...
                                  'Multiselect', 'off'); 
cd(PathNameR);disp(PathNameR);disp(FileNameR);
[FileNameG,PathNameG] = uigetfile({'*new*.tif','Normalized BF tif Files (*.tif)';...
                                   '*.tif','All tif Files (*.tif)'},...
                                 'Select the Green Movie *.tif File Stack',...
                                  'Multiselect', 'off'); 
cd(PathNameG);disp(PathNameG);disp(FileNameG);

StackR=uint16([]);StackG=uint16([]);
if FileNameR~=0
    fR=sprintf('%s%s',PathNameR,FileNameR);
    StackR(:,:,1)=imread(fR,1);    
end
if FileNameG~=0
    fG=sprintf('%s%s',PathNameG,FileNameG);
    StackG(:,:,1)=imread(fG,1);    
end

%%
precision=100;
drift = dftregistration(fft2(StackG(:,:)),fft2(StackR(:,:)),precision);
if nargin<1
    Xpixel=input('Please input X pixel size (in nm)   - ');
    Ypixel=input('Please input Y pixel size (in nm)   - ');
    Color= input('Please input Color Info - g or b    - ','s');
end
Xdrift=drift(4)*Xpixel/1000;strX=['X Drift - ',num2str(Xdrift*1000),'nm'];
Ydrift=drift(3)*Ypixel/1000;strY=['Y Drift - ',num2str(Ydrift*1000),'nm'];
disp('---');disp(strX);disp(strY);disp('---');

disp('Check the averaged tif image, double check the drift value');
judge_draw=input('Press Enter Key for right value, -n- for wrong and draw a center - ','s');
if judge_draw == 'n'
    close all
    
    figure
    imshow(StackR,[0.5*min(StackR(:))  max(StackR(:))])
    title('Red BF first frame')
    h = imrect;
    position = wait(h);
    pos = getPosition(h);
    Rxmin=pos(1); Rxmax=pos(1)+pos(3); Rxmean=(Rxmin+Rxmax)/2;
    Rymin=pos(2); Rymax=pos(2)+pos(4); Rymean=(Rymin+Rymax)/2;
    
    figure
    imshow(StackG,[0.5*min(StackG(:))  max(StackG(:))])
    if Color=='g'
        title('Green BF first frame')
    elseif Color=='b'
        title('Blue BF first frame')
    end
    h = imrect;
    position = wait(h);
    pos = getPosition(h);
    Gxmin=pos(1); Gxmax=pos(1)+pos(3); Gxmean=(Gxmin+Gxmax)/2;
    Gymin=pos(2); Gymax=pos(2)+pos(4); Gymean=(Gymin+Gymax)/2;
    
    Xdrift=(Gxmean-Rxmean)*Xpixel/1000;strX=['X Drift - ',num2str(Xdrift*1000),'nm'];
    Ydrift=(Gymean-Rymean)*Ypixel/1000;strY=['Y Drift - ',num2str(Ydrift*1000),'nm'];
    disp('---');disp(strX);disp(strY);disp('---');
else
    
end



judge=input('Wanna Correct the Chromatic Aberration, -y- for Yes or Enter to skip - ','s');
if judge=='y' 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%  Apr 16 2013 calculate the chromatic aberration %%%%%%%%%%%%
Xdrift=Xdrift+0.0688*Xpixel/1000;
strXX=['Chromatic Aberration X Drift - ',num2str(Xpixel*+0.0688),'nm'];
Ydrift=Ydrift-0.1201*Ypixel/1000;
strYY=['Chromatic Aberration Y Drift - ',num2str(Ypixel*-0.1201),'nm'];
disp('---');disp(strXX);disp(strYY);disp('---')
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
end

GreenFrame=[];
while isempty(GreenFrame)
    if Color=='g'
        GreenFrame=input('Input the frame number of the Green Movie - ');
    elseif Color=='b'
        GreenFrame=input('Input the frame number of the Blue Movie - ');
    end
end

frameno=1:GreenFrame;
Driftave2C=zeros([GreenFrame 5]);
Driftave2C(:,1)=frameno';
Driftave2C(:,2)=Xdrift;
Driftave2C(:,3)=Ydrift;
if Color=='g'
    if judge_draw=='n'
        save([FileNameR(1:end-4) '-2C_Drift-Draw-Red2Green.mat'],'Driftave2C');
    else
        save([FileNameR(1:end-4) '-2C_Drift-Auto-Red2Green.mat'],'Driftave2C');
    end
elseif Color=='b'
    if judge_draw=='n'
        save([FileNameR(1:end-4) '-2C_Drift-Draw-Red2Blue.mat'],'Driftave2C');
    else
        save([FileNameR(1:end-4) '-2C_Drift-Auto-Red2Blue.mat'],'Driftave2C');
    end
end
end