%% Write by Q. Peter Su on Nov 20 2012
%  For delete localizations in STORM image


%% Modified by Q. Peter Su on Dec 21 2012
%  Add hist2.m, a 2D histogram plot code
%  for identify beads which have been fitted thousands times

%% Revised by Q.Peter Su on May 20 2013
%  ST11_1_DeletePoint(Afname)
%% Revinsed by Q. Peter Su on Aug 02 2013
%  output two dat files
%  1. the dots remained
%  2. the dots deleted

%% revised by Q.Peter Su on Nov 20 2013
%  add png file output

%% revised by Q.Peter Su on Dec 05 2013 @ BIOPIC, PKU
%  add bmp file output
%% Revised by Q.Peter SU on 20 Sep. 2017 @ HRI, USYD
%  select a ROI for deletion first
%     index=find(XYZt(:,1)>xmin & XYZt(:,1)<xmax &...
%                XYZt(:,2)>ymin & XYZt(:,2)<ymax);
%     XYZtTemp=XYZt;
%     XYZtTemp(index,:)=[];
%     XYZtDel=XYZtTemp;
%     XYZt=XYZt(index,:);


 
function ST11_1_DeletePoint(Afname)
%clc
%clear all
close all
%%
if nargin<1
[FileName,PathName] = uigetfile('*.dat',...
    'Select .dat file to delete some dots','MultiSelect', 'off');
cd(PathName);
Afname=char(FileName);
end
disp(Afname)
disp('Import Data ... ing ...');
% tic
% XYZt = load(Afname);
% toc
% tic
XYZt = importdata(Afname); % load and importdata got the same time
XminDisp=min(XYZt(:,1));
XmaxDisp=max(XYZt(:,1));
YminDisp=min(XYZt(:,2));
YmaxDisp=max(XYZt(:,2));
% toc
%% Keep the selected ROI first
%  Revised by Q.Peter SU on 20 Sep 2017
judge = '';
while isempty(judge)
    judge = input('Do You Wanna Crop ROIs for Reserve? Press y or n. - ', 's');
end

XYZtDel=[];

while judge == 'y'
    X=XYZt(:,1);   Y=XYZt(:,2);
    Xedges = linspace(min(X),max(X),100); 
    Yedges = linspace(min(Y),max(Y),100);
    histmat = hist2(X, Y, Xedges, Yedges);
    figure; pcolor(Xedges,Yedges,histmat'); colorbar ; axis square tight ;
    set(gca,'YDir','reverse');
    %xlim([min(X) max(X)]);
    %ylim([min(Y) max(Y)]);  
    
    h = imrect;
    position = wait(h);
    pos = getPosition(h);
    xmin=pos(1); xmax=pos(1)+pos(3);
    ymin=pos(2); ymax=pos(2)+pos(4);
    
    close
    figure1 = figure('Color',...
    [0.313725501298904 0.313725501298904 0.313725501298904]);
    axes1 = axes('Parent',figure1,'YDir','reverse');
    box(axes1,'on');
    hold(axes1,'all');
    plot(XYZt(:,1),XYZt(:,2),...
        'MarkerFaceColor',[1 0 0],'MarkerEdgeColor',[1 0 0],...
        'MarkerSize',2,...
        'Marker','.',...
        'LineStyle','none',...
        'Color',[1 1 1]);
    axis equal
    whitebg([0 0 0]);
    xlim([xmin xmax]);
    ylim([ymin ymax]);   
    title('Select ROI to Delete, and Double Click the ROI'); 
    h = imrect;
    position = wait(h);
    pos = getPosition(h);
    xmin=pos(1); xmax=pos(1)+pos(3);
    ymin=pos(2); ymax=pos(2)+pos(4);
    index=find(XYZt(:,1)>xmin & XYZt(:,1)<xmax &...
               XYZt(:,2)>ymin & XYZt(:,2)<ymax);
    XYZtTemp=XYZt;
    XYZtTemp(index,:)=[];
    XYZtDel=XYZtTemp;
    XYZt=XYZt(index,:);
    deletenumber=size(XYZtDel,1);
    strg=['*** ' num2str(deletenumber) ' *** Dots has been deleted.' ];
    disp(strg);    
    disp('--');
    judge='n';
    close all
    
end
    
%% Delete selected ROI
judge = '';
while isempty(judge)
    judge = input('Do You Wanna Crop ROIs for Deletion? Press y or n. - ', 's');
end
close all

while judge == 'y'
    X=XYZt(:,1);   Y=XYZt(:,2);
    Xedges = linspace(min(X),max(X),100); 
    Yedges = linspace(min(Y),max(Y),100);
    histmat = hist2(X, Y, Xedges, Yedges);
    figure; pcolor(Xedges,Yedges,histmat'); colorbar ; axis square tight ;
    set(gca,'YDir','reverse');
    %xlim([min(X) max(X)]);
    %ylim([min(Y) max(Y)]);  
    
    h = imrect;
    position = wait(h);
    pos = getPosition(h);
    xmin=pos(1); xmax=pos(1)+pos(3);
    ymin=pos(2); ymax=pos(2)+pos(4);
    
    close
    figure1 = figure('Color',...
    [0.313725501298904 0.313725501298904 0.313725501298904]);
    axes1 = axes('Parent',figure1,'YDir','reverse');
    box(axes1,'on');
    hold(axes1,'all');
    plot(XYZt(:,1),XYZt(:,2),...
        'MarkerFaceColor',[1 0 0],'MarkerEdgeColor',[1 0 0],...
        'MarkerSize',2,...
        'Marker','.',...
        'LineStyle','none',...
        'Color',[1 1 1]);
    axis equal
    whitebg([0 0 0]);
    xlim([xmin xmax]);
    ylim([ymin ymax]);   
    title('Select ROI to Delete, and Double Click the ROI'); 
    h = imrect;
    position = wait(h);
    pos = getPosition(h);
    xmin=pos(1); xmax=pos(1)+pos(3);
    ymin=pos(2); ymax=pos(2)+pos(4);
    index=find(XYZt(:,1)>xmin & XYZt(:,1)<xmax &...
               XYZt(:,2)>ymin & XYZt(:,2)<ymax);
    XYZtDel=[XYZtDel;XYZt(index,:)];
    XYZt(index,:)=[];
    deletenumber=length(index);
    strg=['*** ' num2str(deletenumber) ' *** Dots has been deleted.' ];
    disp(strg);    
    disp('--');
    disp('Do You Want to Select Another ROI? -y- for Continue, -n- Quit - ');
    judge='';
    close all
    while isempty(judge)
        judge = input('Press y or n. - ', 's');
    end
    if judge=='y'
        close all
    end
end
%%
close all
figure1 = figure('Color',...
    [0.313725501298904 0.313725501298904 0.313725501298904]);
    axes1 = axes('Parent',figure1,'YDir','reverse');
    box(axes1,'on');
    hold(axes1,'all');
    plot(XYZt(:,1),XYZt(:,2),...
        'MarkerFaceColor',[1 0 0],'MarkerEdgeColor',[1 0 0],...
        'MarkerSize',2,...
        'Marker','.',...
        'LineStyle','none',...
        'Color',[1 1 1]);
    axis equal
    xlim([XminDisp XmaxDisp]);
    ylim([YminDisp YmaxDisp]);
    whitebg([0 0 0]);
%%
outfile = [Afname(1:end-4)];
outfilename = [outfile '-DelP1.dat'];
save(outfilename, 'XYZt', '-ascii', '-tabs');
figurefilename1_1 = strcat(outfile, '-DelP1.fig'); 
figurefilename1_2 = strcat(outfile, '-DelP1.bmp'); 
saveas(gcf,figurefilename1_1,'fig');
saveas(gcf,figurefilename1_2,'bmp');

%%
figure2 = figure('Color',...
    [0.313725501298904 0.313725501298904 0.313725501298904]);
    axes2 = axes('Parent',figure2,'YDir','reverse');
    box(axes2,'on');
    hold(axes2,'all');
    plot(XYZtDel(:,1),XYZtDel(:,2),...
        'MarkerFaceColor',[1 0 0],'MarkerEdgeColor',[1 0 0],...
        'MarkerSize',2,...
        'Marker','.',...
        'LineStyle','none',...
        'Color',[1 1 1]);
    axis equal
    xlim([XminDisp XmaxDisp]);
    ylim([YminDisp YmaxDisp]);
    whitebg([0 0 0]);
outfile = [Afname(1:end-4)];
outfilename = [outfile '-DelP2.dat'];
save(outfilename, 'XYZtDel', '-ascii', '-tabs');
figurefilename2_1 = strcat(outfile, '-DelP2.fig'); 
figurefilename2_2 = strcat(outfile, '-DelP2.bmp'); 
saveas(gcf,figurefilename2_1,'fig');
saveas(gcf,figurefilename2_2,'bmp');
end