#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")


library(limma)           #ð
expFile="symbol.txt"     #ļ
geneFile="gene.txt"      #бļ
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L7")     #ùĿ¼

#ȡļݽд
rt=read.table(expFile, header=T, sep="\t", check.names=F)
rt=as.matrix(rt)
rownames(rt)=rt[,1]
exp=rt[,2:ncol(rt)]
dimnames=list(rownames(exp), colnames(exp))
data=matrix(as.numeric(as.matrix(exp)), nrow=nrow(exp), dimnames=dimnames)
data=avereps(data)
data=data[rowMeans(data)>0,]

#ȡбļ, ȡԭϸı
gene=read.table(geneFile, header=F, sep="\t", check.names=F)
sameGene=intersect(as.vector(gene[,1]), rownames(data))
geneExp=data[sameGene,]

#ԭϸı
out=rbind(ID=colnames(geneExp), geneExp)
write.table(out, file="ICDexp.txt", sep="\t", quote=F, col.names=F)

#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")

#install.packages("pheatmap")


#ð
library(limma)
library(pheatmap)

expFile="ICDexp.txt"      #ļ
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L12")      #ùĿ¼

#ȡļ
rt=read.table(expFile, header=T, sep="\t", check.names=F)
rt=as.matrix(rt)
rownames(rt)=rt[,1]
exp=rt[,2:ncol(rt)]
dimnames=list(rownames(exp), colnames(exp))
data=matrix(as.numeric(as.matrix(exp)), nrow=nrow(exp), dimnames=dimnames)
data=avereps(data)

#Ŀ
group=sapply(strsplit(colnames(data),"\\-"), "[", 4)
group=sapply(strsplit(group,""), "[", 1)
group=gsub("2", "1", group)
conNum=length(group[group==1])       #ƷĿ
treatNum=length(group[group==0])     #ƷĿ
sampleType=c(rep(1,conNum), rep(2,treatNum))

#
sigVec=c()
outTab=data.frame()
for(i in rownames(data)){
	if(sd(data[i,])<0.001){next}
	wilcoxTest=wilcox.test(data[i,] ~ sampleType)
	pvalue=wilcoxTest$p.value
	if(pvalue<0.05){
		Sig=ifelse(pvalue<0.001,"***",ifelse(pvalue<0.01,"**",ifelse(pvalue<0.05,"*","")))
		sigVec=c(sigVec, paste0(i, Sig))
		conGeneMeans=mean(data[i,1:conNum])
		treatGeneMeans=mean(data[i,(conNum+1):ncol(data)])
		logFC=log2(treatGeneMeans)-log2(conGeneMeans)
		outTab=rbind(outTab,cbind(gene=i,conMean=conGeneMeans,treatMean=treatGeneMeans,logFC=logFC,pValue=pvalue))
	}
}
#Ľ
write.table(outTab, file="diff.xls", sep="\t", row.names=F, quote=F)
write.table(outTab, file="diff.txt", sep="\t", row.names=F, quote=F)

#ıļ
exp=data[as.vector(outTab[,1]),]
expOut=rbind(ID=colnames(exp), exp)
write.table(expOut, file="diffGeneExp.txt", sep="\t", col.names=F, quote=F)

#Ʋͼ
exp=log2(exp+0.1)
row.names(exp)=sigVec
Type=c(rep("Normal",conNum),rep("Tumor",treatNum))
names(Type)=colnames(data)
Type=as.data.frame(Type)
pdf(file="heatmap.pdf", width=9, height=6)
pheatmap(exp, 
         annotation=Type, 
         color = colorRampPalette(c(rep("blue",5), "white", rep("red",5)))(50),
         cluster_cols =F,
         cluster_rows =T,
         scale="row",
         show_colnames = F,
         show_rownames = T,
         fontsize = 8,
         fontsize_row=8,
         fontsize_col=8)
dev.off()

#install.packages("survival")

#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")

#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("ConsensusClusterPlus")


#ð
library(limma)
library(survival)
library(ConsensusClusterPlus)

expFile="ICDexp.txt"      #ļ
cliFile="time.txt"        #ļ
workDir="C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L14"      #ùĿ¼
setwd(workDir)

#ȡļ
data=read.table(expFile, header=T, sep="\t", check.names=F, row.names=1)

#ɾƷ
group=sapply(strsplit(colnames(data),"\\-"), "[", 4)
group=sapply(strsplit(group,""), "[", 1)
group=gsub("2", "1", group)
data=data[,group==0]
data=t(data)
rownames(data)=gsub("(.*?)\\-(.*?)\\-(.*?)\\-.*", "\\1\\-\\2\\-\\3", rownames(data))
data=avereps(data)
data=log2(data+1)

#ȡ
cli=read.table(cliFile, header=T, sep="\t", check.names=F, row.names=1)

#ݺϲ
sameSample=intersect(row.names(data),row.names(cli))
data=data[sameSample,]
cli=cli[sameSample,]
rt=cbind(cli,data)

#COX
sigGenes=c()
for(i in colnames(rt)[3:ncol(rt)]){
	cox=coxph(Surv(futime, fustat) ~ rt[,i], data = rt)
	coxSummary=summary(cox)
	coxP=coxSummary$coefficients[,"Pr(>|z|)"]
	if(coxP<0.05){ sigGenes=c(sigGenes,i) }
}

#ICDƷз
maxK=9    #kֵ(ԽƷֳɼ)
data=t(data[,sigGenes])
results=ConsensusClusterPlus(data,
              maxK=maxK,
              reps=50,
              pItem=0.8,
              pFeature=1,
              title=workDir,
              clusterAlg="km",
              distance="euclidean",
              seed=123456,
              plot="png")

#ͽ
clusterNum=2     #Ʒֳɼ
Cluster=results[[clusterNum]][["consensusClass"]]
Cluster=as.data.frame(Cluster)
Cluster[,1]=paste0("C", Cluster[,1])
ClusterOut=rbind(ID=colnames(Cluster), Cluster)
write.table(ClusterOut, file="cluster.txt", sep="\t", quote=F, col.names=F)

#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")

#install.packages("pheatmap")


#ð
library(limma)
library(pheatmap)

expFile="ICDexp.txt"          #ļ
ClusterFile="cluster.txt"     #͵Ľļ
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L15")     #ùĿ¼

#ȡļ
data=read.table(expFile, header=T, sep="\t", check.names=F, row.names=1)

#ȥƷ
group=sapply(strsplit(colnames(data),"\\-"), "[", 4)
group=sapply(strsplit(group,""), "[", 1)
group=gsub("2", "1", group)
data=data[,group==0]
data=t(data)
rownames(data)=gsub("(.*?)\\-(.*?)\\-(.*?)\\-.*", "\\1\\-\\2\\-\\3", rownames(data))
data=avereps(data)
data=log2(data+1)

#ȡ͵Ľļ
Cluster=read.table(ClusterFile, header=T, sep="\t", check.names=F, row.names=1)
Type=Cluster[order(Cluster$Cluster),,drop=F]
exp=t(data[row.names(Type),])

#ͼע͵ɫ
ann_colors=list()
bioCol=c("green", "red")
names(bioCol)=c("C1", "C2")
ann_colors[["Cluster"]]=bioCol

#ͼ
pdf(file="heatmap.pdf", width=7, height=5.5)
pheatmap(exp,
         annotation=Type,
         annotation_colors=ann_colors,
         color = colorRampPalette(c(rep("blue",5), "white", rep("red",5)))(100),
         cluster_cols =F,
         cluster_rows =T,
         scale="row",
         show_colnames=F,
         show_rownames=T,
         fontsize=8,
         fontsize_row=8,
         fontsize_col=8)
dev.off()

#Ʒз
median1=median(exp[,Type$Cluster=="C1"])     #ȡ1λֵ
median2=median(exp[,Type$Cluster=="C2"])     #ȡ2λֵ
if(median1>median2){
	Type$Group=ifelse(Type$Cluster=="C1", "ICD high", "ICD low")
}else{
	Type$Group=ifelse(Type$Cluster=="C1", "ICD low", "ICD high")
}
#Ľ
Type=rbind(ID=colnames(Type), Type)
write.table(Type, file="ICDgroup.txt", sep="\t", quote=F, col.names=F)

#ð
library(survival)
library(survminer)

GroupFile="ICDgroup.txt"     #Ľļ
cliFile="time.txt"           #ļ
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L16")      #ùĿ¼

#ȡļ
Group=read.table(GroupFile, header=T, sep="\t", check.names=F, row.names=1)
cli=read.table(cliFile, header=T, sep="\t", check.names=F, row.names=1)
colnames(cli)=c("futime", "fustat")
cli$futime=cli$futime/365

#ݺϲ
sameSample=intersect(row.names(Group), row.names(cli))
rt=cbind(cli[sameSample,,drop=F], Group[sameSample,,drop=F])
rt[,"Group"]=factor(rt[,"Group"], levels=c("ICD low","ICD high"))

#ȽICDߵͱ
length=length(levels(factor(rt$Group)))
diff=survdiff(Surv(futime, fustat) ~ Group, data = rt)
pValue=1-pchisq(diff$chisq, df=length-1)
if(pValue<0.001){
	pValue="p<0.001"
}else{
	pValue=paste0("p=",sprintf("%.03f",pValue))
}
fit <- survfit(Surv(futime, fustat) ~ Group, data = rt)
#print(surv_median(fit))

#
bioCol=c("#0066FF","#FF0000","#FF9900","#6E568C","#7CC767","#223D6C","#D20A13","#FFD121","#088247","#11AA4D")
bioCol=bioCol[1:length]
surPlot=ggsurvplot(fit, 
		           data=rt,
		           conf.int=F,
		           pval=pValue,
		           pval.size=6,
		           legend.title="Group",
		           legend.labs=levels(factor(rt[,"Group"])),
		           legend = c(0.8, 0.8),
		           font.legend=10,
		           xlab="Time(years)",
		           break.time.by=2,
		           palette=bioCol,
		           surv.median.line="hv",
		           risk.table=T,
		           cumevents=F,
		           risk.table.height=.25)

#ͼ
pdf(file="survival.pdf", width=6.5, height=5, onefile=FALSE)
print(surPlot)
dev.off()

#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")

#install.packages("ggplot2")
#install.packages("pheatmap")


#ð
library(limma)
library(ggplot2)
library(pheatmap)

conGroup="ICD low"         #
treatGroup="ICD high"      #ʵ
expFile="symbol.txt"       #ļ
cluFile="ICDgroup.txt"     #Ľļ
logFCfilter=1              #logFC(logFC=0.585,챶1.5;logFC=1,2;logFC=2,4)
fdrFilter=0.05             #fdr
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L17")     #ùĿ¼

#ȡļ,ļ
rt=read.table(expFile, header=T, sep="\t", check.names=F)
rt=as.matrix(rt)
rownames(rt)=rt[,1]
exp=rt[,2:ncol(rt)]
dimnames=list(rownames(exp), colnames(exp))
data=matrix(as.numeric(as.matrix(exp)), nrow=nrow(exp), dimnames=dimnames)
data=avereps(data)

#ȥƷ
group=sapply(strsplit(colnames(data),"\\-"), "[", 4)
group=sapply(strsplit(group,""), "[", 1)
group=gsub("2", "1", group)
data=data[,group==0]
colnames(data)=gsub("(.*?)\\-(.*?)\\-(.*?)\\-.*", "\\1\\-\\2\\-\\3", colnames(data))

#ȡĽļ
Type=read.table(cluFile, header=T, sep="\t", check.names=F, row.names=1)
sameSample=intersect(colnames(data), row.names(Type))
data=data[,sameSample,drop=F]
Type=Type[sameSample,,drop=F]

#ȡͬƷ
low=Type[Type$Group==conGroup,,drop=F]          #ȡICDͱƷ
high=Type[Type$Group==treatGroup,,drop=F]       #ȡICD߱Ʒ
dataLow=data[,row.names(low)]
dataHigh=data[,row.names(high)]
data=cbind(dataLow, dataHigh)
data=data[rowMeans(data)>0.1,]
conNum=ncol(dataLow)
treatNum=ncol(dataHigh)
Type=c(rep(1,conNum), rep(2,treatNum))

#
outTab=data.frame()
for(i in row.names(data)){
	rt=data.frame(expression=data[i,], Type=Type)
	wilcoxTest=wilcox.test(expression ~ Type, data=rt)
	pvalue=wilcoxTest$p.value
	conGeneMeans=mean(data[i,1:conNum])
	treatGeneMeans=mean(data[i,(conNum+1):ncol(data)])
	logFC=log2(treatGeneMeans)-log2(conGeneMeans)
	conMed=median(data[i,1:conNum])
	treatMed=median(data[i,(conNum+1):ncol(data)])
	diffMed=treatMed-conMed
	if( ((logFC>0) & (diffMed>0)) | ((logFC<0) & (diffMed<0)) ){  
		outTab=rbind(outTab,cbind(gene=i,lowMean=conGeneMeans,highMean=treatGeneMeans,logFC=logFC,pvalue=pvalue))
	}
}
pvalue=outTab[,"pvalue"]
fdr=p.adjust(as.numeric(as.vector(pvalue)), method="fdr")
outTab=cbind(outTab, fdr=fdr)
write.table(outTab, file="all.txt", sep="\t", row.names=F, quote=F)

#Ľ
outDiff=outTab[( abs(as.numeric(as.vector(outTab$logFC)))>logFCfilter & as.numeric(as.vector(outTab$fdr))<fdrFilter),]
write.table(outDiff, file="diff.txt", sep="\t", row.names=F, quote=F)

#ı
diffExp=rbind(ID=colnames(data[as.vector(outDiff[,1]),]), data[as.vector(outDiff[,1]),])
write.table(diffExp, file="diffGeneExp.txt", sep="\t", col.names=F, quote=F)

#Ʋͼ
geneNum=50    #չʾĿ
outDiff=outDiff[order(as.numeric(as.vector(outDiff$logFC))),]
diffGeneName=as.vector(outDiff[,1])
diffLength=length(diffGeneName)
hmGene=c()
if(diffLength>(2*geneNum)){
    hmGene=diffGeneName[c(1:geneNum,(diffLength-geneNum+1):diffLength)]
}else{
    hmGene=diffGeneName
}
hmExp=log2(data[hmGene,]+0.01)
Type=c(rep(conGroup,conNum),rep(treatGroup,treatNum))
Type=factor(Type, levels=c(conGroup, treatGroup))
names(Type)=colnames(data)
Type=as.data.frame(Type)
pdf(file="heatmap.pdf", width=10, height=7)
pheatmap(hmExp, 
         annotation=Type, 
         color = colorRampPalette(c(rep("blue",5), "white", rep("red",5)))(50),
         cluster_cols =F,
         show_colnames = F,
         scale="row",
         fontsize = 8,
         fontsize_row=5,
         fontsize_col=8)
dev.off()

#ƲĻɽͼ
pdf(file="vol.pdf", width=5, height=5)
xMax=5
yMax=30
plot(as.numeric(as.vector(outTab$logFC)), -log10(outTab$fdr), xlab="logFC",ylab="-log10(fdr)",
     main="Volcano", ylim=c(0,yMax),xlim=c(-xMax,xMax),yaxs="i",pch=20, cex=1)
diffSub=subset(outTab, fdr<fdrFilter & as.numeric(as.vector(logFC))>logFCfilter)
points(as.numeric(as.vector(diffSub$logFC)), -log10(diffSub$fdr), pch=20, col="red",cex=1)
diffSub=subset(outTab, fdr<fdrFilter & as.numeric(as.vector(logFC))<(-logFCfilter))
points(as.numeric(as.vector(diffSub$logFC)), -log10(diffSub$fdr), pch=20, col="green",cex=1)
abline(v=0,lty=2,lwd=3)
dev.off()

#install.packages("colorspace")
#install.packages("stringi")
#install.packages("ggplot2")
#install.packages("circlize")
#install.packages("RColorBrewer")
#install.packages("ggpubr")

#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("org.Hs.eg.db")
#BiocManager::install("DOSE")
#BiocManager::install("clusterProfiler")
#BiocManager::install("enrichplot")
#BiocManager::install("ComplexHeatmap")


#ð
library(clusterProfiler)
library(org.Hs.eg.db)
library(enrichplot)
library(ggplot2)
library(circlize)
library(RColorBrewer)
library(dplyr)
library("ggpubr")
library(ComplexHeatmap)

pvalueFilter=0.05      #pֵ
qvalueFilter=0.05      #pֵ

#ɫ
colorSel="qvalue"
if(qvalueFilter>0.05){
	colorSel="pvalue"
}

setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L18")       #ùĿ¼
rt=read.table("diff.txt", header=T, sep="\t", check.names=F)     #ȡļ

#ȡ, תΪid
genes=unique(as.vector(rt[,1]))
entrezIDs=mget(genes, org.Hs.egSYMBOL2EG, ifnotfound=NA)
entrezIDs=as.character(entrezIDs)
gene=entrezIDs[entrezIDs!="NA"]        #ȥidΪNAĻ
gene=gsub("c\\(\"(\\d+)\".*", "\\1", gene)

#GO
kk=enrichGO(gene=gene, OrgDb=org.Hs.eg.db, pvalueCutoff=1, qvalueCutoff=1, ont="all", readable=T)
GO=as.data.frame(kk)
GO=GO[(GO$pvalue<pvalueFilter & GO$qvalue<qvalueFilter),]
#渻
write.table(GO, file="GO.txt", sep="\t", quote=F, row.names = F)

#ʾGOĿ
showNum=10
if(nrow(GO)<30){
	showNum=nrow(GO)
}

#״ͼ
pdf(file="barplot.pdf", width=14, height=7)
bar=barplot(kk, drop=TRUE, showCategory=showNum, label_format=130, split="ONTOLOGY", color=colorSel) + facet_grid(ONTOLOGY~., scale='free')
print(bar)
dev.off()
		
#ͼ
pdf(file="bubble.pdf", width=14, height=7)
bub=dotplot(kk, showCategory=showNum, orderBy="GeneRatio", label_format=130, split="ONTOLOGY", color=colorSel) + facet_grid(ONTOLOGY~., scale='free')
print(bub)
dev.off()

###########GOȦͼ###########
ontology.col=c("#00AFBB", "#E7B800", "#90EE90")
data=GO[order(GO$p.adjust),]
datasig=data[data$p.adjust<0.05,,drop=F]
BP = datasig[datasig$ONTOLOGY=="BP",,drop=F]
CC = datasig[datasig$ONTOLOGY=="CC",,drop=F]
MF = datasig[datasig$ONTOLOGY=="MF",,drop=F]
BP = head(BP,6)
CC = head(CC,6)
MF = head(MF,6)
data = rbind(BP,CC,MF)
main.col = ontology.col[as.numeric(as.factor(data$ONTOLOGY))]

#Ȧͼ
BgGene = as.numeric(sapply(strsplit(data$BgRatio,"/"),'[',1))
Gene = as.numeric(sapply(strsplit(data$GeneRatio,'/'),'[',1))
ratio = Gene/BgGene
logpvalue = -log(data$pvalue,10)
logpvalue.col = brewer.pal(n = 8, name = "Reds")
f = colorRamp2(breaks = c(0,2,4,6,8,10,15,20), colors = logpvalue.col)
BgGene.col = f(logpvalue)
df = data.frame(GO=data$ID,start=1,end=max(BgGene))
rownames(df) = df$GO
bed2 = data.frame(GO=data$ID,start=1,end=BgGene,BgGene=BgGene,BgGene.col=BgGene.col)
bed3 = data.frame(GO=data$ID,start=1,end=Gene,BgGene=Gene)
bed4 = data.frame(GO=data$ID,start=1,end=max(BgGene),ratio=ratio,col=main.col)
bed4$ratio = bed4$ratio/max(bed4$ratio)*9.5

#Ȧͼ岿
pdf("GO.circlize.pdf",width=10,height=10)
par(omi=c(0.1,0.1,0.1,1.5))
circos.par(track.margin=c(0.01,0.01))
circos.genomicInitialize(df,plotType="none")
circos.trackPlotRegion(ylim = c(0, 1), panel.fun = function(x, y) {
  sector.index = get.cell.meta.data("sector.index")
  xlim = get.cell.meta.data("xlim")
  ylim = get.cell.meta.data("ylim")
  circos.text(mean(xlim), mean(ylim), sector.index, cex = 0.8, facing = "bending.inside", niceFacing = TRUE)
}, track.height = 0.08, bg.border = NA,bg.col = main.col)

for(si in get.all.sector.index()) {
  circos.axis(h = "top", labels.cex = 0.6, sector.index = si,track.index = 1,
              major.at=seq(0,max(BgGene),by=100),labels.facing = "clockwise")
}
f = colorRamp2(breaks = c(-1, 0, 1), colors = c("green", "black", "red"))
circos.genomicTrack(bed2, ylim = c(0, 1),track.height = 0.1,bg.border="white",
                    panel.fun = function(region, value, ...) {
                      i = getI(...)
                      circos.genomicRect(region, value, ytop = 0, ybottom = 1, col = value[,2], 
                                         border = NA, ...)
                      circos.genomicText(region, value, y = 0.4, labels = value[,1], adj=0,cex=0.8,...)
                    })
circos.genomicTrack(bed3, ylim = c(0, 1),track.height = 0.1,bg.border="white",
                    panel.fun = function(region, value, ...) {
                      i = getI(...)
                      circos.genomicRect(region, value, ytop = 0, ybottom = 1, col = '#BA55D3', 
                                         border = NA, ...)
                      circos.genomicText(region, value, y = 0.4, labels = value[,1], cex=0.9,adj=0,...)
                    })
circos.genomicTrack(bed4, ylim = c(0, 10),track.height = 0.35,bg.border="white",bg.col="grey90",
                    panel.fun = function(region, value, ...) {
                      cell.xlim = get.cell.meta.data("cell.xlim")
                      cell.ylim = get.cell.meta.data("cell.ylim")
                      for(j in 1:9) {
                        y = cell.ylim[1] + (cell.ylim[2]-cell.ylim[1])/10*j
                        circos.lines(cell.xlim, c(y, y), col = "#FFFFFF", lwd = 0.3)
                      }
                      circos.genomicRect(region, value, ytop = 0, ybottom = value[,1], col = value[,2], 
                                         border = NA, ...)
                      #circos.genomicText(region, value, y = 0.3, labels = value[,1], ...)
                    })
circos.clear()
#Ȧͼмͼ
middle.legend = Legend(
  labels = c('Number of Genes','Number of Select','Rich Factor(0-1)'),
  type="points",pch=c(15,15,17),legend_gp = gpar(col=c('pink','#BA55D3',ontology.col[1])),
  title="",nrow=3,size= unit(3, "mm")
)
circle_size = unit(1, "snpc")
draw(middle.legend,x=circle_size*0.42)
#GOͼ
main.legend = Legend(
  labels = c("Biological Process","Cellular Component", "Molecular Function"),  type="points",pch=15,
  legend_gp = gpar(col=ontology.col), title_position = "topcenter",
  title = "ONTOLOGY", nrow = 3,size = unit(3, "mm"),grid_height = unit(5, "mm"),
  grid_width = unit(5, "mm")
)
#pvalueͼ
logp.legend = Legend(
  labels=c('(0,2]','(2,4]','(4,6]','(6,8]','(8,10]','(10,15]','(15,20]','>=20'),
  type="points",pch=16,legend_gp=gpar(col=logpvalue.col),title="-log10(Pvalue)",
  title_position = "topcenter",grid_height = unit(5, "mm"),grid_width = unit(5, "mm"),
  size = unit(3, "mm")
)
lgd = packLegend(main.legend,logp.legend)
circle_size = unit(1, "snpc")
print(circle_size)
draw(lgd, x = circle_size*0.85, y=circle_size*0.55,just = "left")
dev.off()

#install.packages("colorspace")
#install.packages("stringi")
#install.packages("ggplot2")
#install.packages("circlize")
#install.packages("RColorBrewer")

#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("org.Hs.eg.db")
#BiocManager::install("DOSE")
#BiocManager::install("clusterProfiler")
#BiocManager::install("enrichplot")
#BiocManager::install("ComplexHeatmap")


#ð
library(clusterProfiler)
library(org.Hs.eg.db)
library(enrichplot)
library(ggplot2)
library(circlize)
library(RColorBrewer)
library(dplyr)
library(ComplexHeatmap)

pvalueFilter=0.05      #pֵ
qvalueFilter=0.05      #pֵ

#ɫ
colorSel="qvalue"
if(qvalueFilter>0.05){
	colorSel="pvalue"
}
	
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L19")      #ùĿ¼
rt=read.table("diff.txt", header=T, sep="\t", check.names=F)     #ȡļ

#ȡ,תΪid
genes=unique(as.vector(rt[,1]))
entrezIDs=mget(genes, org.Hs.egSYMBOL2EG, ifnotfound=NA)
entrezIDs=as.character(entrezIDs)
rt=data.frame(genes, entrezID=entrezIDs)
gene=entrezIDs[entrezIDs!="NA"]        #ȥidΪNAĻ
#gene=gsub("c\\(\"(\\d+)\".*", "\\1", gene)

#KEGG
kk <- enrichKEGG(gene=gene, organism="hsa", pvalueCutoff=1, qvalueCutoff=1)
KEGG=as.data.frame(kk)
KEGG$geneID=as.character(sapply(KEGG$geneID,function(x)paste(rt$genes[match(strsplit(x,"/")[[1]],as.character(rt$entrezID))],collapse="/")))
KEGG=KEGG[(KEGG$pvalue<pvalueFilter & KEGG$qvalue<qvalueFilter),]
#Ľ
write.table(KEGG, file="KEGG.txt", sep="\t", quote=F, row.names = F)

#ʾͨ·Ŀ
showNum=30     #չʾǰ30ͨ·
if(nrow(KEGG)<showNum){
	showNum=nrow(KEGG)
}

#״ͼ
pdf(file="barplot.pdf", width=9, height=7)
barplot(kk, drop=TRUE, showCategory=showNum, label_format=130, color=colorSel)
dev.off()

#ͼ
pdf(file="bubble.pdf", width = 9, height = 7)
dotplot(kk, showCategory=showNum, orderBy="GeneRatio", label_format=130, color=colorSel)
dev.off()

#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")
#BiocManager::install("org.Hs.eg.db")
#BiocManager::install("DOSE")
#BiocManager::install("clusterProfiler")
#BiocManager::install("enrichplot")


#ð
library(limma)
library(org.Hs.eg.db)
library(clusterProfiler)
library(enrichplot)

allFile="all.txt"      #лĲļ
gmtFile="c2.cp.kegg.symbols.gmt"      #ļ
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L20")     #ùĿ¼

#ȡļ,ļ
rt=read.table(allFile, header=T, sep="\t", check.names=F)
rt=rt[order(rt[,"logFC"],decreasing=T),]
logFC=as.vector(rt[,"logFC"])
names(logFC)=as.vector(rt[,1])

#ļ
gmt=read.gmt(gmtFile)

#õĻGSEA
kk=GSEA(logFC, TERM2GENE=gmt, pvalueCutoff = 1)
kkTab=as.data.frame(kk)
kkTab=kkTab[kkTab$p.adjust<0.05,]
write.table(kkTab,file="GSEA.result.txt",sep="\t",quote=F,row.names = F)

#ICD߱鸻ͼ
kkUp=kkTab[kkTab$NES>0,]
termNum=5     #չʾͨ·Ŀչʾǰ5ͨ·
if(nrow(kkUp)>=termNum){
	showTerm=row.names(kkUp)[1:termNum]      #ȡչʾͨ·
	gseaplot=gseaplot2(kk, showTerm, base_size=8, title="Enriched in ICD high group")
	pdf(file="GSEA.highrisk.pdf", width=7, height=5.5)
	print(gseaplot)
	dev.off()
}

#ICDͱ鸻ͼ
kkDown=kkTab[kkTab$NES<0,]
termNum=5     #չʾͨ·Ŀչʾǰ5ͨ·
if(nrow(kkDown)>=termNum){
	showTerm=row.names(kkDown)[1:termNum]      #ȡչʾͨ·
	gseaplot=gseaplot2(kk, showTerm, base_size=8, title="Enriched in ICD low group")
	pdf(file="GSEA.lowrisk.pdf", width=7, height=5.5)
	print(gseaplot)
	dev.off()
}


#if (!require("BiocManager"))
#    install.packages("BiocManager")
#BiocManager::install("maftools")


library(maftools)       #ð
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L22")      #ùĿ¼

#ȡĽļ, õעļ
group=read.table("ICDgroup.txt", header=T, sep="\t", check.names=F)
outTab=group[,c(1, ncol(group))]
colnames(outTab)=c("Tumor_Sample_Barcode", "Group")
write.table(outTab, file="ann.txt", sep="\t", quote=F, row.names=F)

#ȡͻļѡȡͻƵߵ20пӻ
geneNum=20      #ûĿ
geneMut=read.table("geneMut.txt", header=T, sep="\t", check.names=F, row.names=1)
gene=row.names(geneMut)[1:geneNum]

#ע͵ɫ
ann_colors=list()
col=c("#0066FF","#FF0000")
names(col)=c("ICD low", "ICD high")
ann_colors[["Group"]]=col

#Ƶͱٲͼ
pdf(file="low.pdf", width=6, height=6)
maf=read.maf(maf="low.maf", clinicalData="ann.txt")    #ȡͱͻļ
oncoplot(maf=maf, clinicalFeatures="Group", genes=gene, annotationColor=ann_colors, keepGeneOrder=T)
dev.off()

#Ƹ߱ٲͼ
pdf(file="high.pdf", width=6, height=6)
maf=read.maf(maf="high.maf", clinicalData="ann.txt")    #ȡ߱ͻļ
oncoplot(maf=maf, clinicalFeatures="Group", genes=gene, annotationColor=ann_colors, keepGeneOrder=T)
dev.off()

#library(utils)
#rforge <- "http://r-forge.r-project.org"
#install.packages("estimate", repos=rforge, dependencies=TRUE)

#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")


#ð
library(limma)
library(estimate)

inputFile="symbol.txt"       #ļ
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L23")      #ùĿ¼

#ȡļ,ļ
rt=read.table(inputFile, header=T, sep="\t", check.names=F)
rt=as.matrix(rt)
rownames(rt)=rt[,1]
exp=rt[,2:ncol(rt)]
dimnames=list(rownames(exp),colnames(exp))
data=matrix(as.numeric(as.matrix(exp)),nrow=nrow(exp),dimnames=dimnames)
data=avereps(data)

#ɾƷ
group=sapply(strsplit(colnames(data),"\\-"), "[", 4)
group=sapply(strsplit(group,""), "[", 1)
group=gsub("2", "1", group)
data=data[,group==0]
data=t(data)
rownames(data)=gsub("(.*?)\\-(.*?)\\-(.*?)\\-(.*?)\\-.*", "\\1\\-\\2\\-\\3", rownames(data))
data=avereps(data)
data=t(data)

#õı
out=rbind(ID=colnames(data),data)
write.table(out,file="uniq.symbol.txt",sep="\t",quote=F,col.names=F)

#estimate
filterCommonGenes(input.f="uniq.symbol.txt", 
                  output.f="commonGenes.gct", 
                  id="GeneSymbol")

estimateScore(input.ds = "commonGenes.gct",
              output.ds="estimateScore.gct")

#ÿƷĴ
scores=read.table("estimateScore.gct", header=T, skip=2)
rownames(scores)=scores[,1]
scores=t(scores[,3:ncol(scores)])
rownames(scores)=gsub("\\.", "\\-", rownames(scores))
out=rbind(ID=colnames(scores), scores)
write.table(out, file="TMEscores.txt", sep="\t", quote=F, col.names=F)


#install.packages("ggpubr")


library(ggpubr)      #ð
groupFile="ICDgroup.txt"       #Ľļ
socreFile="TMEscores.txt"      #΢ļ
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L24")      #ùĿ¼

#ȡĽ
Group=read.table(groupFile, header=T, sep="\t", check.names=F, row.names=1)

#ȡ΢ļ
score=read.table(socreFile, header=T, sep="\t", check.names=F, row.names=1)

#ݺϲ
sameSample=intersect(row.names(Group), row.names(score))
data=cbind(score[sameSample,,drop=F], Group[sameSample,"Group",drop=F])
data[,"Group"]=factor(data[,"Group"], levels=c("ICD low","ICD high"))

#ñȽ
group=levels(factor(data$Group))
comp=combn(group,2)
my_comparisons=list()
for(i in 1:ncol(comp)){my_comparisons[[i]]<-comp[,i]}

#Сͼ
bioCol=c("#0066FF","#FF0000","#FF9900","#6E568C","#7CC767","#223D6C","#D20A13","#FFD121","#088247","#11AA4D")
bioCol=bioCol[1:length(group)]
for(i in colnames(data)[1:(ncol(data)-1)]){
	violin=ggviolin(data, x="Group", y=i, fill = "Group",
	         xlab="Group", ylab=i,
	         legend.title="Group",
	         palette=bioCol, 
	         add="boxplot", add.params = list(fill="white"))+ 
		stat_compare_means(comparisons = my_comparisons,symnum.args=list(cutpoints = c(0, 0.001, 0.01, 0.05, 1), symbols = c("***", "**", "*", "ns")),label = "p.signif")
	pdf(file=paste0("vioplot.", i, ".pdf"), width=6, height=5.5)
	print(violin)
	dev.off()
}

#install.packages('e1071')

#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("preprocessCore")

#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")


library("limma")           #ð
inputFile="symbol.txt"     #ļ
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L25")      #ùĿ¼

#ȡļļ
rt=read.table(inputFile, header=T, sep="\t", check.names=F)        #ȡļ
rt=as.matrix(rt)
rownames(rt)=rt[,1]
exp=rt[,2:ncol(rt)]
dimnames=list(rownames(exp),colnames(exp))
data=matrix(as.numeric(as.matrix(exp)),nrow=nrow(exp),dimnames=dimnames)
data=avereps(data)
data=data[rowMeans(data)>0,]

#õ
out=rbind(ID=colnames(data),data)
write.table(out,file="uniq.symbol.txt",sep="\t",quote=F,col.names=F)

#CIBERSORTõϸĽ
source("ICD25.CIBERSORT.R")
results=CIBERSORT("ref.txt", "uniq.symbol.txt", perm=1000)

#install.packages("pheatmap")
#install.packages("corrplot")


#ð
library(pheatmap)
library(corrplot)

pFilter=0.05       #ϸ
immFile="CIBERSORT-Results.txt"      #ϸļ
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L26")     #ùĿ¼

#ȡ߽ļݽ
immune=read.table(immFile, header=T, sep="\t", check.names=F, row.names=1)
immune=immune[immune[,"P-value"]<pFilter,]
data=as.matrix(immune[,1:(ncol(immune)-3)])

#ȡƷƷ
group=sapply(strsplit(row.names(data),"\\-"), "[", 4)
group=sapply(strsplit(group,""), "[", 1)
group=gsub("2", "1", group)
normalData=data[group==1,]     #Ʒ
tumorData=data[group==0,]      #Ʒ

#״ͼ
data=t(tumorData)
col=rainbow(nrow(data), s=0.7, v=0.7)
pdf(file="barplot.pdf", width=15, height=8)
par(las=1,mar=c(6,5,2,15), mgp=c(3,0.1,0), cex.axis=1.5)
a1 = barplot(data,col=col,xaxt="n",yaxt="n",ylab="Relative Percent",cex.lab=1.8)
a2=axis(2,tick=F,labels=F)
axis(2,a2,paste0(a2*100,"%"))
axis(1,a1,labels=F)
par(srt=60,xpd=T);text(a1,-0.02,colnames(data),adj=1,cex=0.35);par(srt=0)
legend(par('usr')[2]*0.98,par('usr')[4],legend=rownames(data),col=col,pch=15,bty="n",cex=1.2)
dev.off()

#ͼ
pdf(file="corHeatmap.pdf", width=11, height=11)
par(oma=c(0.5,1,1,1.2))
tumorData=tumorData[,colMeans(tumorData)>0]
M=cor(tumorData)
corrplot(M,
         order="hclust",          #ϸʽ
         method = "color",        #ͼչʾʽ
         diag = TRUE,             #ǷչʾԽ
         tl.col="black",          #ɫ
         addCoef.col = "black",   #ϵɫ
         number.cex=0.75,         #ϵС
         col=colorRampPalette(c("blue", "white", "red"))(50))    #ͼεɫ,غɫɫ
dev.off()

#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")

#install.packages("vioplot")


#ð
library(limma)
library(vioplot)

pFilter=0.05      #ϸĹ
immuneFile="CIBERSORT-Results.txt"      #ϸĽļ
cluFile="ICDgroup.txt"                  #Ľļ
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L27")     #ùĿ¼

#ȡϸļݽ
immune=read.table(immuneFile, header=T, sep="\t", check.names=F, row.names=1)
immune=immune[immune[,"P-value"]<pFilter,]
immune=as.matrix(immune[,1:(ncol(immune)-3)])

#ȥƷ
group=sapply(strsplit(row.names(immune),"\\-"), "[", 4)
group=sapply(strsplit(group,""), "[", 1)
group=gsub("2", "1", group)
immune=immune[group==0,]
row.names(immune)=gsub("(.*?)\\-(.*?)\\-(.*?)\\-(.*?)\\-.*", "\\1\\-\\2\\-\\3", row.names(immune))
immune=avereps(immune)

#ȡĽļ
cluster=read.table(cluFile, header=F, sep="\t", row.names=1, check.names=F)

#ȡͬϸ
lowName=row.names(cluster)[cluster[,2]=="ICD low"]        #ȡICDͱƷ
highName=row.names(cluster)[cluster[,2]=="ICD high"]      #ȡICD߱Ʒ
lowImm=intersect(row.names(immune), lowName)
highImm=intersect(row.names(immune), highName)
rt=rbind(immune[lowImm,], immune[highImm,])
lowNum=length(lowImm)
highNum=length(highImm)

#Сͼ
outTab=data.frame()
pdf("vioplot.pdf", width=8.5, height=6)
par(las=1,mar=c(10,6,3,3))
x=c(1:ncol(rt))
y=c(1:ncol(rt))
plot(x, y,
     xlim=c(0,63), ylim=c(min(rt),max(rt)+0.02),
     main="",xlab="", ylab="Fraction",
     pch=21,
     col="white",
     xaxt="n")

#ϸѭСͼICDͱɫʾICD߱úɫʾ
bioCol=c("#0066FF","#FF0000","#FF9900","#6E568C","#7CC767","#223D6C","#D20A13","#FFD121","#088247","#11AA4D")
for(i in 1:ncol(rt)){
	  if(sd(rt[1:lowNum,i])==0){
	    rt[1,i]=0.00001
	  }
	  if(sd(rt[(lowNum+1):(lowNum+highNum),i])==0){
	    rt[(lowNum+1),i]=0.00001
	  }
	  lowData=rt[1:lowNum,i]
	  highData=rt[(lowNum+1):(lowNum+highNum),i]
	  vioplot(lowData, at=3*(i-1), lty=1, add=T, col=bioCol[1], width=1.5)
	  vioplot(highData, at=3*(i-1)+1, lty=1, add=T, col=bioCol[2], width=1.5)
	  #,۲ϸڸߵͱ֮Ƿв
	  wilcoxTest=wilcox.test(lowData,highData)
	  p=wilcoxTest$p.value
	  if(p<pFilter){
	      cellPvalue=cbind(Cell=colnames(rt)[i],pvalue=p)
		  outTab=rbind(outTab,cellPvalue)
	  }
	  mx=max(c(lowData,highData))
	  #lines(c(x=3*(i-1)+0.2,x=3*(i-1)+0.8),c(mx,mx))
	  Sig=ifelse(p<0.001,"***",ifelse(p<0.01,"**",ifelse(p<0.05,"*","")))
	  text(x=3*(i-1)+0.5, y=mx+0.01, labels=Sig, cex=1.3)
}
legend("topright", 
       c("ICD low", "ICD high"),
       lwd=4.5,bty="n",cex=1,
       col=bioCol[1:2])
text(seq(1,64,3), -0.03, xpd=NA, labels=colnames(rt), cex=0.8, srt=45, pos=2)
dev.off()

#ϸpֵļ
write.table(outTab, file="diff.result.xls", sep="\t", row.names=F, quote=F)

#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")

#install.packages("plyr")
#install.packages("reshape2")
#install.packages("ggplot2")
#install.packages("ggpubr")


#ð
library(limma)
library(plyr)
library(reshape2)
library(ggplot2)
library(ggpubr)

expFile="symbol.txt"         #ļ
geneFile="gene.txt"          #бļ
groupFile="ICDgroup.txt"     #Ľļ
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L28")     #ùĿ¼

#ȡļ,ݽд
rt=read.table(expFile, header=T, sep="\t", check.names=F)
rt=as.matrix(rt)
rownames(rt)=rt[,1]
exp=rt[,2:ncol(rt)]
dimnames=list(rownames(exp),colnames(exp))
data=matrix(as.numeric(as.matrix(exp)),nrow=nrow(exp),dimnames=dimnames)
data=avereps(data)

#ȡļ, ȡHLAػı
gene=read.table(geneFile, header=F, sep="\t", check.names=F)
sameGene=intersect(row.names(data),as.vector(gene[,1]))
data=t(data[sameGene,])
data=log2(data+1)

#ɾƷ
group=sapply(strsplit(row.names(data),"\\-"), "[", 4)
group=sapply(strsplit(group,""), "[", 1)
group=gsub("2", "1", group)
data=data[group==0,]
rownames(data)=gsub("(.*?)\\-(.*?)\\-(.*?)\\-(.*?)\\-.*", "\\1\\-\\2\\-\\3", rownames(data))
data=avereps(data)

#ȡĽļ
Type=read.table(groupFile, header=T, sep="\t", check.names=F, row.names=1)
Type$Group=factor(Type$Group, levels=c("ICD low", "ICD high"))

#ϲ
sameSample=intersect(row.names(data), row.names(Type))
rt1=cbind(data[sameSample,,drop=F],Type[sameSample,"Group",drop=F])

#תggplot2ļ
data=melt(rt1, id.vars=c("Group"))
colnames(data)=c("Group", "Gene", "Expression")
data$Gene=factor(data$Gene, levels=sort(as.vector(unique(data$Gene))))

#ͼ
boxplot=ggboxplot(data, x="Gene", y="Expression", fill="Group",
				  xlab="",
				  ylab="Gene expression",
				  legend.title="Group",
				  width=0.8,
				  palette=c("#0066FF","#FF0000") )+
				  rotate_x_text(45)+
	stat_compare_means(aes(group=Group),
		method="wilcox.test",
		symnum.args=list(cutpoints=c(0, 0.001, 0.01, 0.05, 1), symbols=c("***", "**", "*", "")), label="p.signif")
	
#ͼƬ
pdf(file="boxplot.pdf", width=8, height=5.6)
print(boxplot)
dev.off()

#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")

#install.packages("plyr")
#install.packages("reshape2")
#install.packages("ggplot2")
#install.packages("ggpubr")


#ð
library(limma)
library(plyr)
library(reshape2)
library(ggplot2)
library(ggpubr)

expFile="symbol.txt"         #ļ
geneFile="gene.txt"          #бļ
groupFile="ICDgroup.txt"     #Ľļ
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L29")     #ùĿ¼

#ȡļ,ݽд
rt=read.table(expFile, header=T, sep="\t", check.names=F)
rt=as.matrix(rt)
rownames(rt)=rt[,1]
exp=rt[,2:ncol(rt)]
dimnames=list(rownames(exp),colnames(exp))
data=matrix(as.numeric(as.matrix(exp)),nrow=nrow(exp),dimnames=dimnames)
data=avereps(data)

#ȡļ,ȡ߼ػı
gene=read.table(geneFile, header=F, sep="\t", check.names=F)
sameGene=intersect(row.names(data),as.vector(gene[,1]))
data=t(data[sameGene,])
data=log2(data+1)

#ɾƷ
group=sapply(strsplit(row.names(data),"\\-"),"[",4)
group=sapply(strsplit(group,""),"[",1)
group=gsub("2","1",group)
data=data[group==0,]
rownames(data)=gsub("(.*?)\\-(.*?)\\-(.*?)\\-(.*?)\\-.*", "\\1\\-\\2\\-\\3", rownames(data))
data=avereps(data)

#ȡĽļ
Type=read.table(groupFile, header=T, sep="\t", check.names=F, row.names=1)
Type$Group=factor(Type$Group, levels=c("ICD low", "ICD high"))

#ϲ
sameSample=intersect(row.names(data), row.names(Type))
rt1=cbind(data[sameSample,,drop=F],Type[sameSample,"Group",drop=F])

#תggplot2ļ
data=melt(rt1, id.vars=c("Group"))
colnames(data)=c("Group", "Gene", "Expression")

#ñȽ
group=levels(factor(Type$Group))
comp=combn(group,2)
my_comparisons=list()
for(i in 1:ncol(comp)){my_comparisons[[i]]<-comp[,i]}

#ͼ
boxplot=ggboxplot(data, x="Group", y="Expression", fill="Group",
				  xlab="",
				  ylab="Gene expression",
				  legend.title="Group",
				  width=0.8,
				  palette=c("#0066FF","#FF0000") )+
				  rotate_x_text(45)+ 
	stat_compare_means(comparisons = my_comparisons)+ #theme(axis.text.x=element_blank())+
	facet_wrap(~Gene, nrow=1)

#ͼ
pdf(file="boxplot.pdf", width=10, height=7)
print(boxplot)
dev.off()

#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")

#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("sva")


#ð
library(limma)
library(sva)

tcgaExpFile="symbol.txt"       #TCGAļ
geoExpFile="geoMatrix.txt"     #GEOļ
geneFile="gene.txt"            #бļ
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L30\\GSE13507")     #ùĿ¼

#ȡTCGAļ,ݽд
rt=read.table(tcgaExpFile, header=T, sep="\t", check.names=F)
rt=as.matrix(rt)
rownames(rt)=rt[,1]
exp=rt[,2:ncol(rt)]
dimnames=list(rownames(exp),colnames(exp))
tcga=matrix(as.numeric(as.matrix(exp)),nrow=nrow(exp),dimnames=dimnames)
tcga=avereps(tcga)
tcga=log2(tcga+1)

#ȡgeoļ,ݽд
rt=read.table(geoExpFile, header=T, sep="\t", check.names=F)
rt=as.matrix(rt)
rownames(rt)=rt[,1]
exp=rt[,2:ncol(rt)]
dimnames=list(rownames(exp),colnames(exp))
geo=matrix(as.numeric(as.matrix(exp)),nrow=nrow(exp),dimnames=dimnames)
geo=avereps(geo)

#GEOûȡlog2,Զȡlog2
qx=as.numeric(quantile(geo, c(0, 0.25, 0.5, 0.75, 0.99, 1.0), na.rm=T))
LogC=( (qx[5]>100) || ( (qx[6]-qx[1])>50 && qx[2]>0) )
if(LogC){
    geo[geo<0]=0
    geo=log2(geo+1)}
geo=normalizeBetweenArrays(geo)

#ݿĻȡ,ֱ2ݿнı
sameGene=intersect(row.names(tcga),row.names(geo))
tcgaOut=tcga[sameGene,]
geoOut=geo[sameGene,]

#2ݽν
all=cbind(tcgaOut,geoOut)
batchType=c(rep(1,ncol(tcgaOut)),rep(2,ncol(geoOut)))
outTab=ComBat(all, batchType, par.prior=TRUE)
tcgaOut=outTab[,colnames(tcgaOut)]
#tcgaOut[tcgaOut<0]=0
geoOut=outTab[,colnames(geoOut)]
#geoOut[geoOut<0]=0

#
tcgaTab=rbind(ID=colnames(tcgaOut), tcgaOut)
write.table(tcgaTab, file="TCGA.normalize.txt", sep="\t", quote=F, col.names=F)
geoTab=rbind(ID=colnames(geoOut), geoOut)
write.table(geoTab,file="GEO.normalize.txt",sep="\t",quote=F,col.names=F)

#ȡбļ,ȡԭϸı
gene=read.table(geneFile, header=F, sep="\t", check.names=F)
sameGene=intersect(as.vector(gene[,1]), rownames(tcgaOut))
tcgaShareExp=tcgaOut[sameGene,]
geoShareExp=geoOut[sameGene,]

#ԭϸı
tcgaShareExp=rbind(ID=colnames(tcgaShareExp),tcgaShareExp)
write.table(tcgaShareExp,file="TCGA.share.txt",sep="\t",quote=F,col.names=F)
geoShareExp=rbind(ID=colnames(geoShareExp),geoShareExp)
write.table(geoShareExp,file="GEO.share.txt",sep="\t",quote=F,col.names=F)

#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")


library(limma)               #ð
expFile="TCGA.share.txt"     #ļ
cliFile="time.txt"           #ļ
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L31\\GSE13507")      #ùĿ¼

#ȡļļ
rt=read.table(expFile, header=T, sep="\t", check.names=F)
rt=as.matrix(rt)
rownames(rt)=rt[,1]
exp=rt[,2:ncol(rt)]
dimnames=list(rownames(exp),colnames(exp))
data=matrix(as.numeric(as.matrix(exp)),nrow=nrow(exp),dimnames=dimnames)
data=avereps(data)
data=data[rowMeans(data)>0,]

#ȥƷ
group=sapply(strsplit(colnames(data),"\\-"), "[", 4)
group=sapply(strsplit(group,""), "[", 1)
group=gsub("2","1",group)
data=data[,group==0]
colnames(data)=gsub("(.*?)\\-(.*?)\\-(.*?)\\-.*", "\\1\\-\\2\\-\\3", colnames(data))
data=t(data)
data=avereps(data)

#ȡļ
cli=read.table(cliFile, header=T, sep="\t", check.names=F, row.names=1)

#ݺϲ
sameSample=intersect(row.names(data), row.names(cli))
data=data[sameSample,]
cli=cli[sameSample,]
out=cbind(cli, data)
out=cbind(id=row.names(out), out)
write.table(out, file="TCGA.expTime.txt", sep="\t", row.names=F, quote=F)

#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")


library(limma)              #ð
expFile="geo.share.txt"     #ļ
cliFile="time.txt"          #ļ
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L32\\GSE13507")     #ùĿ¼

#ȡļļ
rt=read.table(expFile, header=T, sep="\t", check.names=F)
rt=as.matrix(rt)
rownames(rt)=rt[,1]
exp=rt[,2:ncol(rt)]
dimnames=list(rownames(exp),colnames(exp))
data=matrix(as.numeric(as.matrix(exp)),nrow=nrow(exp),dimnames=dimnames)
data=avereps(data)
data=data[rowMeans(data)>0,]
data=t(data)

#ȡļ
cli=read.table(cliFile, header=T, sep="\t", check.names=F, row.names=1)

#ݺϲ
sameSample=intersect(row.names(data),row.names(cli))
data=data[sameSample,]
cli=cli[sameSample,]
out=cbind(cli,data)
out=cbind(id=row.names(out),out)
write.table(out,file="GEO.expTime.txt",sep="\t",row.names=F,quote=F)

#install.packages('survival')
#install.packages("survminer")


#ð
library(survival)
library(survminer)

coxPfilter=0.05                  #ԵĹ
inputFile="TCGA.expTime.txt"     #ļ
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L33\\GSE13507")     #ùĿ¼

#ȡļ
rt=read.table(inputFile, header=T, sep="\t", check.names=F, row.names=1)
rt$futime=rt$futime/365

#ԻѭԤصĻ
outTab=data.frame()
sigGenes=c("futime","fustat")
for(i in colnames(rt[,3:ncol(rt)])){
	#cox
	cox <- coxph(Surv(futime, fustat) ~ rt[,i], data = rt)
	coxSummary = summary(cox)
	coxP=coxSummary$coefficients[,"Pr(>|z|)"]
	#ԤصĻ
	if(coxP<coxPfilter){
	    sigGenes=c(sigGenes,i)
		outTab=rbind(outTab,
			         cbind(id=i,
			         HR=coxSummary$conf.int[,"exp(coef)"],
			         HR.95L=coxSummary$conf.int[,"lower .95"],
			         HR.95H=coxSummary$conf.int[,"upper .95"],
			         pvalue=coxSummary$coefficients[,"Pr(>|z|)"])
			        )
	}
}

#صĽ
write.table(outTab,file="TCGA.uniCox.txt",sep="\t",row.names=F,quote=F)

#ȡı
uniSigExp=rt[,sigGenes]
uniSigExp=cbind(id=row.names(uniSigExp),uniSigExp)
write.table(uniSigExp,file="TCGA.uniSigExp.txt",sep="\t",row.names=F,quote=F)


############ɭͼ############
bioForest=function(coxFile=null,forestFile=null,forestCol=null){
	#ȡļ
	rt <- read.table(coxFile,header=T,sep="\t",check.names=F,row.names=1)
	gene <- rownames(rt)
	hr <- sprintf("%.3f",rt$"HR")
	hrLow  <- sprintf("%.3f",rt$"HR.95L")
	hrHigh <- sprintf("%.3f",rt$"HR.95H")
	Hazard.ratio <- paste0(hr,"(",hrLow,"-",hrHigh,")")
	pVal <- ifelse(rt$pvalue<0.001, "<0.001", sprintf("%.3f", rt$pvalue))
		
	#ͼ
	height=nrow(rt)/12.5+5
	pdf(file=forestFile, width = 7,height = height)
	n <- nrow(rt)
	nRow <- n+1
	ylim <- c(1,nRow)
	layout(matrix(c(1,2),nc=2),width=c(3,2.5))
		
	#ɭͼߵĻϢ
	xlim = c(0,3)
	par(mar=c(4,2.5,2,1))
	plot(1,xlim=xlim,ylim=ylim,type="n",axes=F,xlab="",ylab="")
	text.cex=0.8
	text(0,n:1,gene,adj=0,cex=text.cex)
	text(1.5-0.5*0.2,n:1,pVal,adj=1,cex=text.cex);text(1.5-0.5*0.2,n+1,'pvalue',cex=text.cex,font=2,adj=1)
	text(3,n:1,Hazard.ratio,adj=1,cex=text.cex);text(3,n+1,'Hazard ratio',cex=text.cex,font=2,adj=1,)
		
	#ɭͼ
	par(mar=c(4,1,2,1),mgp=c(2,0.5,0))
	xlim = c(0,max(as.numeric(hrLow),as.numeric(hrHigh)))
	plot(1,xlim=xlim,ylim=ylim,type="n",axes=F,ylab="",xaxs="i",xlab="Hazard ratio")
	arrows(as.numeric(hrLow),n:1,as.numeric(hrHigh),n:1,angle=90,code=3,length=0.05,col="darkblue",lwd=2.5)
	abline(v=1,col="black",lty=2,lwd=2)
	boxcolor = ifelse(as.numeric(hr) > 1, forestCol[1], forestCol[2])
	points(as.numeric(hr), n:1, pch = 15, col = boxcolor, cex=1.6)
	axis(1)
	dev.off()
}

#ú, ԵصĽпӻ, ɭͼ
bioForest(coxFile="TCGA.uniCox.txt",forestFile="forest.pdf",forestCol=c("red","green"))

#install.packages("glmnet")
#install.packages("survival")


#ð
library("glmnet")
library("survival")

trainFile="TCGA.uniSigExp.txt"    #ıļ
testFile="GEO.expTime.txt"        #GEOݿļ
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L34\\GSE13507")     #ùĿ¼

#ȡtrainļ
rt=read.table(trainFile, header=T, sep="\t", check.names=F, row.names=1)
rt$futime[rt$futime<=0]=0.003

#lassoعģ
x=as.matrix(rt[,c(3:ncol(rt))])
y=data.matrix(Surv(rt$futime,rt$fustat))
fit=glmnet(x, y, family = "cox", maxit = 1000)
#lassoعͼ
pdf("lasso.lambda.pdf")
plot(fit, xvar="lambda", label=TRUE)
dev.off()
#ƽ֤ͼ
cvfit=cv.glmnet(x, y, family="cox", maxit=1000)
pdf("lasso.cvfit.pdf")
plot(cvfit)
abline(v=log(c(cvfit$lambda.min,cvfit$lambda.1se)), lty="dashed")
dev.off()

#ҵ֤Сĵ㣬ģ͹ʽ
coef=coef(fit, s = cvfit$lambda.min)
index=which(coef != 0)
actCoef=coef[index]
lassoGene=row.names(coef)[index]
geneCoef=cbind(Gene=lassoGene,Coef=actCoef)
write.table(geneCoef,file="geneCoef.txt",sep="\t",quote=F,row.names=F)

#TCGAݿķļ
trainFinalGeneExp=rt[,lassoGene]
myFun=function(x){crossprod(as.numeric(x),actCoef)}
trainScore=apply(trainFinalGeneExp,1,myFun)
outCol=c("futime","fustat",lassoGene)
Risk=as.vector(ifelse(trainScore>median(trainScore),"high","low"))
outTab=cbind(rt[,outCol],riskScore=as.vector(trainScore),Risk)
write.table(cbind(id=rownames(outTab),outTab),file="risk.TCGA.txt",sep="\t",quote=F,row.names=F)

#GEOݿķļ
rt=read.table(testFile, header=T, sep="\t", row.names=1)
rt$futime=rt$futime/365
testFinalGeneExp=rt[,lassoGene]
testScore=apply(testFinalGeneExp,1,myFun)
outCol=c("futime","fustat",lassoGene)
Risk=as.vector(ifelse(testScore>median(trainScore),"high","low"))
outTab=cbind(rt[,outCol],riskScore=as.vector(testScore),Risk)
write.table(cbind(id=rownames(outTab),outTab),file="risk.GEO.txt",sep="\t",quote=F,row.names=F)

#install.packages("survival")
#install.packages("survminer")


#ð
library(survival)
library(survminer)
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L35\\GSE13507")     #ùĿ¼

#ĺ
bioSurvival=function(inputFile=null, outFile=null){
	#ȡļ
	rt=read.table(inputFile, header=T, sep="\t", check.names=F)
	#Ƚϸߵͷ죬õԵpvalue
	diff=survdiff(Surv(futime, fustat) ~ Risk,data = rt)
	pValue=1-pchisq(diff$chisq,df=1)
	if(pValue<0.001){
		pValue="p<0.001"
	}else{
		pValue=paste0("p=",sprintf("%.03f",pValue))
	}
	fit <- survfit(Surv(futime, fustat) ~ Risk, data = rt)
		
	#
	surPlot=ggsurvplot(fit, 
		           data=rt,
		           conf.int=F,
		           pval=pValue,
		           pval.size=6,
		           legend.title="Risk",
		           legend.labs=c("High risk", "Low risk"),
		           xlab="Time(years)",
		           ylab="Overall survival",
		           break.time.by = 2,
		           palette=c("red", "blue"),
		           risk.table=TRUE,
		           risk.table.title="",
		           risk.table.height=.25)
	#ͼ
	pdf(file=outFile, width=6, height=5, onefile=FALSE)
	print(surPlot)
	dev.off()
}

#ú,
bioSurvival(inputFile="risk.TCGA.txt", outFile="survival.TCGA.pdf")
bioSurvival(inputFile="risk.GEO.txt", outFile="survival.GEO.pdf")

#install.packages("pheatmap")


library(pheatmap)         #ð
setwd("E:\\00shengxin\\ICDBLCA\\L36")      #ùĿ¼

#ߵĺ
bioRiskPlot=function(inputFile=null, project=null){
	rt=read.table(inputFile, header=T, sep="\t", check.names=F, row.names=1)    #ȡļ
	rt=rt[order(rt$riskScore),]      #ݲ˷յ÷ֶƷ
		
	#Ʒ
	riskClass=rt[,"Risk"]
	lowLength=length(riskClass[riskClass=="low"])
	highLength=length(riskClass[riskClass=="high"])
	lowMax=max(rt$riskScore[riskClass=="low"])
	line=rt[,"riskScore"]
	line[line>10]=10
	pdf(file=paste0(project, ".riskScore.pdf"), width=7, height=4)
	plot(line, type="p", pch=20,
		 xlab="Patients (increasing risk socre)",
		 ylab="Risk score",
		 col=c(rep("blue",lowLength),rep("red",highLength)) )
	abline(h=lowMax,v=lowLength,lty=2)
	legend("topleft", c("High risk","Low risk"),bty="n",pch=19,col=c("red","blue"),cex=1.2)
	dev.off()
		
	#״̬ͼ
	color=as.vector(rt$fustat)
	color[color==1]="red"
	color[color==0]="blue"
	pdf(file=paste0(project, ".survStat.pdf"), width=7, height=4)
	plot(rt$futime, pch=19,
		 xlab="Patients (increasing risk socre)",
		 ylab="Survival time (years)",
		 col=color)
	legend("topleft", c("Dead","Alive"),bty="n",pch=19,col=c("red","blue"),cex=1.2)
	abline(v=lowLength,lty=2)
	dev.off()
	
	#ͼע͵ɫ
	ann_colors=list()
	bioCol=c("blue", "red")
	names(bioCol)=c("low", "high")
	ann_colors[["Risk"]]=bioCol

	#Ʒͼ
	rt1=rt[c(3:(ncol(rt)-2))]
	rt1=t(rt1)
	annotation=data.frame(Risk=rt[,ncol(rt)])
	rownames(annotation)=rownames(rt)
	pdf(file=paste0(project, ".heatmap.pdf"), width=7, height=4)
	pheatmap(rt1, 
		     annotation=annotation,
		     annotation_colors = ann_colors, 
		     cluster_cols = FALSE,
		     cluster_rows = FALSE,
		     show_colnames = F,
		     color = colorRampPalette(c(rep("blue",3.5), "white", rep("red",3.5)))(50),
		     scale="row",
		     fontsize_col=3,
		     fontsize=7,
		     fontsize_row=8)
	dev.off()
}

#úƷ
bioRiskPlot(inputFile="risk.TCGA.txt", project="TCGA")

#install.packages('survival')


library(survival)       #ð
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L37")     #ùĿ¼

############ɭͼ############
bioForest=function(coxFile=null, forestFile=null, forestCol=null){
	#ȡļ
	rt <- read.table(coxFile, header=T, sep="\t", check.names=F, row.names=1)
	gene <- rownames(rt)
	hr <- sprintf("%.3f",rt$"HR")
	hrLow  <- sprintf("%.3f",rt$"HR.95L")
	hrHigh <- sprintf("%.3f",rt$"HR.95H")
	Hazard.ratio <- paste0(hr,"(",hrLow,"-",hrHigh,")")
	pVal <- ifelse(rt$pvalue<0.001, "<0.001", sprintf("%.3f", rt$pvalue))
		
	#ͼ
	pdf(file=forestFile, width=6.5, height=4.5)
	n <- nrow(rt)
	nRow <- n+1
	ylim <- c(1,nRow)
	layout(matrix(c(1,2),nc=2),width=c(3,2.5))
		
	#ɭͼߵٴϢ
	xlim = c(0,3)
	par(mar=c(4,2.5,2,1))
	plot(1,xlim=xlim,ylim=ylim,type="n",axes=F,xlab="",ylab="")
	text.cex=0.8
	text(0,n:1,gene,adj=0,cex=text.cex)
	text(1.5-0.5*0.2,n:1,pVal,adj=1,cex=text.cex);text(1.5-0.5*0.2,n+1,'pvalue',cex=text.cex,font=2,adj=1)
	text(3.1,n:1,Hazard.ratio,adj=1,cex=text.cex);text(3.1,n+1,'Hazard ratio',cex=text.cex,font=2,adj=1)
		
	#ұߵɭͼ
	par(mar=c(4,1,2,1),mgp=c(2,0.5,0))
	xlim = c(0,max(as.numeric(hrLow),as.numeric(hrHigh)))
	plot(1,xlim=xlim,ylim=ylim,type="n",axes=F,ylab="",xaxs="i",xlab="Hazard ratio")
	arrows(as.numeric(hrLow),n:1,as.numeric(hrHigh),n:1,angle=90,code=3,length=0.05,col="darkblue",lwd=3)
	abline(v=1, col="black", lty=2, lwd=2)
	boxcolor = ifelse(as.numeric(hr) > 1, forestCol, forestCol)
	points(as.numeric(hr), n:1, pch = 15, col = boxcolor, cex=2)
	axis(1)
	dev.off()
}
############ɭͼ############

#Ԥ
indep=function(riskFile=null,cliFile=null,uniOutFile=null,multiOutFile=null,uniForest=null,multiForest=null){
	risk=read.table(riskFile, header=T, sep="\t", check.names=F, row.names=1)    #ȡļ
	cli=read.table(cliFile, header=T, sep="\t", check.names=F, row.names=1)      #ȡٴļ
	
	#ݺϲ
	sameSample=intersect(row.names(cli),row.names(risk))
	risk=risk[sameSample,]
	cli=cli[sameSample,]
	rt=cbind(futime=risk[,1], fustat=risk[,2], cli, riskScore=risk[,(ncol(risk)-1)])
	
	#ضԤ
	uniTab=data.frame()
	for(i in colnames(rt[,3:ncol(rt)])){
		 cox <- coxph(Surv(futime, fustat) ~ rt[,i], data = rt)
		 coxSummary = summary(cox)
		 uniTab=rbind(uniTab,
		              cbind(id=i,
		              HR=coxSummary$conf.int[,"exp(coef)"],
		              HR.95L=coxSummary$conf.int[,"lower .95"],
		              HR.95H=coxSummary$conf.int[,"upper .95"],
		              pvalue=coxSummary$coefficients[,"Pr(>|z|)"])
		              )
	}
	write.table(uniTab,file=uniOutFile,sep="\t",row.names=F,quote=F)
	bioForest(coxFile=uniOutFile, forestFile=uniForest, forestCol="green")

	#ضԤ
	uniTab=uniTab[as.numeric(uniTab[,"pvalue"])<1,]
	rt1=rt[,c("futime", "fustat", as.vector(uniTab[,"id"]))]
	multiCox=coxph(Surv(futime, fustat) ~ ., data = rt1)
	multiCoxSum=summary(multiCox)
	multiTab=data.frame()
	multiTab=cbind(
	             HR=multiCoxSum$conf.int[,"exp(coef)"],
	             HR.95L=multiCoxSum$conf.int[,"lower .95"],
	             HR.95H=multiCoxSum$conf.int[,"upper .95"],
	             pvalue=multiCoxSum$coefficients[,"Pr(>|z|)"])
	multiTab=cbind(id=row.names(multiTab),multiTab)
	write.table(multiTab,file=multiOutFile,sep="\t",row.names=F,quote=F)
	bioForest(coxFile=multiOutFile, forestFile=multiForest, forestCol="red")
}

#úжԤ
indep(riskFile="risk.TCGA.txt",
      cliFile="clinical.txt",
      uniOutFile="uniCox.txt",
      multiOutFile="multiCox.txt",
      uniForest="uniForest.pdf",
      multiForest="multiForest.pdf")

#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")

#install.packages("tidyverse")
#install.packages("ggplot2")
#install.packages("ggExtra")
#install.packages("ggpubr")


#ð
library(limma)
library(reshape2)
library(tidyverse)
library(ggplot2)
library(ggpubr)
library(ggExtra)

immFile="CIBERSORT-Results.txt"     #ϸĽļ
riskFile="risk.TCGA.txt"            #ļ
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L38")     #ùĿ¼

#ȡϸĽļݽ
immune=read.table(immFile, header=T, sep="\t", check.names=F, row.names=1)
immune=immune[immune[,"P-value"]<0.05,]
immune=as.matrix(immune[,1:(ncol(immune)-3)])

#ȥƷ
group=sapply(strsplit(row.names(immune),"\\-"), "[", 4)
group=sapply(strsplit(group,""), "[", 1)
group=gsub("2", "1", group)
immune=immune[group==0,]
rownames(immune)=gsub("(.*?)\\-(.*?)\\-(.*?)\\-.*", "\\1\\-\\2\\-\\3", rownames(immune))
data=avereps(immune)

#ȡļ
risk=read.table(riskFile, header=T, sep="\t", check.names=F, row.names=1)
sameSample=intersect(row.names(data), row.names(risk))
data=data[sameSample,,drop=F]
risk=risk[sameSample,,drop=F]

#ϸѭõմϸ
for(i in colnames(data)[1:ncol(data)]){
	x=as.numeric(risk[,"riskScore"])
	x[x>quantile(x,0.99)]=quantile(x,0.99)
	y=as.numeric(data[,i])
	if(sd(y)<0.01){next}
	cor=cor.test(x, y, method="spearman")
	#pvalueС0.05ϸɢͼĻ
	if(cor$p.value<0.05){
		outFile=paste0("cor.", i, ".pdf")
		df1=as.data.frame(cbind(x,y))
		p1=ggplot(df1, aes(x, y)) + 
				  xlab("Risk score") + ylab(i)+
				  geom_point() + geom_smooth(method="lm",formula = y ~ x) + theme_bw()+
				  stat_cor(method = 'spearman', aes(x =x, y =y))
		p2=ggMarginal(p1, type="histogram", xparams=list(fill = "orange"), yparams=list(fill = "blue"))
		#ͼ
		pdf(file=outFile, width=5.2, height=5)
		print(p2)
		dev.off()
	}
}

if (!requireNamespace("BiocManager", quietly = TRUE))
    install.packages("BiocManager")
BiocManager::install("limma")

install.packages("ggplot2")
install.packages("ggpubr")


#ð
library(limma)
library(plyr)
library(ggplot2)
library(ggpubr)

tideFile="TIDE.csv"           #TIDEĴļ
riskFile="risk.TCGA.txt"      #ļ
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L39")     #ùĿ¼

#ȡTIDEĴļ
tide=read.csv(tideFile, header=T, sep=",", check.names=F, row.names=1)
tide$Responder=ifelse(tide$Responder=="TRUE", "Responder", "Non-responder")

#ȥƷ
group=sapply(strsplit(row.names(tide),"\\-"), "[", 4)
group=sapply(strsplit(group,""), "[", 1)
group=gsub("2", "1", group)
tide=tide[group==0, ,drop=F]
row.names(tide)=gsub("(.*?)\\-(.*?)\\-(.*?)\\-(.*?)\\-.*", "\\1\\-\\2\\-\\3", row.names(tide))
tide=cbind(id=row.names(tide), tide)

#ȡļ
risk=read.table(riskFile, header=T, sep="\t", check.names=F, row.names=1)
risk$risk=factor(risk$risk, levels=c("low", "high"))

#ϲ
sameSample=intersect(row.names(tide), row.names(risk))
tide=tide[sameSample, , drop=F]
risk=risk[sameSample, "riskScore", drop=F]
data=cbind(tide, risk)

#ñȽ
type=levels(factor(data[,"Responder"]))
comp=combn(type, 2)
my_comparisons=list()
for(i in 1:ncol(comp)){my_comparisons[[i]]<-comp[,i]}

#ͼ
boxplot=ggboxplot(data, x="Responder", y="riskScore", fill="Responder",
		          xlab="",
		          ylab="Risk score",
		          legend.title="Responder"
		          #palette=bioCol
		          )+ 
	stat_compare_means(comparisons=my_comparisons)

#ͼ
pdf(file="boxplot.pdf", width=5.5, height=4.5)
print(boxplot)
dev.off()



install.packages("survival")
install.packages("survminer")
install.packages("timeROC")


#ð
library(survival)
library(survminer)
library(timeROC)

riskFile="risk.TCGA.txt"      #ļ
cliFile="clinical.txt"        #ٴļ
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L40")     #ùĿ¼

#ȡļ
risk=read.table(riskFile, header=T, sep="\t", check.names=F, row.names=1)
risk=risk[,c("futime", "fustat", "riskScore")]

#ȡٴļ
cli=read.table(cliFile, header=T, sep="\t", check.names=F, row.names=1)

#ϲ
samSample=intersect(row.names(risk), row.names(cli))
risk1=risk[samSample,,drop=F]
cli=cli[samSample,,drop=F]
rt=cbind(risk1, cli)

#ɫ
bioCol=rainbow(ncol(rt)-1, s=0.9, v=0.9)


######1 3 5ROC######
ROC_rt=timeROC(T=risk$futime, delta=risk$fustat,
	           marker=risk$riskScore, cause=1,
	           weighting='aalen',
	           times=c(1,3,5), ROC=TRUE)
pdf(file="ROC.pdf", width=5.5, height=5.5)
plot(ROC_rt,time=1,col=bioCol[1],title=FALSE,lwd=2)
plot(ROC_rt,time=3,col=bioCol[2],add=TRUE,title=FALSE,lwd=2)
plot(ROC_rt,time=5,col=bioCol[3],add=TRUE,title=FALSE,lwd=2)
legend('bottomright',
	   c(paste0('AUC at 1 years: ',sprintf("%.03f",ROC_rt$AUC[1])),
	     paste0('AUC at 3 years: ',sprintf("%.03f",ROC_rt$AUC[2])),
	     paste0('AUC at 5 years: ',sprintf("%.03f",ROC_rt$AUC[3]))),
	   col=bioCol[1:3], lwd=2, bty = 'n')
dev.off()


######ٴROC######
predictTime=1     #Ԥ
aucText=c()
pdf(file="cliROC.pdf", width=5.5, height=5.5)
#Ʒյ÷ֵROC
i=3
ROC_rt=timeROC(T=risk$futime,
               delta=risk$fustat,
               marker=risk$riskScore, cause=1,
               weighting='aalen',
               times=c(predictTime),ROC=TRUE)
plot(ROC_rt, time=predictTime, col=bioCol[i-2], title=FALSE, lwd=2)
aucText=c(paste0("Risk", ", AUC=", sprintf("%.3f",ROC_rt$AUC[2])))
abline(0,1)
#ٴݽѭٴݵROC
for(i in 4:ncol(rt)){
	ROC_rt=timeROC(T=rt$futime,
				   delta=rt$fustat,
				   marker=rt[,i], cause=1,
				   weighting='aalen',
				   times=c(predictTime),ROC=TRUE)
	plot(ROC_rt, time=predictTime, col=bioCol[i-2], title=FALSE, lwd=2, add=TRUE)
	aucText=c(aucText, paste0(colnames(rt)[i],", AUC=",sprintf("%.3f",ROC_rt$AUC[2])))
}
#ͼõROCµ
legend("bottomright", aucText,lwd=2,bty="n",col=bioCol[1:(ncol(rt)-1)])
dev.off()


#install.packages("survival")
#install.packages("survminer")


#ð
library(survival)
library(survminer)

inputFile="risk.TCGA.txt"      #ļ
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L41")     #ùĿ¼

#ȡļ
rt=read.table(inputFile, header=T, sep="\t", check.names=F, row.names=1)
rt=rt[,1:(ncol(rt)-2)]

#Իѭ
outTab=data.frame()
for(gene in colnames(rt)[3:ncol(rt)]){
	if(sd(rt[,gene])<0.001){next}
	data=rt[,c("futime", "fustat", gene)]
	colnames(data)=c("futime", "fustat", "gene")
	
	#ȡcutoff
	res.cut=surv_cutpoint(data, time = "futime", event = "fustat", variables =c("gene"))
	res.cat=surv_categorize(res.cut)
	fit=survfit(Surv(futime, fustat) ~gene, data = res.cat)
	
	#Ƚϸߵͱ
	diff=survdiff(Surv(futime, fustat) ~gene,data =res.cat)
	pValue=1-pchisq(diff$chisq, df=1)
	outVector=cbind(gene, res.cut$cutpoint[1], pValue)
	outTab=rbind(outTab,outVector)
	if(pValue<0.001){
		pValue="p<0.001"
	}else{
		pValue=paste0("p=",sprintf("%.03f",pValue))
	}
		
	#
	surPlot=ggsurvplot(fit,
					data=res.cat,
					pval=pValue,
					pval.size=6,
					legend.title=gene,
					legend.labs=c("high","low"),
					xlab="Time(years)",
					break.time.by=1,
					palette=c("red", "blue"),
					conf.int=F,
					risk.table=F,
					risk.table.title="",
					risk.table.height=.25)
	
	#ͼ
	pdf(file=paste0("Survival.",gene,".pdf"), width=5.5, height=5.1, onefile=FALSE)
	print(surPlot)
	dev.off()
}
#pֵļ
write.table(outTab,file="survival.result.txt",sep="\t",row.names=F,quote=F)



install.packages("survival")
install.packages("regplot")
install.packages("rms")


#ð
library(survival)
library(regplot)
library(rms)

riskFile="risk.TCGA.txt"     #ļ
cliFile="clinical.txt"       #ٴļ
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L42")     #ùĿ¼

#ȡļ
risk=read.table(riskFile, header=T, sep="\t", check.names=F, row.names=1)

#ȡٴļ
cli=read.table(cliFile, header=T, sep="\t", check.names=F, row.names=1)
cli=cli[apply(cli,1,function(x)any(is.na(match('unknow',x)))),,drop=F]
cli$Age=as.numeric(cli$Age)

#ϲ
samSample=intersect(row.names(risk), row.names(cli))
risk1=risk[samSample,,drop=F]
cli=cli[samSample,,drop=F]
rt=cbind(risk1[,c("futime", "fustat", "risk")], cli)

#ͼ
res.cox=coxph(Surv(futime, fustat) ~ . , data = rt)
nom1=regplot(res.cox,
              plots = c("density", "boxes"),
              clickable=F,
              title="",
              points=TRUE,
              droplines=TRUE,
              observation=rt[9,],
              rank="sd",
              failtime = c(1,3,5),
              prfail = F)

#ͼķմļ
nomoRisk=predict(res.cox, data=rt, type="risk")
rt=cbind(risk1, Nomogram=nomoRisk)
outTab=rbind(ID=colnames(rt), rt)
write.table(outTab, file="nomoRisk.txt", sep="\t", col.names=F, quote=F)

#У׼
pdf(file="calibration.pdf", width=5, height=5)
#1У׼
f <- cph(Surv(futime, fustat) ~ Nomogram, x=T, y=T, surv=T, data=rt, time.inc=1)
cal <- calibrate(f, cmethod="KM", method="boot", u=1, m=(nrow(rt)/3), B=1000)
plot(cal, xlim=c(0,1), ylim=c(0,1),
	 xlab="Nomogram-predicted OS (%)", ylab="Observed OS (%)", lwd=1.5, col="green", sub=F)
#3У׼
f <- cph(Surv(futime, fustat) ~ Nomogram, x=T, y=T, surv=T, data=rt, time.inc=3)
cal <- calibrate(f, cmethod="KM", method="boot", u=3, m=(nrow(rt)/3), B=1000)
plot(cal, xlim=c(0,1), ylim=c(0,1), xlab="", ylab="", lwd=1.5, col="blue", sub=F, add=T)
#5У׼
f <- cph(Surv(futime, fustat) ~ Nomogram, x=T, y=T, surv=T, data=rt, time.inc=5)
cal <- calibrate(f, cmethod="KM", method="boot", u=5, m=(nrow(rt)/3), B=1000)
plot(cal, xlim=c(0,1), ylim=c(0,1), xlab="", ylab="",  lwd=1.5, col="red", sub=F, add=T)
legend('bottomright', c('1-year', '3-year', '5-year'),
	   col=c("green","blue","red"), lwd=1.5, bty = 'n')
dev.off()



if (!requireNamespace("BiocManager", quietly = TRUE))
    install.packages("BiocManager")
BiocManager::install("ComplexHeatmap")


#ð
library(ComplexHeatmap)
riskFile="risk.TCGA.txt"      #ļ
cliFile="clinical.txt"        #ٴļ
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L43")

#ȡļ
risk=read.table(riskFile, header=T, sep="\t", check.names=F, row.names=1)
risk=risk[order(risk$riskScore),] 

#ȡٴļ
cli=read.table(cliFile, header=T, sep="\t", check.names=F, row.names=1)
cli[,"Age"]=ifelse(cli[,"Age"]=="unknow", "unknow", ifelse(cli[,"Age"]>65,">65","<=65"))

#ϲ
samSample=intersect(row.names(risk), row.names(cli))
risk=risk[samSample,"risk",drop=F]
cli=cli[samSample,,drop=F]
rt=cbind(risk, cli)

#ٴ״ѭ۲ٴ״ڸߵͷ֮Ƿв죬õԱ
sigVec=c("Risk")
for(clinical in colnames(rt[,2:ncol(rt)])){
	data=rt[c("risk", clinical)]
	colnames(data)=c("riskScore", "clinical")
	data=data[(data[,"clinical"]!="unknow"),]
	tableStat=table(data)
	stat=chisq.test(tableStat)
	pvalue=stat$p.value
	Sig=ifelse(pvalue<0.001,"***",ifelse(pvalue<0.01,"**",ifelse(pvalue<0.05,"*","")))
	sigVec=c(sigVec, paste0(clinical, Sig))
}
colnames(rt)=sigVec

#ͼע
#rt=rt[apply(rt,1,function(x)any(is.na(match('unknow',x)))),,drop=F]
bioCol=c("#0066FF","#FF9900","#FF0000","#ed1299", "#0dbc21", "#246b93", "#cc8e12", "#d561dd", "#c93f00", 
         "#ce2523", "#f7aa5d", "#9ed84e", "#39ba30", "#6ad157", "#373bbf", "#a1ce4c", "#ef3bb6", "#d66551",
         "#1a918f", "#7149af", "#ff66fc", "#2927c4", "#57e559" ,"#8e3af4" ,"#f9a270" ,"#22547f", "#db5e92",
         "#4aef7b", "#e86502",  "#99db27", "#e07233", "#8249aa","#cebb10", "#03827f", "#931635", "#ff523f",
         "#edd05e", "#6f25e8", "#0dbc21", "#167275", "#280f7a", "#6373ed", "#5b910f" ,"#7b34c1" ,"#0cf29a" ,"#d80fc1",
         "#dd27ce", "#07a301", "#ddd53e",  "#391c82", "#2baeb5","#925bea", "#09f9f5",  "#63ff4f")
colorList=list(Risk=c("low"="blue", "high"="red"))
j=0
for(cli in colnames(rt[,2:ncol(rt)])){
	cliLength=length(levels(factor(rt[,cli])))
	cliCol=bioCol[(j+1):(j+cliLength)]
	j=j+cliLength
	names(cliCol)=levels(factor(rt[,cli]))
	cliCol["unknow"]="grey75"
	colorList[[cli]]=cliCol
}

#ͼ
ha=HeatmapAnnotation(df=rt, col=colorList)
zero_row_mat=matrix(nrow=0, ncol=nrow(rt))
Hm=Heatmap(zero_row_mat, top_annotation=ha)

#ͼ
pdf(file="heatmap.pdf", width=7, height=5)
draw(Hm, merge_legend = TRUE, heatmap_legend_side = "bottom", annotation_legend_side = "bottom")
dev.off()


#install.packages("ggplot2")
#install.packages("ggpubr")


#ð
library(plyr)
library(ggplot2)
library(ggpubr)

riskFile="risk.TCGA.txt"      #ļ
cliFile="clinical.txt"        #ٴļ
trait="Grade"                 #ٴ״
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L44")     #ùĿ¼

#ȡļ
risk=read.table(riskFile, header=T, sep="\t", check.names=F, row.names=1)
cli=read.table(cliFile, header=T, sep="\t", check.names=F, row.names=1)
sameSample=intersect(row.names(risk), row.names(cli))
rt=cbind(risk[sameSample,,drop=F], cli[sameSample,,drop=F])
rt$risk=factor(rt$risk, levels=c("low", "high"))

#״ͼɫ
bioCol=c("#0066FF","#FF0000","#FF9900","#6E568C","#7CC767","#223D6C","#D20A13","#FFD121","#088247","#11AA4D")
bioCol=bioCol[1:length(unique(rt[,trait]))]

#ͳƸߵͷ鲡Ŀ
rt1=rt[,c(trait, "risk")]
colnames(rt1)=c("trait", "risk")
rt1=rt1[apply(rt1,1,function(x)any(is.na(match('unknow',x)))),,drop=F]
df=as.data.frame(table(rt1))
#ߵͷİٷ
df=ddply(df, .(risk), transform, percent = Freq/sum(Freq) * 100)
#ٷֱȵλ
df=ddply(df, .(risk), transform, pos = (cumsum(Freq) - 0.5 * Freq))
df$label=paste0(sprintf("%.0f", df$percent), "%")
#ưٷֱ״ͼ
p=ggplot(df, aes(x = factor(risk), y = percent, fill = trait)) +
	   geom_bar(position = position_stack(), stat = "identity", width = .7) +
	   scale_fill_manual(values=bioCol)+
	   xlab("riskScore")+ ylab("Percent weight")+  guides(fill=guide_legend(title=trait))+
	   geom_text(aes(label = label), position = position_stack(vjust = 0.5), size = 3) +
	   #coord_flip()+
	   theme_bw()

#ͼ
pdf(file=paste0(trait, ".barplot.pdf"), width=4, height=5)
print(p)
dev.off()


#if (!require("BiocManager"))
#    install.packages("BiocManager")
#BiocManager::install("maftools")


library(maftools)       #ð
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L46")      #ùĿ¼

#ȡļ
risk=read.table("risk.TCGA.txt", header=T, sep="\t", check.names=F)
outTab=risk[,c(1, ncol(risk))]
colnames(outTab)=c("Tumor_Sample_Barcode", "Risk")
write.table(outTab, file="ann.txt", sep="\t", quote=F, row.names=F)

#ȡͻļ
geneNum=20    #ĿչʾͻƵߵ20
geneMut=read.table("geneMut.txt", header=T, sep="\t", check.names=F, row.names=1)
gene=row.names(geneMut)[1:geneNum]

#ע͵ɫ
ann_colors=list()
col=c("blue", "red")
names(col)=c("low", "high")
ann_colors[["Risk"]]=col

#ͷٲͼ
pdf(file="low.pdf", width=6, height=6)
maf=read.maf(maf="low.maf", clinicalData="ann.txt")
oncoplot(maf=maf, clinicalFeatures="Risk", genes=gene, annotationColor=ann_colors, keepGeneOrder=T)
dev.off()

#߷ٲͼ
pdf(file="high.pdf", width=6, height=6)
maf=read.maf(maf="high.maf", clinicalData="ann.txt")
oncoplot(maf=maf, clinicalFeatures="Risk", genes=gene, annotationColor=ann_colors, keepGeneOrder=T)
dev.off()


#install.packages("ggpubr")


#ð
library(ggpubr)
library(reshape2)

riskFile="risk.TCGA.txt"      #ļ
tmbFile="TMB.txt"             #ͻ为ļ
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L47")      #ùĿ¼

#ȡļ
tmb=read.table(tmbFile, header=T, sep="\t", check.names=F, row.names=1)      #ȡͻ为ļ
risk=read.table(riskFile, header=T, sep="\t", check.names=F, row.names=1)    #ȡļ

#ϲ
tmb=as.matrix(tmb)
tmb[tmb>quantile(tmb,0.975)]=quantile(tmb,0.975)
sameSample=intersect(row.names(tmb), row.names(risk))
tmb=tmb[sameSample,,drop=F]
risk=risk[sameSample,,drop=F]
data=cbind(risk, tmb)
data=data[,c("riskScore", "risk", "TMB")]

#ñȽ
data$risk=factor(data$risk, levels=c("low", "high"))
risk=levels(factor(data$risk))
comp=combn(risk, 2)
my_comparisons=list()
for(i in 1:ncol(comp)){my_comparisons[[i]]<-comp[,i]}

#øߵͷɫ
bioCol=c("#0066FF","#FF0000","#6E568C","#7CC767","#223D6C","#D20A13","#FFD121","#088247","#11AA4D")
bioCol=bioCol[1:length(risk)]

#ͼ
boxplot=ggboxplot(data, x="risk", y="TMB", fill="risk",
		          xlab="",
		          ylab="Tumor Burden Mutation",
		          legend.title="Risk",
		          palette = bioCol )+ 
	    stat_compare_means(comparisons = my_comparisons)
pdf(file="boxplot.pdf",width=5,height=4.5)
print(boxplot)
dev.off()

#ͼ
length=length(levels(factor(data$risk)))
bioCol=c("#0066FF","#FF9900","#FF0000","#6E568C","#7CC767","#223D6C","#D20A13","#FFD121","#088247","#11AA4D")
p1=ggplot(data, aes(riskScore, TMB)) + 
		  xlab("Risk score")+ylab("Tumor Burden Mutation")+
		  geom_point(aes(colour=risk))+
		  scale_color_manual(values=bioCol[1:length])+ 
		  geom_smooth(method="lm",formula = y ~ x) + theme_bw()+
		  stat_cor(method = 'spearman', aes(x =riskScore, y =TMB))
#ͼ
pdf(file="cor.pdf", width=6, height=4.5)
print(p1)
dev.off()



#install.packages("survival")
#install.packages("survminer")


#ð
library(survival)
library(survminer)

riskFile="risk.TCGA.txt"      #ļ
tmbFile="TMB.txt"             #ͻ为ļ
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L48")      #ùĿ¼

#ȡļ
risk=read.table(riskFile, header=T, sep="\t", check.names=F, row.names=1)    #ȡļ
tmb=read.table(tmbFile, header=T, sep="\t", check.names=F, row.names=1)      #ȡͻ为ļ

#ϲ
sameSample=intersect(row.names(tmb), row.names(risk))
tmb=tmb[sameSample,,drop=F]
risk=risk[sameSample,,drop=F]
data=cbind(risk, tmb)

#ȡͻ为ŵcutoff
res.cut=surv_cutpoint(data, time = "futime", event = "fustat", variables =c("TMB"))
cutoff=as.numeric(res.cut$cutpoint[1])
tmbType=ifelse(data[,"TMB"]<=cutoff, "L-TMB", "H-TMB")
scoreType=ifelse(data$risk=="low", "low risk", "high risk")
mergeType=paste0(tmbType, "+", scoreType)

#
bioSurvival=function(surData=null, outFile=null){
	diff=survdiff(Surv(futime, fustat) ~ group, data=surData)
	length=length(levels(factor(surData[,"group"])))
	pValue=1-pchisq(diff$chisq, df=length-1)
	if(pValue<0.001){
		pValue="p<0.001"
	}else{
		pValue=paste0("p=",sprintf("%.03f",pValue))
	}
	fit <- survfit(Surv(futime, fustat) ~ group, data = surData)
	#print(surv_median(fit))
	
	#
	bioCol=c("#FF0000","#0066FF","#6E568C","#7CC767","#223D6C","#D20A13","#FFD121","#088247","#11AA4D")
	bioCol=bioCol[1:length]
	surPlot=ggsurvplot(fit, 
			           data=surData,
			           conf.int=F,
			           pval=pValue,
			           pval.size=6,
			           legend.title="",
			           legend.labs=levels(factor(surData[,"group"])),
			           font.legend=10,
			           legend = c(0.8, 0.8),
			           xlab="Time(years)",
			           break.time.by = 1,
			           palette = bioCol,
			           #surv.median.line = "hv",
			           risk.table=F,
			           cumevents=F,
			           risk.table.height=.25)
	#ͼ
	pdf(file=outFile, width=5.5, height=4.8, onefile = FALSE)
	print(surPlot)
	dev.off()
}

#ú,ͻ为ɵ
data$group=tmbType
bioSurvival(surData=data, outFile="TMB.survival.pdf")

#ú,ͻ为ϲ˷յ
data$group=mergeType
bioSurvival(surData=data, outFile="TMB-risk.survival.pdf")


if (!requireNamespace("BiocManager", quietly = TRUE))
    install.packages("BiocManager")
BiocManager::install("limma")

install.packages("scales")
install.packages("ggplot2")
install.packages("ggtext")
install.packages("tidyverse")
install.packages("ggpubr")


#ð
library(limma)
library(scales)
library(ggplot2)
library(ggtext)
library(reshape2)
library(tidyverse)
library(ggpubr)

riskFile="risk.TCGA.txt"      #ļ
immFile="infiltration_estimation_for_tcga.csv"     #ϸļ
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L49")     #ùĿ¼

#ȡյļ
risk=read.table(riskFile, header=T, sep="\t", check.names=F, row.names=1)

#ȡϸļ
immune=read.csv(immFile, header=T, sep=",", check.names=F, row.names=1)
immune=as.matrix(immune)
rownames(immune)=gsub("(.*?)\\-(.*?)\\-(.*?)\\-(.*)", "\\1\\-\\2\\-\\3", rownames(immune))
immune=avereps(immune)

#ԷļϸļȡõƷ
sameSample=intersect(row.names(risk), row.names(immune))
risk=risk[sameSample, "riskScore"]
immune=immune[sameSample,]

#Էյ÷ֺϸԷ
x=as.numeric(risk)
x[x>quantile(x,0.99)]=quantile(x,0.99)
outTab=data.frame()
for(i in colnames(immune)){
	y=as.numeric(immune[,i])
	if(sd(y)<0.001){next}
	corT=cor.test(x, y, method="spearman")
	cor=corT$estimate
	pvalue=corT$p.value
	if(pvalue<0.05){
		outTab=rbind(outTab,cbind(immune=i, cor, pvalue))
		#ɢͼ
		outFile=paste0("cor.", i, ".pdf")
		outFile=gsub("/", "_", outFile)
		df1=as.data.frame(cbind(x,y))
		p1=ggplot(df1, aes(x, y)) + 
				  xlab("Risk score") + ylab(i)+
				  geom_point() + geom_smooth(method="lm",formula = y ~ x) + theme_bw()+
				  stat_cor(method = 'spearman', aes(x =x, y =y))
		#ͼ
		pdf(file=outFile, width=5, height=4.7)
		print(p1)
		dev.off()
	}
}
#Խ
write.table(file="corResult.txt", outTab, sep="\t", quote=F, row.names=F)

#ͼ
corResult=read.table("corResult.txt", head=T, sep="\t")
corResult$Software=sapply(strsplit(corResult[,1],"_"), '[', 2)
corResult$Software=factor(corResult$Software,level=as.character(unique(corResult$Software[rev(order(as.character(corResult$Software)))])))
b=corResult[order(corResult$Software),]
b$immune=factor(b$immune,levels=rev(as.character(b$immune)))
colslabels=rep(hue_pal()(length(levels(b$Software))),table(b$Software))     #ɫ
#ͼ
pdf(file="correlation.pdf", width=9, height=8)
ggplot(data=b, aes(x=cor, y=immune, color=Software))+
	labs(x="Correlation coefficient",y="Immune cell")+
	geom_point(size=4.1)+
	theme(panel.background=element_rect(fill="white",size=1,color="black"),
	      panel.grid=element_line(color="grey75",size=0.5),
	      axis.ticks = element_line(size=0.5),
	      axis.text.y = ggtext::element_markdown(colour=rev(colslabels)))
dev.off()


#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")

#install.packages("ggplot2")
#install.packages("ggpubr")


#ð
library(limma)
library(reshape2)
library(ggpubr)

corFilter=0.4                 #ϵ
pFilter=0.001                 #pvalue
riskFile="risk.TCGA.txt"      #ļ
immFile="infiltration_estimation_for_tcga.csv"     #ϸļ
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L50")     #ùĿ¼

#ȡļ
risk=read.table(riskFile, header=T, sep="\t", check.names=F, row.names=1)

#ȡϸļ
immune=read.csv(immFile, header=T, sep=",", check.names=F, row.names=1)
immune=as.matrix(immune)
rownames(immune)=gsub("(.*?)\\-(.*?)\\-(.*?)\\-(.*)", "\\1\\-\\2\\-\\3", rownames(immune))
immune=avereps(immune)

#ԷļϸļȡõƷ
sameSample=intersect(row.names(risk), row.names(immune))
geneExp=risk[sameSample, 3:(ncol(risk)-2), drop=F]
immune=immune[sameSample, ,drop=F]

#Իѭ
outTab=data.frame()
for(gene in colnames(geneExp)){
	x=as.numeric(geneExp[,gene])
	#ϸѭ
	for(i in colnames(immune)){
		y=as.numeric(immune[,i])
		if(sd(y)<0.001){next}
		corT=cor.test(x, y, method="spearman")
		cor=corT$estimate
		pvalue=corT$p.value
		if((abs(cor)>corFilter) & (pvalue<pFilter)){
			outTab=rbind(outTab,cbind(Gene=gene, immune=i, cor, pvalue))
			#ɢͼ
			outFile=paste0("cor.", gene, "_", i, ".pdf")
			outFile=gsub("/", "_", outFile)
			df1=as.data.frame(cbind(x,y))
			p1=ggplot(df1, aes(x, y)) + 
					  xlab(paste0(gene, " expression")) + ylab(i)+
					  geom_point() + geom_smooth(method="lm",formula = y ~ x) + theme_bw()+
					  stat_cor(method = 'spearman', aes(x =x, y =y))
			#ͼ
			pdf(file=outFile, width=5, height=4.6)
			print(p1)
			dev.off()
		}
	}
}
#ԵĽļ
write.table(file="corResult.txt", outTab, sep="\t", quote=F, row.names=F)


#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")

#install.packages("reshape2")
#install.packages("ggplot2")


#ð
library(limma)
library(reshape2)
library(ggplot2)

expFile="TCGA.normalize.txt"    #ļ
geneFile="gene.txt"             #߼бļ
riskFile="risk.TCGA.txt"        #ļ
setwd("F:\\ICDBLCA\\L51-")      #ùĿ¼

#ȡļ,ļ
rt=read.table(expFile, header=T, sep="\t", check.names=F)
rt=as.matrix(rt)
rownames(rt)=rt[,1]
exp=rt[,2:ncol(rt)]
dimnames=list(rownames(exp), colnames(exp))
data=matrix(as.numeric(as.matrix(exp)), nrow=nrow(exp), dimnames=dimnames)
data=avereps(data)

#ȡбļȡ߼ػı
geneRT=read.table(geneFile, header=F, sep="\t", check.names=F)
sameGene=intersect(as.vector(geneRT[,1]), rownames(data))
data=t(data[sameGene,])

#ȡļ
risk=read.table(riskFile, header=T, sep="\t", check.names=F, row.names=1)
sameSample=intersect(row.names(data), row.names(risk))
data=data[sameSample,,drop=F]
risk=risk[sameSample,3:(ncol(risk)-1),drop=F]

#Է
outTab=data.frame()
for(checkpiont in colnames(data)){
	for(gene in colnames(risk)){
		x=as.numeric(data[,checkpiont])
		y=as.numeric(risk[,gene])
		corT=cor.test(x,y,method="spearman")
		cor=corT$estimate
		pvalue=corT$p.value
		text=ifelse(pvalue<0.001,"***",ifelse(pvalue<0.01,"**",ifelse(pvalue<0.05,"*","")))
		outTab=rbind(outTab,cbind(Gene=gene, checkpiont=checkpiont, cor, text, pvalue))
	}
}

#ͼ
outTab$Gene=factor(outTab$Gene, levels=colnames(risk))
outTab$cor=as.numeric(outTab$cor)
pdf(file="checkpointCor.pdf", width=8, height=7)
ggplot(outTab, aes(Gene, checkpiont)) + 
	geom_tile(aes(fill = cor), colour = "grey", size = 1)+
	scale_fill_gradient2(low = "#5C5DAF", mid = "white", high = "#EA2E2D") + 
	geom_text(aes(label=text),col ="black",size = 3) +
	theme_minimal() +    #ȥ
	theme(axis.title.x=element_blank(), axis.ticks.x=element_blank(), axis.title.y=element_blank(),
	      axis.text.x = element_text(angle = 45, hjust = 1, size = 10, face = "bold"),   #x
	      axis.text.y = element_text(size = 10, face = "bold")) +       #y
	labs(fill =paste0("***  p<0.001","\n", "**  p<0.01","\n", " *  p<0.05","\n", "\n","Correlation")) +   #ͼ
	scale_x_discrete(position = "bottom")      #Xʾλ
dev.off()



#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")
#BiocManager::install("org.Hs.eg.db")
#BiocManager::install("DOSE")
#BiocManager::install("clusterProfiler")
#BiocManager::install("enrichplot")


#ð
library(limma)
library(org.Hs.eg.db)
library(clusterProfiler)
library(enrichplot)

gene="CALR"                #
expFile="TCGA.TPM.txt"     #ļ
gmtFile="c5.go.v7.4.symbols.gmt"     #ļ
setwd("E:\\00shengxin\\ICDBLCA\\L52")      #ùĿ¼

#ȡļ,ļ
rt=read.table(expFile, header=T, sep="\t", check.names=F)
rt=as.matrix(rt)
rownames(rt)=rt[,1]
exp=rt[,2:ncol(rt)]
dimnames=list(rownames(exp),colnames(exp))
data=matrix(as.numeric(as.matrix(exp)),nrow=nrow(exp),dimnames=dimnames)
data=avereps(data)
data=data[rowMeans(data)>0,]

#ɾƷ
group=sapply(strsplit(colnames(data),"\\-"), "[", 4)
group=sapply(strsplit(group,""), "[", 1)
group=gsub("2", "1", group)
data=data[,group==0]
data=t(data)
rownames(data)=gsub("(.*?)\\-(.*?)\\-(.*?)\\-.*", "\\1\\-\\2\\-\\3", rownames(data))
data=t(avereps(data))

#ĿƷз飬õߵͱlogFC
dataL=data[,data[gene,]<median(data[gene,]),drop=F]
dataH=data[,data[gene,]>=median(data[gene,]),drop=F]
meanL=rowMeans(dataL)
meanH=rowMeans(dataH)
meanL[meanL<0.00001]=0.00001
meanH[meanH<0.00001]=0.00001
logFC=log2(meanH)-log2(meanL)
logFC=sort(logFC,decreasing=T)
genes=names(logFC)

#ȡļ
gmt=read.gmt(gmtFile)

#
kk=GSEA(logFC, TERM2GENE=gmt, pvalueCutoff = 1)
kkTab=as.data.frame(kk)
kkTab=kkTab[kkTab$pvalue<0.05,]
#kkTab=kkTab[kkTab$p.adjust<0.05,]
write.table(kkTab,file="GSEA.result.txt",sep="\t",quote=F,row.names = F)
	
#GSEAͼ
termNum=8     #չʾͨ·Ŀ
if(nrow(kkTab)>=termNum){
	showTerm=row.names(kkTab)[1:termNum]
	gseaplot=gseaplot2(kk, showTerm, base_size=8, title=gene)
	pdf(file="GSEA.pdf", width=7.5, height=5.5)
	print(gseaplot)
	dev.off()
}



if (!requireNamespace("BiocManager", quietly = TRUE))
    install.packages("BiocManager")
BiocManager::install("limma")
BiocManager::install("GSEABase")
BiocManager::install("GSVA")

install.packages("reshape2")
install.packages("ggplot2")


#ð
library(limma)
library(GSEABase)
library(GSVA)
library(reshape2)
library(ggplot2)

expFile="TCGA.TPM.txt"      #ļ
riskFile="risk.TCGA.txt"    #ļ
gmtFile="Hallmark.gmt"          #ļ
setwd("E:\\00shengxin\\ICDBLCA\\L53")      #ùĿ¼

#ȡļ,ļ
rt=read.table(expFile, header=T, sep="\t", check.names=F)
rt=as.matrix(rt)
rownames(rt)=rt[,1]
exp=rt[,2:ncol(rt)]
dimnames=list(rownames(exp), colnames(exp))
data=matrix(as.numeric(as.matrix(exp)), nrow=nrow(exp), dimnames=dimnames)
data=avereps(data)

#GSVA
geneSets=getGmt(gmtFile, geneIdType=SymbolIdentifier())
gsvaResult=gsva(data, 
                geneSets, 
                min.sz=10, 
                max.sz=500, 
                verbose=TRUE,
                parallel.sz=1)
#gsvaOut=rbind(id=colnames(gsvaResult), gsvaResult)
#write.table(gsvaOut, file="gsvaOut.txt", sep="\t", quote=F, col.names=F)

#ɾƷ
data=t(gsvaResult)
group=sapply(strsplit(row.names(data),"\\-"), "[", 4)
group=sapply(strsplit(group,""), "[", 1)
group=gsub("2", "1", group)
data=data[group==0,]
row.names(data)=gsub("(.*?)\\-(.*?)\\-(.*?)\\-(.*?)\\-.*", "\\1\\-\\2\\-\\3", row.names(data))
data=avereps(data)

#ȡļ
risk=read.table(riskFile, header=T, sep="\t", check.names=F, row.names=1)
sameSample=intersect(row.names(data), row.names(risk))
data=data[sameSample,,drop=F]
risk=risk[sameSample,3:(ncol(risk)-1),drop=F]

#Է
outTab=data.frame()
for(Geneset in colnames(data)){
	for(gene in colnames(risk)){
		x=as.numeric(data[,Geneset])
		y=as.numeric(risk[,gene])
		corT=cor.test(x,y,method="spearman")
		cor=corT$estimate
		pvalue=corT$p.value
		text=ifelse(pvalue<0.001,"***",ifelse(pvalue<0.01,"**",ifelse(pvalue<0.05,"*","")))
		outTab=rbind(outTab,cbind(Gene=gene, Geneset=Geneset, cor, text, pvalue))
	}
}

#ͼ
outTab$Gene=factor(outTab$Gene, levels=colnames(risk))
outTab$cor=as.numeric(outTab$cor)
pdf(file="GSVAcor.pdf", width=10, height=9)
ggplot(outTab, aes(Gene, Geneset)) + 
	geom_tile(aes(fill = cor), colour = "grey", size = 1)+
	scale_fill_gradient2(low = "green2", mid = "white", high = "red2") + 
	geom_text(aes(label=text),col ="black",size = 3) +
	theme_minimal() +    #ȥ
	theme(axis.title.x=element_blank(), axis.ticks.x=element_blank(), axis.title.y=element_blank(),
	      axis.text.x = element_text(angle = 45, hjust = 1, size = 10, face = "bold"),   #x
	      axis.text.y = element_text(size = 10, face = "bold")) +       #y
	labs(fill =paste0("***  p<0.001","\n", "**  p<0.01","\n", " *  p<0.05","\n", "\n","Correlation")) +   #ͼ
	scale_x_discrete(position = "bottom")      #Xʾλ
dev.off()



#install.packages("ggpubr")


library(ggpubr)              #ð
tciaFile="TCIA.txt"          #TCIAļ
riskFile="risk.TCGA.txt"     #ļ
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L54")     #޸ĹĿ¼

#ȡTCIAļ
ips=read.table(tciaFile, header=T, sep="\t", check.names=F, row.names=1)

#ȡļ
risk=read.table(riskFile, header=T, sep="\t", check.names=F, row.names=1)
	
#ϲ
sameSample=intersect(row.names(ips), row.names(risk))
ips=ips[sameSample, , drop=F]
risk=risk[sameSample, "risk", drop=F]
data=cbind(ips, risk)
	
#ñȽ
data$risk=ifelse(data$risk=="high", "High-risk", "Low-risk")
group=levels(factor(data$risk))
data$risk=factor(data$risk, levels=c("Low-risk", "High-risk"))
group=levels(factor(data$risk))
comp=combn(group,2)
my_comparisons=list()
for(i in 1:ncol(comp)){my_comparisons[[i]]<-comp[,i]}

#TCIAֽѭ,ֱСͼ
for(i in colnames(data)[1:(ncol(data)-1)]){
	rt=data[,c(i, "risk")]
	colnames(rt)=c("IPS", "Risk")
	gg1=ggviolin(rt, x="Risk", y="IPS", fill = "Risk", 
	         xlab="", ylab=i,
	         legend.title="Risk",
	         add = "boxplot", add.params = list(fill="white"))+ 
	         stat_compare_means(comparisons = my_comparisons)
	         #stat_compare_means(comparisons = my_comparisons,symnum.args=list(cutpoints = c(0, 0.001, 0.01, 0.05, 1), symbols = c("***", "**", "*", "ns")),label = "p.signif")
	
	pdf(file=paste0(i, ".pdf"), width=6, height=5)
	print(gg1)
	dev.off()
}


#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install(c("car", "ridge", "preprocessCore", "genefilter", "sva"))

#install.packages("ggpubr")


#???e?
library(limma)
library(ggpubr)
library(pRRophetic)
library(ggplot2)
set.seed(12345)

pFilter=0.001                #pvalue?????????
expFile="TCGA.TPM.txt"       #???????????
riskFile="risk.TCGA.txt"     #???????
#setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L55")     #????????
allDrugs=c("A.443654", "A.770041", "ABT.263", "ABT.888", "AG.014699", "AICAR", "AKT.inhibitor.VIII", "AMG.706", "AP.24534", "AS601245", "ATRA", "AUY922", "Axitinib", "AZ628", "AZD.0530", "AZD.2281", "AZD6244", "AZD6482", "AZD7762", "AZD8055", "BAY.61.3606", "Bexarotene", "BI.2536", "BIBW2992", "Bicalutamide", "BI.D1870", "BIRB.0796", "Bleomycin", "BMS.509744", "BMS.536924", "BMS.708163", "BMS.754807", "Bortezomib", "Bosutinib", "Bryostatin.1", "BX.795", "Camptothecin", "CCT007093", "CCT018159", "CEP.701", "CGP.082996", "CGP.60474", "CHIR.99021", "CI.1040", "Cisplatin", "CMK", "Cyclopamine", "Cytarabine", "Dasatinib", "DMOG", "Docetaxel", "Doxorubicin", "EHT.1864", "Elesclomol", "Embelin", "Epothilone.B", "Erlotinib", "Etoposide", "FH535", "FTI.277", "GDC.0449", "GDC0941", "Gefitinib", "Gemcitabine", "GNF.2", "GSK269962A", "GSK.650394", "GW.441756", "GW843682X", "Imatinib", "IPA.3", "JNJ.26854165", "JNK.9L", "JNK.Inhibitor.VIII", "JW.7.52.1", "KIN001.135", "KU.55933", "Lapatinib", "Lenalidomide", "LFM.A13", "Metformin", "Methotrexate", "MG.132", "Midostaurin", "Mitomycin.C", "MK.2206", "MS.275", "Nilotinib", "NSC.87877", "NU.7441", "Nutlin.3a", "NVP.BEZ235", "NVP.TAE684", "Obatoclax.Mesylate", "OSI.906", "PAC.1", "Paclitaxel", "Parthenolide", "Pazopanib", "PD.0325901", "PD.0332991", "PD.173074", "PF.02341066", "PF.4708671", "PF.562271", "PHA.665752", "PLX4720", "Pyrimethamine", "QS11", "Rapamycin", "RDEA119", "RO.3306", "Roscovitine", "Salubrinal", "SB.216763", "SB590885", "Shikonin", "SL.0101.1", "Sorafenib", "S.Trityl.L.cysteine", "Sunitinib", "Temsirolimus", "Thapsigargin", "Tipifarnib", "TW.37", "Vinblastine", "Vinorelbine", "Vorinostat", "VX.680", "VX.702", "WH.4.023", "WO2009093972", "WZ.1.84", "X17.AAG", "X681640", "XMD8.85", "Z.LLNle.CHO", "ZM.447439")

#??????????????,?????????????
rt = read.table(expFile, header=T, sep="\t", check.names=F)
rt=as.matrix(rt)
rownames(rt)=rt[,1]
exp=rt[,2:ncol(rt)]
dimnames=list(rownames(exp),colnames(exp))
data=matrix(as.numeric(as.matrix(exp)),nrow=nrow(exp),dimnames=dimnames)
data=avereps(data)
data=data[rowMeans(data)>0.5,]

#??????????
group=sapply(strsplit(colnames(data),"\\-"), "[", 4)
group=sapply(strsplit(group,""), "[", 1)
group=gsub("2","1",group)
data=data[,group==0]
data=t(data)
rownames(data)=gsub("(.*?)\\-(.*?)\\-(.*?)\\-(.*)", "\\1\\-\\2\\-\\3", rownames(data))
data=avereps(data)
data=t(data)

#??????????????
riskRT=read.table(riskFile, header=T, sep="\t", check.names=F, row.names=1)

for(drug in allDrugs){
	#????????????
	senstivity=pRRopheticPredict(data, drug, selection=1)
	senstivity=senstivity[senstivity!="NaN"]
	#senstivity[senstivity>quantile(senstivity,0.99)]=quantile(senstivity,0.99)
	
	#????????????????????????
	sameSample=intersect(row.names(riskRT), names(senstivity))
	risk=riskRT[sameSample, "risk",drop=F]
	senstivity=senstivity[sameSample]
	rt=cbind(risk, senstivity)
	
	#????????
	rt$risk=factor(rt$risk, levels=c("low", "high"))
	type=levels(factor(rt[,"risk"]))
	comp=combn(type, 2)
	my_comparisons=list()
	for(i in 1:ncol(comp)){my_comparisons[[i]]<-comp[,i]}
	
	#???????????????pvalue
	test=wilcox.test(senstivity~risk, data=rt)
	
	if(test$p.value<pFilter){
		#?????????
		boxplot=ggboxplot(rt, x="risk", y="senstivity", fill="risk",
					      xlab="Risk",
					      ylab=paste0(drug, " senstivity (IC50)"),
					      legend.title="Risk",
					      palette=c("#0066FF","#FF0000")
					     )+ 
			stat_compare_means(comparisons=my_comparisons)
		pdf(file=paste0("durgSenstivity.", drug, ".pdf"), width=5, height=4.5)
		print(boxplot)
		dev.off()
	}
}

#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")

install.packages("reshape2")
install.packages("ggpubr")


#ð
library(limma)
library(reshape2)
library(ggpubr)

expFile="TCGA.TPM.txt"      #ݾ
geneFile="gene.txt"         #б
setwd("E:\\00shengxin\\ICDBLCA\\L56")       #ùĿ¼

#ȡļ
rt=read.table(expFile, header=T, sep="\t", check.names=F)
rt=as.matrix(rt)
rownames(rt)=rt[,1]
exp=rt[,2:ncol(rt)]
dimnames=list(rownames(exp), colnames(exp))
data=matrix(as.numeric(as.matrix(exp)), nrow=nrow(exp), dimnames=dimnames)
data=avereps(data)

#ȡϸı
gene=read.table(geneFile, header=T, sep="\t", check.names=F)
sameGene=intersect(as.vector(gene[,1]), row.names(data))
data=data[sameGene,]

#Ŀ
group=sapply(strsplit(colnames(data),"\\-"), "[", 4)
group=sapply(strsplit(group,""), "[", 1)
group=gsub("2", "1", group)
conNum=length(group[group==1])       #ƷĿ
treatNum=length(group[group==0])     #ƷĿ
sampleType=c(rep(1,conNum), rep(2,treatNum))

#ȡĻ
exp=log2(data+1)
exp=as.data.frame(t(exp))
exp=cbind(exp, Type=sampleType)
exp$Type=ifelse(exp$Type==1, "Normal", "Tumor")
sigGene=c()
for(i in colnames(exp)[1:(ncol(exp)-1)]){
	if(sd(exp[,i])<0.001){next}
	wilcoxTest=wilcox.test(exp[,i] ~ exp[,"Type"])
	pvalue=wilcoxTest$p.value
	if(wilcoxTest$p.value<0.05){
		sigGene=c(sigGene, i)
	}
}
sigGene=c(sigGene, "Type")
exp=exp[,sigGene]

#תggplot2ļ
data=melt(exp, id.vars=c("Type"))
colnames(data)=c("Type", "Gene", "Expression")

#ͼ
p=ggboxplot(data, x="Gene", y="Expression", color = "Type", 
	     ylab="Gene expression",
	     xlab="",
	     legend.title="Type",
	     palette = c("blue", "red"),
	     width=1)
p=p+rotate_x_text(60)
p1=p+stat_compare_means(aes(group=Type),
	      method="wilcox.test",
	      symnum.args=list(cutpoints = c(0, 0.001, 0.01, 0.05, 1), symbols = c("***", "**", "*", " ")),
	      label = "p.signif")

#ͼ
pdf(file="boxplot.pdf", width=9, height=6)
print(p1)
dev.off()


if (!requireNamespace("BiocManager", quietly = TRUE))
    install.packages("BiocManager")
BiocManager::install("limma")

if (!requireNamespace("BiocManager", quietly = TRUE))
    install.packages("BiocManager")
BiocManager::install("GSVA")

if (!requireNamespace("BiocManager", quietly = TRUE))
    install.packages("BiocManager")
BiocManager::install("GSEABase")

install.packages("ggpubr")
install.packages("reshape2")


#ð
library(limma)
library(GSVA)
library(GSEABase)
library(ggpubr)
library(reshape2)

expFile="symbol.txt"         #ļ
gmtFile="immune.gmt"         #ݼļ
riskFile="risk.TCGA.txt"     #ļ
setwd("E:\\00shengxin\\ICDBLCA\\L59")     #ùĿ¼

#ȡļļ
rt=read.table(expFile, header=T, sep="\t", check.names=F)
rt=as.matrix(rt)
rownames(rt)=rt[,1]
exp=rt[,2:ncol(rt)]
dimnames=list(rownames(exp),colnames(exp))
mat=matrix(as.numeric(as.matrix(exp)),nrow=nrow(exp),dimnames=dimnames)
mat=avereps(mat)
mat=mat[rowMeans(mat)>0,]
	
#ȡ߻ļ
geneSet=getGmt(gmtFile, geneIdType=SymbolIdentifier())
	
#ssgsea
ssgseaScore=gsva(mat, geneSet, method='ssgsea', kcdf='Gaussian', abs.ranking=TRUE)
#ssGSEA score
normalize=function(x){
	return((x-min(x))/(max(x)-min(x)))}
#ssGSEA scoreн
data=normalize(ssgseaScore)
ssgseaOut=rbind(id=colnames(data), data)
write.table(ssgseaOut, file="immFunScore.txt", sep="\t", quote=F, col.names=F)

#ȥƷ
group=sapply(strsplit(colnames(data),"\\-"), "[", 4)
group=sapply(strsplit(group,""), "[", 1)
group=gsub("2", "1", group)
data=t(data[,group==0])
rownames(data)=gsub("(.*?)\\-(.*?)\\-(.*?)\\-(.*?)\\-.*", "\\1\\-\\2\\-\\3", rownames(data))
data=avereps(data)

#ȡļ
risk=read.table(riskFile, header=T, sep="\t", check.names=F, row.names=1)
	
#ϲ
sameSample=intersect(row.names(data),row.names(risk))
data=data[sameSample,,drop=F]
risk=risk[sameSample,"Risk",drop=F]
rt1=cbind(data, risk)

#عܵͼ
data=melt(rt1, id.vars=c("Risk"))
colnames(data)=c("Risk","Type","Score")
data$Risk=factor(data$Risk, levels=c("low","high"))
p=ggboxplot(data, x="Type", y="Score", color = "Risk",
	        xlab="",ylab="Score",
	        palette = c("blue","red"), add = "none")
p=p+rotate_x_text(50)
p=p+stat_compare_means(aes(group=Risk),symnum.args=list(cutpoints = c(0, 0.001, 0.01, 0.05, 1), symbols = c("***", "**", "*", "")),label = "p.signif")

#ͼ
pdf(file="immFunction.pdf", width=8, height=6)
print(p)
dev.off()


#install.packages("ggpubr")


library(ggpubr)              #ð
tciaFile="TCIA.txt"          #TCIAļ
riskFile="risk.TCGA.txt"     #ļ
setwd("E:\\00shengxin\\ICDBLCA\\L60")     #޸ĹĿ¼

#ȡTCIAļ
ips=read.table(tciaFile, header=T, sep="\t", check.names=F, row.names=1)

#ȡļ
risk=read.table(riskFile, header=T, sep="\t", check.names=F, row.names=1)

#ϲ
sameSample=intersect(row.names(ips), row.names(risk))
ips=ips[sameSample, , drop=F]
risk=risk[sameSample, "risk", drop=F]
data=cbind(ips, risk)

#ñȽ
data$risk=ifelse(data$risk=="ICD high", "ICD High", "ICD Low")
group=levels(factor(data$risk))
data$risk=factor(data$risk, levels=c("ICD Low", "ICD High"))
group=levels(factor(data$risk))
comp=combn(group,2)
my_comparisons=list()
for(i in 1:ncol(comp)){my_comparisons[[i]]<-comp[,i]}

#TCIAֽѭ,ֱСͼ
for(i in colnames(data)[1:(ncol(data)-1)]){
  rt=data[,c(i, "risk")]
  colnames(rt)=c("IPS", "Risk")
  gg1=ggviolin(rt, x="Risk", y="IPS", fill = "Risk", 
               xlab="", ylab=i,
               legend.title="Group",
               add = "boxplot", add.params = list(fill="white"))+ 
    stat_compare_means(comparisons = my_comparisons)
  #stat_compare_means(comparisons = my_comparisons,symnum.args=list(cutpoints = c(0, 0.001, 0.01, 0.05, 1), symbols = c("***", "**", "*", "ns")),label = "p.signif")
  
  pdf(file=paste0(i, ".pdf"), width=6, height=5)
  print(gg1)
  dev.off()
}


#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")

#install.packages("ggpubr")


#ð
library(limma)
library(ggpubr)

riskFile="risk.TCGA.txt"      #ļ
cliFile="clinical.txt"           #ٴļ
setwd("E:\\00shengxin\\ICDBLCA\\L61")     #ùĿ¼

#ȡļ
risk=read.table(riskFile, header=T, sep="\t", check.names=F, row.names=1)
risk$riskScore[risk$riskScore>quantile(risk$riskScore,0.99)]=quantile(risk$riskScore,0.99)

#ȡٴļ
cli=read.table(cliFile, header=T, sep="\t", check.names=F, row.names=1)
cli[,"Age"]=ifelse(cli[,"Age"]=="unknow", "unknow", ifelse(cli[,"Age"]>65,">65","<=65"))

#ϲ
samSample=intersect(row.names(risk), row.names(cli))
risk=risk[samSample,"riskScore",drop=F]
cli=cli[samSample,,drop=F]
rt=cbind(risk, cli)

#ٴԷͼν
for(clinical in colnames(rt[,2:ncol(rt)])){
	data=rt[c("riskScore", clinical)]
	colnames(data)=c("riskScore", "clinical")
	data=data[(data[,"clinical"]!="unknow"),]
	#ñȽ
	group=levels(factor(data$clinical))
	data$clinical=factor(data$clinical, levels=group)
	comp=combn(group,2)
	my_comparisons=list()
	for(i in 1:ncol(comp)){my_comparisons[[i]]<-comp[,i]}
	#ͼ
	boxplot=ggboxplot(data, x="clinical", y="riskScore", color="clinical",
		          xlab=clinical,
		          ylab="Risk score",
		          legend.title=clinical,
		          add = "jitter")+ 
	    stat_compare_means(comparisons = my_comparisons)
	    #stat_compare_means(comparisons = my_comparisons,symnum.args=list(cutpoints = c(0, 0.001, 0.01, 0.05, 1), symbols = c("***", "**", "*", "ns")),label = "p.signif")
	#ͼƬ
	pdf(file=paste0("cliCor.", clinical, ".pdf"), width=5.5, height=5)
	print(boxplot)
	dev.off()
}

#install.packages("survival")
#install.packages("survminer")


#ð
library(survival)
library(survminer)
setwd("C:\\Users\\dengyan\\Desktop\\ICDBLCA\\L35\\GSE13507")     #ùĿ¼

#ĺ
bioSurvival=function(inputFile=null, outFile=null){
	#ȡļ
	rt=read.table(inputFile, header=T, sep="\t", check.names=F)
	#Ƚϸߵͷ죬õԵpvalue
	diff=survdiff(Surv(futime, fustat) ~ Risk,data = rt)
	pValue=1-pchisq(diff$chisq,df=1)
	if(pValue<0.001){
		pValue="p<0.001"
	}else{
		pValue=paste0("p=",sprintf("%.03f",pValue))
	}
	fit <- survfit(Surv(futime, fustat) ~ Risk, data = rt)
		
	#
	surPlot=ggsurvplot(fit, 
		           data=rt,
		           conf.int=F,
		           pval=pValue,
		           pval.size=6,
		           legend.title="Risk",
		           legend.labs=c("High risk", "Low risk"),
		           xlab="Time(years)",
		           ylab="Overall survival",
		           break.time.by = 2,
		           palette=c("red", "blue"),
		           risk.table=TRUE,
		           risk.table.title="",
		           risk.table.height=.25)
	#ͼ
	pdf(file=outFile, width=6, height=5, onefile=FALSE)
	print(surPlot)
	dev.off()
}

#ú,
bioSurvival(inputFile="risk.TCGA.txt", outFile="survival.TCGA.pdf")
bioSurvival(inputFile="risk.GEO.txt", outFile="survival.GEO.pdf")

#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")

#install.packages("reshape2")
#install.packages("ggpubr")


#ð
library(limma)
library(reshape2)
library(ggpubr)

riskFile="risk.TCGA.txt"       #ļ
scoreFile="TMEscores.txt"      #΢ļ
setwd("E:\\00shengxin\\ICDBLCA\\L63")     #ùĿ¼

#ȡļ
risk=read.table(riskFile, header=T, sep="\t", check.names=F, row.names=1)
risk$risk=factor(risk$risk, levels=c("low","high"))

#ȡ΢ļݽ
score=read.table(scoreFile, header=T, sep="\t", check.names=F, row.names=1)
score=as.matrix(score)
row.names(score)=gsub("(.*?)\\-(.*?)\\-(.*?)\\-(.*?)\\-.*", "\\1\\-\\2\\-\\3", row.names(score))
score=avereps(score)
score=score[,1:3]

#Ʒȡ
sameSample=intersect(row.names(risk), row.names(score))
risk=risk[sameSample,"risk",drop=F]
score=score[sameSample,,drop=F]
rt=cbind(risk, score)

#ϲתΪggplot2ļ
data=melt(rt, id.vars=c("risk"))
colnames(data)=c("Risk", "scoreType", "Score")

#Сͼ
p=ggviolin(data, x="scoreType", y="Score", fill = "Risk",
	     xlab="",
	     ylab="TME score",
	     legend.title="Risk",
	     add = "boxplot", add.params = list(color="white"),
	     palette = c("blue","red"), width=1)
p=p+rotate_x_text(45)
p1=p+stat_compare_means(aes(group=Risk),
	      method="wilcox.test",
	      symnum.args=list(cutpoints = c(0, 0.001, 0.01, 0.05, 1), symbols = c("***", "**", "*", " ")),
	      label = "p.signif")

#ͼ
pdf(file="vioplot.pdf", width=8, height=5)
print(p1)
dev.off()

#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")

#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("GSVA")

#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("GSEABase")

#install.packages("ggpubr")
#install.packages("reshape2")


#ð
library(limma)
library(GSVA)
library(GSEABase)
library(ggpubr)
library(reshape2)

expFile="symbol.txt"         #ļ
gmtFile="immune.gmt"         #ݼļ
riskFile="risk.TCGA.txt"     #ļ
setwd("E:\\00shengxin\\ICDBLCA\\L64")     #ùĿ¼

#ȡļļ
rt=read.table(expFile, header=T, sep="\t", check.names=F)
rt=as.matrix(rt)
rownames(rt)=rt[,1]
exp=rt[,2:ncol(rt)]
dimnames=list(rownames(exp),colnames(exp))
mat=matrix(as.numeric(as.matrix(exp)),nrow=nrow(exp),dimnames=dimnames)
mat=avereps(mat)
mat=mat[rowMeans(mat)>0,]
	
#ȡ߻ļ
geneSet=getGmt(gmtFile, geneIdType=SymbolIdentifier())
	
#ssgsea
ssgseaScore=gsva(mat, geneSet, method='ssgsea', kcdf='Gaussian', abs.ranking=TRUE)
#ssGSEA score
normalize=function(x){
	return((x-min(x))/(max(x)-min(x)))}
#ssGSEA scoreн
data=normalize(ssgseaScore)
ssgseaOut=rbind(id=colnames(data), data)
write.table(ssgseaOut, file="immFunScore.txt", sep="\t", quote=F, col.names=F)

#ȥƷ
group=sapply(strsplit(colnames(data),"\\-"), "[", 4)
group=sapply(strsplit(group,""), "[", 1)
group=gsub("2", "1", group)
data=t(data[,group==0])
rownames(data)=gsub("(.*?)\\-(.*?)\\-(.*?)\\-(.*?)\\-.*", "\\1\\-\\2\\-\\3", rownames(data))
data=avereps(data)

#ȡļ
risk=read.table(riskFile, header=T, sep="\t", check.names=F, row.names=1)
	
#ϲ
sameSample=intersect(row.names(data),row.names(risk))
data=data[sameSample,,drop=F]
risk=risk[sameSample,"Risk",drop=F]
rt1=cbind(data, risk)

#عܵͼ
data=melt(rt1, id.vars=c("Risk"))
colnames(data)=c("Risk","Type","Score")
data$Risk=factor(data$Risk, levels=c("ICD low","ICD high"))
p=ggboxplot(data, x="Type", y="Score", color = "Group",
	        xlab="",ylab="Score",
	        palette = c("blue","red"), add = "none")
p=p+rotate_x_text(50)
p=p+stat_compare_means(aes(group=Risk),symnum.args=list(cutpoints = c(0, 0.001, 0.01, 0.05, 1), symbols = c("***", "**", "*", "")),label = "p.signif")

#ͼ
pdf(file="immFunction.pdf", width=8, height=6)
print(p)
dev.off()

#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")

#install.packages("reshape2")
#install.packages("ggpubr")


#ð
library(limma)
library(reshape2)
library(ggpubr)

riskFile="risk.TCGA.txt"            #ļ
immFile="CIBERSORT-Results.txt"     #ϸļ
pFilter=0.05                        #ϸĹ
setwd("E:\\00shengxin\\ICDBLCA\\L65")      #ùĿ¼

#ȡϸļݽ
immune=read.table(immFile, header=T, sep="\t", check.names=F, row.names=1)
immune=immune[immune[,"P-value"]<pFilter,]
data=as.matrix(immune[,1:(ncol(immune)-3)])

#ɾƷ
group=sapply(strsplit(row.names(data),"\\-"), "[", 4)
group=sapply(strsplit(group,""), "[", 1)
group=gsub("2", "1", group)
data=data[group==0,]
row.names(data)=gsub("(.*?)\\-(.*?)\\-(.*?)\\-(.*?)\\-.*", "\\1\\-\\2\\-\\3", row.names(data))
data=avereps(data)

#ȡļ
risk=read.table(riskFile, header=T, sep="\t", check.names=F, row.names=1)
sameSample=intersect(row.names(data), row.names(risk))
rt=cbind(data[sameSample,,drop=F], risk[sameSample,"Risk",drop=F])
data=rt[order(rt$Risk, decreasing=T),]

#תggplot2ļ
data=melt(data, id.vars=c("Risk"))
colnames(data)=c("Risk", "Immune", "Expression")
#ͼ
group=levels(factor(data$Risk))
data$Risk=factor(data$Risk, levels=c("low","high"))
bioCol=c("#0066FF","#FF0000","#6E568C","#7CC767","#223D6C","#D20A13","#FFD121","#088247","#11AA4D")
bioCol=bioCol[1:length(group)]
boxplot=ggboxplot(data, x="Immune", y="Expression", fill="Risk",
				  xlab="",
				  ylab="Fraction",
				  legend.title="Risk",
				  width=0.8,
				  palette=bioCol)+
				  rotate_x_text(50)+
	stat_compare_means(aes(group=Risk),symnum.args=list(cutpoints=c(0, 0.001, 0.01, 0.05, 1), symbols=c("***", "**", "*", "")), label="p.signif")
#ͼƬ
pdf(file="immune.diff.pdf", width=8, height=6)
print(boxplot)
dev.off()

