clear all
load ('LS_MLdata.mat')

ml_edges =[0:0.1:1.2];
center_ml=conv2(ml_edges,[.5 .5],'valid');

ml_1=abs(ml_1);
[ls_ml]=histcounts(ml_1,ml_edges);
plot(center_ml,ls_ml/length(ml_1))
hold on;

ml_2=abs(ml_2);
[ls_ml_2]=histcounts(ml_2,ml_edges);
plot(center_ml,ls_ml_2/length(ml_2))

ml_3=abs(ml_3);
[ls_ml_3]=histcounts(ml_3,ml_edges);
plot(center_ml,ls_ml_3/length(ml_3))

concat_ml=[ls_ml_3/length(ml_3);ls_ml_2/length(ml_2);ls_ml/length(ml_1)];
sem=std(concat_ml)/sqrt(3);
plot(center_ml, mean(concat_ml))
hold on;
shadedErrorBar(center_ml,mean(concat_ml),sem)
ylim([0, 0.5])

%%
clear all
load ('LS_APdata.mat')
ap_edges =[-0.6:0.2:1.8];
center_ap=conv2(ap_edges,[.5 .5],'valid');

[ls_ap]=histcounts(ap_1,ap_edges);
plot(center_ap,ls_ap/length(ap_1))
hold on;

[ls_ap_2]=histcounts(ap_2,ap_edges);
plot(center_ap,ls_ap_2/length(ap_2))


[ls_ap_3]=histcounts(ap_3,ap_edges);
plot(center_ap,ls_ap_3/length(ap_3))

concat_ap=[ls_ap_3/length(ap_3);ls_ap_2/length(ap_2);ls_ap/length(ap_1)];
sem=std(concat_ap)/sqrt(3);
plot(center_ap, mean(concat_ap))
hold on;
shadedErrorBar(center_ap,mean(concat_ap),sem)
ylim([0, 0.5])
%%
clear all
load ('LS_DVdata.mat')
dv_edges =[-6:0.2:-2];
center_dv=conv2(dv_edges,[.5 .5],'valid');
[ls_dv]=histcounts(dv_1,dv_edges);
plot(center_dv,ls_dv/length(dv_1))
hold on;

[ls_dv_2]=histcounts(dv_2,dv_edges);
plot(center_dv,ls_dv_2/length(dv_2))

[ls_dv_3]=histcounts(dv_3,dv_edges);
plot(center_dv,ls_dv_3/length(dv_3))

concat_dv=[ls_dv_3/length(dv_3);ls_dv_2/length(dv_2);ls_dv/length(dv_1)];
sem=std(concat_dv)/sqrt(3);
plot(center_dv, mean(concat_dv))
hold on;
shadedErrorBar(center_dv,mean(concat_dv),sem)
ylim([0, 0.5])