function CheckCluster(self)
%
% CheckCluster(@Cluster)
%
% INPUTS
%
% OUTPUTS : none
%
% Shows key aspects to cluster for judging quality
%
% ADR 1998
% version L1.0
% RELEASED as part of MClust 2.0
% See standard disclaimer in Contents.m
% cowen
%
% Status: PROMOTED (Release version) 
% See documentation for copyright (owned by original authors) and warranties (none!).
% This code released as part of MClust 3.0.
% Version control M4.0.

% if its empty, return
if isempty(self.GetSpikes)
   return
end


MCD = MClust.GetData();
MCS = MClust.GetSettings();

StartTime = MCD.FeatureTimestamps(1);
EndTime = MCD.FeatureTimestamps(end);
text_font_size = 10;

ScSize = get(0, 'ScreenSize');
CheckClusterFigHandle = figure('Name', self.name, ...
    'NumberTitle', 'Off', 'Tag', MCS.DeletableFigureTag, ...
    'Position', [ ScSize(3)/4 1 ScSize(3)/2 ScSize(4)*0.9]);
figure(CheckClusterFigHandle)
colormap(1-gray);

nPlot = 4;
mPlot = 2;

T = self.GetSpikeTimes();
WV = self.GetWaveforms();

% PLOT: AvgWaveform
figure(CheckClusterFigHandle);
ax = subplot(nPlot,mPlot,1);
MClust.AverageWaveform(WV, 'axesHandle', ax);
drawnow

% PLOT: Cluster Stats (text)
msgstr = {sprintf('%s - %s', strrep(MCD.TTfn, '_', '-'), self.name)};
if isempty(getenv('USER'))
   msgstr{end+1} = sprintf('Cut on %s', date);
else   
   msgstr{end+1} = sprintf('Cut by %s on %s', getenv('USER'), date);
end
msgstr{end+1} = sprintf('%d spikes ', length(T.data));
msgstr{end+1} = sprintf('firing rate = %.4f spikes/sec ', 1./mean(diff(T.range())));

figure(CheckClusterFigHandle);
subplot(nPlot, mPlot, 2);
text(0,0.5, msgstr, 'FontSize',text_font_size, 'interpreter', 'none');
axis off
drawnow;

% PLOT: HistISI
figure(CheckClusterFigHandle);
ax = subplot(nPlot, mPlot, 3);
MClust.HistISI(T, 'axesHandle', ax);
drawnow; 

%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Peak Plot
%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure(CheckClusterFigHandle);
peaks = squeeze(max(WV.data,[],3));
if size(peaks,2)==4
    ax = subplot(nPlot, mPlot, 4);
    hold on
    H = plot(ax, ...
        peaks(:,2), peaks(:,1),'.', ...
        peaks(:,2),-peaks(:,3),'.', ...
        -peaks(:,4),-peaks(:,3),'.', ...
        -peaks(:,4), peaks(:,1),'.');
    plot(ax, [0 0], get(gca, 'YLim'), 'k-', get(gca, 'XLim'), [0 0], 'k-', 0,0,'+r');
    set(H, 'MarkerSize', 2);
    axis off;
    title('Peak Plot','FontSize',text_font_size);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%
% Time plot
%%%%%%%%%%%%%%%%%%%%%%%%%%
figure(CheckClusterFigHandle);
ax = subplot(nPlot, mPlot, 7:8);
plot(ax,T.data/60,peaks,'.');
set(gca,'FontSize',text_font_size);
set(gca,'XLim',[StartTime/60 EndTime/60]);
xlabel('Time (minutes)','FontSize',text_font_size);
ylabel('Peak','FontSize',text_font_size);
H = findobj(gca, 'Type', 'Line');
set(H, 'MarkerSize', 2);

% %%%%%%%%%%%%%%%%%%%%%%%%%%%
% % AutoCorrs
% %%%%%%%%%%%%%%%%%%%%%%%%%%%
figure(CheckClusterFigHandle);
ax = subplot(nPlot*2, mPlot, 9);
MClust.AutoCorr(T.data, 'binSize', 0.05, 'width', 10, 'axesHandle', ax);
ylabel('rate','FontSize',text_font_size);
title('Autocorrelation','FontSize',text_font_size);
drawnow;

figure(CheckClusterFigHandle);
figure(CheckClusterFigHandle);
ax = subplot(nPlot*2, mPlot, 11);
MClust.AutoCorr(T.data, 'binSize', 0.001, 'width', 0.05, 'axesHandle', ax);
title('');
xlabel('sec','FontSize',text_font_size);
ylabel('rate','FontSize',text_font_size);
drawnow;

% %%%%%%%%%%%%%%%%%%%%%%%%%%%
% % ClusterSeparation
% %%%%%%%%%%%%%%%%%%%%%%%%%%%
subplot(nPlot, mPlot, 6);
[LR, IsoD, ~, m] = self.CalculateLRatio_and_IsolationDistance();
msgstr = sprintf('(%.0f df) LR=%.2f; ID=%.0f', LR.df, LR.Lratio, IsoD);
inClu = false(MCD.nSpikes(),1);
inClu(self.GetSpikes()) = true;
boxplot(m, inClu, 'plotstyle', 'compact', ...
    'orientation', 'horizontal', 'labels', {'out','in'});
xlabel('Mahalanobis distance');
title(msgstr);
drawnow;

end