function PanelSelf(self, panel0, iC)
%
% Draw self on panel in a Cutter
%

MCS = MClust.GetSettings();

% hide
self.hideButton = ...
    uicontrol(panel0, 'Style', 'CheckBox', ...
	'Units', 'Normalized','Position', [0 0 0.1 1], ...
	'Value', self.hide, ...
	'HorizontalAlignment', 'right', ...
	'Tag', 'HideSelf', ...
	'Callback', @(src,event)ChangeHide(self));

% color
self.colorButton = ...
    uicontrol(panel0, 'Style', 'PushButton', ...
	'BackgroundColor', self.color, ...
	'ForegroundColor', 1-self.color, ...
	'Units', 'Normalized','Position', [0.1 0 0.1 1], ...
	'HorizontalAlignment', 'right', ...
	'Tag', 'ColorSelf', ...
	'Callback', @(src,event)ChangeColor(self));
if ~isempty(iC)
	set(self.colorButton, 'String', num2str(iC));
end

% Pulldown menu of cluster functions
string = cat(2, {self.name}, self.FindClusterFunctions());
self.ClusterFuncMenu = ...
	uicontrol(panel0, 'Style', 'CheckBox', ...
	'Units', 'Normalized','Position', [0.3 0 0.6 1], ...
	'Style', 'popupmenu', ...
	'Value', 1, 'String', string, ...
	'Tag', 'ClusterFcns', ...
	'Callback', @(src,event)CallClusterFunction(self));

% marker
uicontrol('Parent', panel0, ...
	'Units', 'Normalized', 'Position', [0.9 0 0.05 1], ...
	'Style', 'popupmenu', ...
	'Value', find(strcmp(self.marker, MCS.ClusterCutWindow_MarkerList)), ...
	'String', MCS.ClusterCutWindow_MarkerList, ...
	'Callback', @(src,event)ChangeMarker(self), ...
	'Tag', 'MarkerSelf', ...
	'TooltipString', 'Change marker');
uicontrol('Parent', panel0, ...
	'Units', 'Normalized', 'Position', [0.95 0 0.05 1], ...
	'Style', 'popupmenu', ...
	'Value', find(cellfun(@(x)eq(self.markerSize,x),MCS.ClusterCutWindow_MarkerSizeList)), ...
	'String', cellfun(@num2str,MCS.ClusterCutWindow_MarkerSizeList,'UniformOutput',false), ...
	'Tag', 'MarkerSizeSelf', ...
	'Callback', @(src,event)ChangeMarkerSize(self), ...
	'TooltipString', 'Change marker size');

end