function CreateMainWindow(self, MCS, MCD)

% MClustMainWindowClass : CreateMainWindow
%

self.MClustMainFigureHandle = figure(...
    'Name','MClust', ...
    'NumberTitle','off', ...
    'Tag','MClustMainWindow', ...,
    'Resize', 'Off', ...
    'Units', 'Normalized', ...
    'HandleVisibility', 'Callback', ...
    'DeleteFcn', @(src,event)ExitMClust(self));
pos = get(self.MClustMainFigureHandle, 'Position');
set(self.MClustMainFigureHandle, 'Position', [pos(1) pos(2)-.25 pos(3) pos(4)+.25]);

uicHeight = 0.04;
uicWidth  = 0.25;
dX = 0.3;
XLocs = 0.1:dX:0.9;
dY = 0.04;
YLocs = 0.9:-dY:0.1;
FrameBorder = 0.01;


% left frame
uicontrol('Parent', self.MClustMainFigureHandle, ...
    'Units', 'Normalized', 'Position', [XLocs(1)-FrameBorder YLocs(end)-FrameBorder dX 0.85+2*FrameBorder], ...
    'Style', 'frame');

% loading engines
self = self.FindAvailableLoadingEngines();
self.LoadingEnginePulldown = ...
    uicontrol('Parent', self.MClustMainFigureHandle, ...
    'Units', 'Normalized', 'Position', [XLocs(1) YLocs(1) uicWidth uicHeight], ...
    'Style', 'Popupmenu', 'Tag', 'SelectLoadingEngine', 'Callback', @(src,event)SelectLoadingEngine(self, src,event), ...
    'String', self.LoadingEngines, 'Value', self.LoadingEngineValue, ...
    'TooltipString', 'Select loading engine to use for input to MClust');
self.SelectLoadingEngine();  % set loading engine to first choice

% settings
self.LoadProfileButton = ...
    uicontrol('Parent', self.MClustMainFigureHandle, ...
    'Units', 'Normalized', 'Position', [XLocs(2) YLocs(20) uicWidth uicHeight], ...
    'Style', 'PushButton', 'Tag', 'LoadProfile', 'Callback', @(src,event)LoadProfile(self), ...
    'String', 'LoadProfile', 'TooltipString', 'Select a profile to load');
self.SaveProfileButton = ...
    uicontrol('Parent', self.MClustMainFigureHandle, ...
    'Units', 'Normalized', 'Position', [XLocs(2) YLocs(21) uicWidth uicHeight], ...
    'Style', 'PushButton', 'Tag', 'SaveProfile', 'Callback', @(src,event)SaveProfile(self), ...
    'String', 'SaveProfile', 'TooltipString', 'Save current settings for easy retrieval later.');

% Write Output
uicontrol('Parent', self.MClustMainFigureHandle, ...
    'Units', 'Normalized', 'Position', [XLocs(1) YLocs(15) uicWidth uicHeight], ...
    'BackgroundColor', [0.75 0.75 1],...
    'Style', 'PushButton', 'String', 'Write .t Files', 'Callback', @(src,event)WriteTfiles(self), ...
    'TooltipString', 'Write out T files, w/ clusters file');
uicontrol('Parent', self.MClustMainFigureHandle, ...
    'Units', 'Normalized', 'Position', [XLocs(1) YLocs(16) uicWidth uicHeight], ...
    'BackgroundColor', [0.75 0.75 1],...
    'Style', 'PushButton', 'String', 'Write .t, WV, CQ', 'Callback', @(src,event)WriteTWVCQfiles(self), ...
    'TooltipString', 'Write out T files, WV files, CQ files, and clusters file');

uicontrol('Parent', self.MClustMainFigureHandle, ...
    'Units', 'Normalized', 'Position', [XLocs(1) YLocs(18) uicWidth uicHeight], ...
    'BackgroundColor', [1 0.5 0.5],...
    'Style', 'PushButton', 'String', 'Erase .t, WV, CQ', 'Callback', @(src,event)EraseTfiles(self), ...
    'TooltipString', 'Erase previously saved T files, WV files, CQ files, and clusters file');

% exit
uicontrol('Parent', self.MClustMainFigureHandle, ...
    'Units', 'Normalized', 'Position', [XLocs(1) YLocs(20) uicWidth uicHeight], ...
    'Style', 'PushButton', 'String', 'Exit', 'Tag', 'ExitOnlyButton', 'Callback', @(src,event)ExitMClust(self), ...
    'TooltipString', 'Exit MClust');


% onward
self.TTfnLabel = ...
    uicontrol('Parent', self.MClustMainFigureHandle, ...
    'Units', 'Normalized', 'Position', [XLocs(1) YLocs(3) uicWidth uicHeight], ...
    'Style', 'Text', 'String', '', 'Tag', 'TTFileName','BackGroundColor',[0.7 0.7 0.7]);
self.nClustersText = ...
	uicontrol('Parent', self.MClustMainFigureHandle, ...
	'Units', 'Normalized', 'Position', [XLocs(1) YLocs(4) uicWidth uicHeight], ...
	'Style', 'text', 'BackgroundColor', [0 0 0], 'ForegroundColor', [1 1 1], ...
	'String', '');
addlistener(MCD, 'Clusters', 'PostSet', @(src,event)ResetClusterText(self));

self.FDCheckBox = ...
    uicontrol('Parent', self.MClustMainFigureHandle, ...
    'Units', 'Normalized', 'Position', [XLocs(1) YLocs(5) uicWidth uicHeight], ...
    'Style', 'CheckBox', 'String', 'Create/Load FD files (*.fd)', 'Tag', 'LoadFeaturesButton', ...
    'Callback', @(src,event)LoadTetrodeData(self), ...
    'TooltipString', 'Choose tetrode .dat or feature data file to use as input to MClust');

% feature listboxes
self.FeatureListBoxes = MClustUtils.ListboxPair(self.MClustMainFigureHandle, ...
    [XLocs(2) YLocs(9) 2*uicWidth 9*uicHeight], 'FeaturesToSkip', 'FeaturesToUse', ...
    'leftToolTip', 'Features that will NOT be included.', ...
    'rightToolTip', 'Features to be included in processing.', ...
	'secondaryCallback', @(src,event)ChangeFeaturesToUse(self));

% Paramters (normalize, channel validity, use _t)
self.NormalizeFeaturesButton = ...
    uicontrol('Parent', self.MClustMainFigureHandle, ...
    'Units', 'Normalized', 'Position', [XLocs(2) YLocs(10) 2*uicWidth uicHeight], ...
    'Style', 'CheckBox', 'String', 'NormalizeFeatures', 'Tag', 'NormalizeFeaturesButton', ...
    'Value', false, 'Enable', 'off', ...
    'TooltipString', 'Normalizing features has been removed from MClust 4.0.');

ChannelValidityPanel = uipanel('Parent', self.MClustMainFigureHandle, ...
    'Units', 'Normalized', 'Position', [XLocs(2) YLocs(11) 2*uicWidth uicHeight]);

for iV = 1:MCS.nCh
    self.ChannelValidityButton{iV} = ...
        uicontrol('Parent', ChannelValidityPanel, ...
        'Units', 'Normalized', 'Position', [(iV-1)/MCS.nCh 0 1/MCS.nCh 1], ...
        'Style', 'CheckBox', 'String', 'NormalizeFeatures', 'Tag', ['CV' num2str(iV)], ...
        'TooltipString', 'Channel validity for calculating features.', ...
        'String', ['Ch ' num2str(iV)], 'Callback', @(src,event)ChangeChannelValidity(self));
end

self.t_tButton = ...
    uicontrol('Parent', self.MClustMainFigureHandle, ...
    'Units', 'Normalized', 'Position', [XLocs(2) YLocs(12) 2*uicWidth uicHeight], ...
    'Style', 'CheckBox', 'Value', MCS.UseUnderscoreT, 'Callback', @(src,event)ChangeT_T(self), ...
    'String', 'Use "_t"', 'TooltipString', 'Mark some clusters as poor cuts.');

% Cutters
uicontrol('Parent', self.MClustMainFigureHandle, ...
    'Units', 'Normalized', 'Position', [XLocs(1) YLocs(8) uicWidth uicHeight], ...
    'Style', 'PushButton', 'String', 'Select from KKwik', 'Tag', 'KKwik Cutter', ...
    'BackgroundColor', [0.5 1 0.5], ...
    'Callback', @(src,event)RunKKwikCutter(self), ...
	'Tooltip', 'Select Clusters from those generated by KKwik.');

uicontrol('Parent', self.MClustMainFigureHandle, ...
    'Units', 'Normalized', 'Position', [XLocs(1) YLocs(9) uicWidth uicHeight], ...
    'Style', 'PushButton', 'String', 'Run SPC', 'Tag', 'SPC Cutter', ...
    'BackgroundColor', [0.5 1 0.5], ...
    'Callback', @(src,event)RunSpcCutter(self), ...
	'Tooltip', 'Select Clusters from those found by SPC.');

uicontrol('Parent', self.MClustMainFigureHandle, ...
    'Units', 'Normalized', 'Position', [XLocs(1) YLocs(10) uicWidth uicHeight], ...
    'BackgroundColor', [0.5 1 0.5], ...
    'Style', 'PushButton', 'String', 'ManualCut', 'Tag', 'Manual Cutter', ...
    'Callback', @(src,event)RunManualCutter(self), ...
	'Tooltip', 'Manually cut clusters.');

% Clusters
uicontrol('Parent', self.MClustMainFigureHandle, ...
    'Units', 'Normalized', 'Position', [XLocs(2) YLocs(14) uicWidth uicHeight], ...
    'Style', 'PushButton', 'String', 'Load Clusters',  ...
    'Callback', @(src,event)LoadClusters(self), ...
    'TooltipString', 'Load clusters - replaces clusters in memory');
uicontrol('Parent', self.MClustMainFigureHandle, ...
    'Units', 'Normalized', 'Position', [XLocs(3) YLocs(14) uicWidth uicHeight], ...
    'Style', 'PushButton', 'String', 'ApplyCvxHulls',  ...
    'Callback', @(src,event)ApplyConvexHulls(self), ...
    'TooltipString', 'Applies convex hulls from another data set - appends clusters');

uicontrol('Parent', self.MClustMainFigureHandle, ...
    'Units', 'Normalized', 'Position', [XLocs(2) YLocs(15) uicWidth uicHeight], ...
    'Style', 'PushButton', 'String', 'Save Clusters',  ...
    'Callback', @(src,event)SaveClusters(self), ...
    'TooltipString', 'Save Clusters to file');
uicontrol('Parent', self.MClustMainFigureHandle, ...
    'Units', 'Normalized', 'Position', [XLocs(2) YLocs(16) uicWidth uicHeight], ...
    'Style', 'PushButton', 'String', 'Clear Clusters',  ...
    'Callback', @(src,event)ClearClusters(self), ...
    'TooltipString', 'Remove all clusters.');


% Clear
uicontrol('Parent', self.MClustMainFigureHandle, ...
    'Units', 'Normalized', 'Position', [XLocs(2) YLocs(18) uicWidth uicHeight], ...
    'Style', 'PushButton', 'String', 'Clear Workspace',  ...
    'Callback', @(src,event)ClearWorkspace(self), ...
    'TooltipString', 'Remove all clusters and feature data files currently in memory');

% label display
uicontrol('Parent', self.MClustMainFigureHandle, ...
    'Units', 'Normalized', 'Position', [XLocs(3) YLocs(end) uicWidth 5*uicHeight], ...
    'Style', 'text', ...
    'String', self.AboutString);

self.Redraw();
end