function [WidthData, WidthNames,WidthPars] = feature_HalfWidth(V, ttChannelValidity, Params)
% WARINNING!!!Perposed for special usage, DONT run as regular usage.
%
% MClust
% [PeakData, PeakNames] = feature_HalfWidth(V, ttChannelValidity)
% Calculate the width cross between 1/2 (peak to valley high).
%
%
% INPUTS
%    V = TT tsd
%    ttChannelValidity = nCh x 1 of booleans
%
% OUTPUTS
%    Data - nSpikes x nCh peak values
%    Names - "Peak6to11: Ch"
%

% by CXF, 2017-8-5



TTData = V.data();

[nSpikes, nCh, nSamp] = size(TTData);


f = find(ttChannelValidity);


WidthData = zeros(nSpikes, length(f));

WidthNames = cell(length(f), 1);
WidthPars = {};

for iCh = 1:length(f)
    w = squeeze(TTData(:, f(iCh), :));
    [val_max, ind_max] = max(squeeze(TTData(:, f(iCh), :)), [], 2);
    [val_min, ind_min] = min(squeeze(TTData(:, f(iCh), :)), [], 2);
    val_mid = 0.5*(val_max + val_min);
    for iTrial = 1:nSpikes
        w_now = w(iTrial, :);
        val_mid_now = val_mid(iTrial, :);
        ind_min_now = ind_min(iTrial, :);
        ind_cor1 = find(w_now(1:ind_min_now) > val_mid_now, 1, 'last') +1;
        ind_cor2 = find(w_now(ind_min_now:end) > val_mid_now, 1, 'first') + ind_min_now - 1;
        if isempty(ind_cor1) || isempty(ind_cor2)
            WidthData(iTrial,iCh) = nan;
        else
            WidthData(iTrial,iCh) = ind_cor2 - ind_cor1;
        end
    end
end

for iCh = 1:length(f)
   WidthNames{iCh} = ['Half_Width: ' num2str(f(iCh))];
end
