function [PeakData, PeakNames,PeakPars] = feature_PeaktoValleyWidth(V, ttChannelValidity, Params)
% WARINNING!!!Perposed for special usage, DONT run as regular usage.
%
% MClust
% [PeakData, PeakNames] = feature_PeaktoValleyWidth(V, ttChannelValidity)
% Calculate peak to valley width.
%
% INPUTS
%    V = TT tsd
%    ttChannelValidity = nCh x 1 of booleans
%
% OUTPUTS
%    Data - nSpikes x nCh peak values
%    Names - "Peak6to11: Ch"
%

% by CXF, 2017-8-5



TTData = V.data();

[nSpikes, nCh, nSamp] = size(TTData);


f = find(ttChannelValidity);


PeakData = zeros(nSpikes, length(f));

PeakNames = cell(length(f), 1);
PeakPars = {};

[~,Imax] = max(TTData(:, f, :), [], 3);
[~,Imin] = min(TTData(:, f, :), [], 3);
PeakData = squeeze(Imax - Imin);

for iCh = 1:length(f)
   PeakNames{iCh} = ['PeaktoValley_W: ' num2str(f(iCh))];
end
