%% Set parameters
time = (1:1:length(SPKC14))*SPKC14_ts_step/60;

roi_time{1} = [20 40];
roi_time{2} = [80 100];

%% Plot

fig_name  = 'Chan01';
spkc_data = SPKC14;

fig = figure('name',fig_name,'numbertitle','off');

subplot(2,1,1)
plot(time,spkc_data,'k');
xlabel('Time (min)','fontsize',10);ylabel('Amplitude','fontsize',10);
xlim([0 20]);
ylim([-0.5 0.5]);

subplot(2,2,3);
roi_segment = time > roi_time{1}(1) & time < roi_time{1}(2);
plot(time(roi_segment),spkc_data(roi_segment),'k');
xlabel('Time (min)','fontsize',8);ylabel('Amplitude','fontsize',8);
xlim([roi_time{1}(1) roi_time{1}(2)]);
ylim([-1 1]);
subplot(2,2,4)
roi_segment = time > roi_time{2}(1) & time < roi_time{2}(2);
plot(time(roi_segment),spkc_data(roi_segment),'k');
xlabel('Time (min)','fontsize',8);ylabel('Amplitude','fontsize',8);
xlim([roi_time{2}(1) roi_time{2}(2)]);
 ylim([-1 1]);
 

