function varargout = spike_event(varargin)
% SPIKE_EVENT MATLAB code for spike_event.fig
%      SPIKE_EVENT, by itself, creates a new SPIKE_EVENT or raises the existing
%      singleton*.
%
%      H = SPIKE_EVENT returns the handle to a new SPIKE_EVENT or the handle to
%      the existing singleton*.
%
%      SPIKE_EVENT('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in SPIKE_EVENT.M with the given input arguments.
%
%      SPIKE_EVENT('Property','Value',...) creates a new SPIKE_EVENT or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before spike_event_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to spike_event_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help spike_event

% Last Modified by GUIDE v2.5 28-Jan-2021 16:28:30

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @spike_event_OpeningFcn, ...
                   'gui_OutputFcn',  @spike_event_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before spike_event is made visible.
function spike_event_OpeningFcn(hObject, ~, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to spike_event (see VARARGIN)

% Choose default command line output for spike_event
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes spike_event wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = spike_event_OutputFcn(~, ~, handles) 

varargout{1} = handles.output;


% --- Executes on button press in pushbutton2.
function pushbutton2_Callback(~, ~, handles)
% hObject    handle to pushbutton2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
global endfileName Effectchannels alldata fs
flag=1;
if flag==0
   set(handles.text1,'String','Unable to find the key !','BackgroundColor','red');
%    ha=get(h,'children'); 
%    hu=findall(allchild(h),'style','pushbutton');
%    set(hu,'string','OK');
%    ht=findall(ha,'type','text');
%    set(ht,'fontsize',15,'fontname','Microsoft Yahei');   
else
    [endfileName,pathName]=uigetfile({'*.btn';'*.plx'}) ;
    btnfilename = [pathName,endfileName];
    if endfileName==0
        set(handles.text1,'String','No File');
    else
        set(handles.text1,'String',endfileName);%,'BackgroundColor','w');
        try
            %%%% spkdata.usech>1,<32
            alldata.spkdata.usech=1:32;
            alldata.spkdata=readBTNspike(btnfilename,alldata.spkdata);
            
            %%%% spkdata.usech>1,<32
            alldata.slowdata=[];
            alldata.slowdata.userawch=[];
            alldata.slowdata.usespkcch=1:32;
            alldata.slowdata.uselfpch=[];
            alldata.slowdata.useAnach=[];
            alldata.slowdata=readBTNdata(btnfilename,alldata.slowdata);

            fs=30000;
            
            [m1,~]=size(alldata.slowdata.data);
            if m1==1
                alldata.slowdata.data=alldata.slowdata.data';
            end

            Effectchannels=ReadEffctCh(alldata,fs);
            adnames=alldata.slowdata.names(Effectchannels,:);
            
            set(handles.popupmenu1,'string',adnames);
            


        catch
            set(handles.text1,'String','Finding data has some errors!');
        end
    end
end


% --- Executes on button press in pushbutton3.
function pushbutton3_Callback(~, ~, handles)
% hObject    handle to pushbutton3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


global Effectchannels ich alldata startime endtime
ich=Effectchannels(get(handles.popupmenu1,'value'));
startime=datenum(alldata.slowdata.DateTime,'mm/dd/yyyy HH:MM:SS');
endtime=startime+alldata.spkdata.Duration/24/60/60;
set(handles.text2,'string',[datestr(startime,'mm/dd/yyyy HH:MM:SS'),'----',datestr(endtime,'mm/dd/yyyy HH:MM:SS')])


strtime.year=get(handles.timepop1,'string');
strtime.month=get(handles.timepop2,'string');
strtime.date=get(handles.timepop3,'string');
strtime.hour=get(handles.timepop4,'string');
strtime.minute=get(handles.timepop5,'string');
strtime.second=get(handles.timepop6,'string');
if str2num(strtime.year{1,:})<str2num(strtime.year{2,:})
    set(handles.timepop1,'string',[datestr(startime,'yyyy');strtime.year]);
    set(handles.timepop2,'string',[datestr(startime,'mm');strtime.month]);
    set(handles.timepop3,'string',[datestr(startime,'dd');strtime.date]);
    set(handles.timepop4,'string',[datestr(startime,'HH');strtime.hour]);
    set(handles.timepop5,'string',[datestr(startime,'MM');strtime.minute]);
    set(handles.timepop6,'string',[datestr(startime,'SS');strtime.second]);
    set(handles.timepop7,'string',[datestr(endtime,'yyyy');strtime.year]);
    set(handles.timepop8,'string',[datestr(endtime,'mm');strtime.month]);
    set(handles.timepop9,'string',[datestr(endtime,'dd');strtime.date]);
    set(handles.timepop10,'string',[datestr(endtime,'HH');strtime.hour]);
    set(handles.timepop11,'string',[datestr(endtime,'MM');strtime.minute]);
    set(handles.timepop12,'string',[datestr(endtime,'SS');strtime.second]);
end



function pushbutton1_Callback(~, ~, handles)
global alldata fs ich startime endtime endfileName
set(handles.pushbutton1,'UserData',1);
tag=0;
[numstartime,numendtime,tag]=timechange(handles,startime,endtime,endfileName,tag);
if tag==1
    return
else
    index_time_a=(numstartime-startime)*60*60*24;
    index_time_b=(numendtime-startime)*60*60*24;

    data_spike=alldata.slowdata.data{ich,1};
    x_time=(0:1:length(data_spike)-1)./fs;
    data_spike_choose=data_spike(x_time>index_time_a&x_time<=index_time_b);
    x_time_choose=(x_time(x_time>index_time_a&x_time<=index_time_b))./60./60./24+startime;

    figure
    plot(x_time_choose,data_spike_choose)
    datetick('x')
    xlim([x_time_choose(1)-1/30000/24/60/60,x_time_choose(end)+1/30000/24/60/60])


    p1max=max(data_spike_choose);
    p2max=p1max*1.5;


    [~,n2]=size(alldata.spkdata.ts);

    for i=1:n2
        check1=alldata.spkdata.ts(1,i);
        if check1{1,1}==-1
            n2=i-1;
            break
        end
    end

    for itype=1:n2
        time=alldata.spkdata.ts(ich,itype);
        time=time{1,1};
        time=(time(time>index_time_a&time<=index_time_b))./60./60./24+startime;
        if itype==1
            icolor='k';
        elseif itype==2
            icolor='m';
        elseif itype==3
            icolor='b';
        elseif itype==4
            icolor='c';
        elseif itype==5
            icolor='r';
        else
            icolor='g';
        end
        hold on
        for itime=1:length(time)
            plot([time(itime);time(itime)],[p1max;p2max],icolor)
        end
        hold off
        if itype==n2
            break
        end
    end
end



% --- Executes on selection change in timepop1.
function timepop1_Callback(~, ~, ~)


% --- Executes during object creation, after setting all properties.
function timepop1_CreateFcn(hObject, ~, ~)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in timepop2.
function timepop2_Callback(~, ~, ~)


% --- Executes during object creation, after setting all properties.
function timepop2_CreateFcn(hObject, ~, ~)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in timepop7.
function popupmenu3_Callback(~, ~, ~)
% hObject    handle to timepop7 (see GCBO)


% --- Executes during object creation, after setting all properties.
function popupmenu3_CreateFcn(hObject, ~, ~)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in timepop8.
function popupmenu4_Callback(~, ~, ~)


% --- Executes during object creation, after setting all properties.
function popupmenu4_CreateFcn(hObject, ~, ~)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in timepop9.
function popupmenu5_Callback(~, ~, ~)



function popupmenu5_CreateFcn(hObject, ~, ~)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function popupmenu6_Callback(~, ~, ~)



function popupmenu6_CreateFcn(hObject, ~, ~)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function popupmenu1_Callback(~, ~, ~)


function popupmenu1_CreateFcn(hObject, ~, ~)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function timepop7_Callback(~, ~, ~)


function timepop7_CreateFcn(hObject, ~, ~)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in timepop8.
function timepop8_Callback(~, ~, ~)




function timepop8_CreateFcn(hObject, ~, ~)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in timepop9.
function timepop9_Callback(~, ~, ~)


% --- Executes during object creation, after setting all properties.
function timepop9_CreateFcn(hObject, ~, ~)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in timepop10.
function timepop10_Callback(~, ~, ~)


% --- Executes during object creation, after setting all properties.
function timepop10_CreateFcn(hObject, ~, ~)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in timepop11.
function timepop11_Callback(~, ~, ~)


% --- Executes during object creation, after setting all properties.
function timepop11_CreateFcn(hObject, ~, ~)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in timepop12.
function timepop12_Callback(~, ~, ~)


% --- Executes during object creation, after setting all properties.
function timepop12_CreateFcn(hObject, ~, ~)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes during object creation, after setting all properties.
function text1_CreateFcn(~, ~, ~)


% --- Executes during object creation, after setting all properties.
function text2_CreateFcn(~, ~, ~)
% hObject    handle to text2 (see GCBO)


% --- Executes on selection change in timepop3.
function timepop3_Callback(~, ~, ~)

function timepop3_CreateFcn(hObject, ~, ~)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in timepop4.
function timepop4_Callback(~, ~, ~)


% --- Executes during object creation, after setting all properties.
function timepop4_CreateFcn(hObject, ~, ~)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in timepop5.
function timepop5_Callback(~, ~, ~)

% --- Executes during object creation, after setting all properties.
function timepop5_CreateFcn(hObject, ~, ~)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in timepop6.
function timepop6_Callback(~, ~, ~)


% --- Executes during object creation, after setting all properties.
function timepop6_CreateFcn(hObject, ~, ~)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes during object creation, after setting all properties.
function pushbutton1_CreateFcn(~, ~, ~)
